/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.BucketedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.solve.Linear3SystemSolver;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import it.unimi.dsi.util.concurrent.ReorderingBlockingQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GOVMinimalPerfectHashFunction128<T>
extends AbstractHashFunction<T>
implements Serializable {
    public static final long serialVersionUID = 6L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GOVMinimalPerfectHashFunction128.class);
    private static final LongArrayBitVector END_OF_SOLUTION_QUEUE = LongArrayBitVector.getInstance();
    private static final BucketedHashStore.Bucket END_OF_BUCKET_QUEUE = new BucketedHashStore.Bucket();
    private static final long SEED_STEP = 0x100000000000000L;
    private static final long OFFSET_MASK = 0xFFFFFFFFFFFFFFL;
    private static double C = 1.1;
    private static int C_TIMES_256 = (int)Math.floor(C * 256.0);
    public static final String NUMBER_OF_THREADS_PROPERTY = "it.unimi.dsi.sux4j.mph.threads";
    public static final int BUCKET_SIZE = 1500;
    private final long multiplier;
    protected final long n;
    protected final long globalSeed;
    protected final long[] edgeOffsetAndSeed;
    protected final LongBigList values;
    protected final LongArrayBitVector bitVector;
    protected transient long[] array;
    protected final TransformationStrategy<? super T> transform;
    protected final long signatureMask;
    protected final LongBigList signatures;

    public static final int countNonzeroPairs(long x) {
        return Long.bitCount((x | x >>> 1) & 0x5555555555555555L);
    }

    private static final long countNonzeroPairs(long start, long end, long[] array) {
        int block = (int)(start >>> 5);
        int endBlock = (int)(end >>> 5);
        int startOffset = (int)(start & 0x1FL);
        int endOffset = (int)(end & 0x1FL);
        if (block == endBlock) {
            return GOVMinimalPerfectHashFunction128.countNonzeroPairs((array[block] & (1L << (endOffset << 1)) - 1L) >>> (startOffset << 1));
        }
        long pairs = 0L;
        if (startOffset != 0) {
            pairs += (long)GOVMinimalPerfectHashFunction128.countNonzeroPairs(array[block++] >>> (startOffset << 1));
        }
        while (block < endBlock) {
            pairs += (long)GOVMinimalPerfectHashFunction128.countNonzeroPairs(array[block++]);
        }
        if (endOffset != 0) {
            pairs += (long)GOVMinimalPerfectHashFunction128.countNonzeroPairs(array[block] & (1L << (endOffset << 1)) - 1L);
        }
        return pairs;
    }

    protected static long vertexOffset(long edgeOffsetSeed) {
        return (edgeOffsetSeed & 0xFFFFFFFFFFFFFFL) * (long)C_TIMES_256 >> 8;
    }

    protected GOVMinimalPerfectHashFunction128(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, int signatureWidth, File tempDir, BucketedHashStore<T> bucketedHashStore) throws IOException {
        boolean givenBucketedHashStore;
        this.transform = transform;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        pl.itemsName = "keys";
        boolean bl = givenBucketedHashStore = bucketedHashStore != null;
        if (bucketedHashStore == null) {
            bucketedHashStore = new BucketedHashStore<T>(transform, tempDir, pl);
            bucketedHashStore.reset(r.nextLong());
            bucketedHashStore.addAll(keys.iterator());
        }
        this.n = bucketedHashStore.size();
        this.defRetValue = -1L;
        bucketedHashStore.bucketSize(1500);
        int numBuckets = (int)(this.n / 1500L + 1L);
        this.multiplier = (long)numBuckets * 2L;
        LOGGER.debug("Number of buckets: " + numBuckets);
        this.edgeOffsetAndSeed = new long[numBuckets + 1];
        this.bitVector = LongArrayBitVector.getInstance((long)(2L * (1L + (this.n * (long)C_TIMES_256 >> 8))));
        int duplicates = 0;
        while (true) {
            LOGGER.debug("Generating minimal perfect hash function...");
            pl.expectedUpdates = numBuckets;
            pl.itemsName = "buckets";
            pl.start((CharSequence)"Analysing buckets... ");
            AtomicLong unsolvable = new AtomicLong();
            AtomicLong unorientable = new AtomicLong();
            try {
                int numberOfThreads = Integer.parseInt(System.getProperty(NUMBER_OF_THREADS_PROPERTY, Integer.toString(Math.min(4, Runtime.getRuntime().availableProcessors()))));
                ArrayBlockingQueue bucketQueue = new ArrayBlockingQueue(numberOfThreads * 8);
                ReorderingBlockingQueue queue = new ReorderingBlockingQueue(numberOfThreads * 128);
                ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads + 2);
                ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
                executorCompletionService.submit(() -> {
                    LongArrayBitVector data;
                    while ((data = (LongArrayBitVector)queue.take()) != END_OF_SOLUTION_QUEUE) {
                        this.bitVector.append((BitVector)data);
                    }
                    return null;
                });
                BucketedHashStore<Object> chs = bucketedHashStore;
                executorCompletionService.submit(() -> {
                    try {
                        Iterator<BucketedHashStore.Bucket> iterator = chs.iterator();
                        int i1 = 0;
                        while (iterator.hasNext()) {
                            BucketedHashStore.Bucket bucket = new BucketedHashStore.Bucket(iterator.next());
                            assert (i1 == bucket.index());
                            long[] lArray = this.edgeOffsetAndSeed;
                            // MONITORENTER : this.edgeOffsetAndSeed
                            this.edgeOffsetAndSeed[i1 + 1] = this.edgeOffsetAndSeed[i1] + (long)bucket.size();
                            assert (this.edgeOffsetAndSeed[i1 + 1] <= 0x100000000000000L);
                            // MONITOREXIT : lArray
                            bucketQueue.put(bucket);
                            ++i1;
                        }
                        return null;
                    }
                    finally {
                        int i2 = numberOfThreads;
                        while (true) {
                            if (i2-- == 0) {
                            }
                            bucketQueue.put(END_OF_BUCKET_QUEUE);
                        }
                    }
                });
                AtomicInteger activeThreads = new AtomicInteger(numberOfThreads);
                int i = numberOfThreads;
                while (i-- != 0) {
                    executorCompletionService.submit(() -> {
                        Thread.currentThread().setPriority(1);
                        long bucketTime = 0L;
                        long outputTime = 0L;
                        while (true) {
                            LongBigList dataList;
                            LongArrayBitVector dataBitVector;
                            long[] solution;
                            BucketedHashStore.Bucket bucket;
                            block9: {
                                long start = System.nanoTime();
                                bucket = (BucketedHashStore.Bucket)bucketQueue.take();
                                bucketTime += System.nanoTime() - start;
                                if (bucket == END_OF_BUCKET_QUEUE) {
                                    if (activeThreads.decrementAndGet() == 0) {
                                        queue.put((Object)END_OF_SOLUTION_QUEUE, (long)numBuckets);
                                    }
                                    LOGGER.debug("Queue waiting time: " + Util.format((double)((double)bucketTime / 1.0E9)) + "s");
                                    LOGGER.debug("Output waiting time: " + Util.format((double)0.0) + "s");
                                    return null;
                                }
                                long seed = 0L;
                                long off = GOVMinimalPerfectHashFunction128.vertexOffset(this.edgeOffsetAndSeed[bucket.index()]);
                                Linear3SystemSolver solver = new Linear3SystemSolver((int)(GOVMinimalPerfectHashFunction128.vertexOffset(this.edgeOffsetAndSeed[bucket.index() + 1]) - off), bucket.size());
                                do {
                                    boolean solved22 = solver.generateAndSolve(bucket, seed, null);
                                    unorientable.addAndGet(solver.unorientable);
                                    unsolvable.addAndGet(solver.unsolvable);
                                    if (!solved22) continue;
                                    long[] solved22 = this.edgeOffsetAndSeed;
                                    // MONITORENTER : this.edgeOffsetAndSeed
                                    int n = bucket.index();
                                    this.edgeOffsetAndSeed[n] = this.edgeOffsetAndSeed[n] | seed;
                                    // MONITOREXIT : solved22
                                    solution = solver.solution;
                                    dataBitVector = LongArrayBitVector.ofLength((long)(solution.length * 2));
                                    dataList = dataBitVector.asLongBigList(2);
                                    break block9;
                                } while ((seed += 0x100000000000000L) != 0L);
                                throw new AssertionError((Object)"Exhausted local seeds");
                            }
                            for (int j = 0; j < solution.length; ++j) {
                                dataList.set((long)j, solution[j]);
                            }
                            queue.put((Object)dataBitVector, (long)bucket.index());
                            ProgressLogger progressLogger = pl;
                            // MONITORENTER : progressLogger
                            pl.update();
                            // MONITOREXIT : progressLogger
                        }
                    });
                }
                try {
                    i = numberOfThreads + 2;
                    while (i-- != 0) {
                        executorCompletionService.take().get();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof BucketedHashStore.DuplicateException) {
                        throw (BucketedHashStore.DuplicateException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                finally {
                    executorService.shutdown();
                }
                long orientable = unsolvable.get() + (long)numBuckets;
                LOGGER.info("Unsolvable systems: " + unsolvable.get() + "/" + orientable + " (" + Util.format((double)(100.0 * (double)unsolvable.get() / (double)orientable)) + "%)");
                LOGGER.info("Unorientable systems: " + unorientable.get() + "/" + (orientable + unorientable.get()) + " (" + Util.format((double)(100.0 * (double)unorientable.get() / (double)(orientable + unorientable.get()))) + "%)");
                pl.done();
            }
            catch (BucketedHashStore.DuplicateException e) {
                if (keys == null) {
                    throw new IllegalStateException("You provided no keys, but the bucketed hash store was not checked");
                }
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing signatures...");
                bucketedHashStore.reset(r.nextLong());
                pl.itemsName = "keys";
                bucketedHashStore.addAll(keys.iterator());
                Arrays.fill(this.edgeOffsetAndSeed, 0L);
                continue;
            }
            break;
        }
        this.globalSeed = bucketedHashStore.seed();
        this.values = this.bitVector.asLongBigList(2);
        this.values.add(0L);
        this.array = this.bitVector.bits();
        LOGGER.info("Completed.");
        LOGGER.debug("Forecast bit cost per key: " + 2.0 * C + 0.042666666666666665);
        LOGGER.info("Actual bit cost per key: " + (double)this.numBits() / (double)this.n);
        if (signatureWidth != 0) {
            this.signatureMask = -1L >>> -signatureWidth;
            this.signatures = LongArrayBitVector.getInstance().asLongBigList(signatureWidth);
            this.signatures.size(this.n);
            pl.expectedUpdates = this.n;
            pl.itemsName = "signatures";
            pl.start((CharSequence)"Signing...");
            for (BucketedHashStore.Bucket bucket : bucketedHashStore) {
                Iterator<long[]> iterator = bucket.iterator();
                int i = bucket.size();
                while (i-- != 0) {
                    long[] signature = iterator.next();
                    int[] e = new int[3];
                    this.signatures.set(this.getLongBySignatureNoCheck(signature, e), this.signatureMask & signature[0]);
                    pl.lightUpdate();
                }
            }
            pl.done();
        } else {
            this.signatureMask = 0L;
            this.signatures = null;
        }
        if (!givenBucketedHashStore) {
            bucketedHashStore.close();
        }
    }

    public long numBits() {
        return this.values.size64() * 2L + (long)this.edgeOffsetAndSeed.length * 64L;
    }

    public long getLong(Object key) {
        long[] signature = new long[2];
        Hashes.spooky4(this.transform.toBitVector(key), this.globalSeed, signature);
        return this.getLongBySignature(signature);
    }

    public long getLongBySignature(long[] signature) {
        int[] e = new int[3];
        int bucket = (int)Math.multiplyHigh(signature[0] >>> 1, this.multiplier);
        long edgeOffsetSeed = this.edgeOffsetAndSeed[bucket];
        long bucketOffset = GOVMinimalPerfectHashFunction128.vertexOffset(edgeOffsetSeed);
        int numVariables = (int)(GOVMinimalPerfectHashFunction128.vertexOffset(this.edgeOffsetAndSeed[bucket + 1]) - bucketOffset);
        Linear3SystemSolver.signatureToEquation(signature, edgeOffsetSeed & 0xFF00000000000000L, numVariables, e);
        long result = (edgeOffsetSeed & 0xFFFFFFFFFFFFFFL) + GOVMinimalPerfectHashFunction128.countNonzeroPairs(bucketOffset, bucketOffset + (long)e[(int)(this.values.getLong((long)e[0] + bucketOffset) + this.values.getLong((long)e[1] + bucketOffset) + this.values.getLong((long)e[2] + bucketOffset)) % 3], this.array);
        if (this.signatureMask != 0L) {
            return result >= this.n || this.signatures.getLong(result) != (signature[0] & this.signatureMask) ? this.defRetValue : result;
        }
        return result < this.n ? result : this.defRetValue;
    }

    private long getLongBySignatureNoCheck(long[] signature, int[] e) {
        int bucket = (int)Math.multiplyHigh(signature[0] >>> 1, this.multiplier);
        long edgeOffsetSeed = this.edgeOffsetAndSeed[bucket];
        long bucketOffset = GOVMinimalPerfectHashFunction128.vertexOffset(edgeOffsetSeed);
        Linear3SystemSolver.signatureToEquation(signature, edgeOffsetSeed & 0xFF00000000000000L, (int)(GOVMinimalPerfectHashFunction128.vertexOffset(this.edgeOffsetAndSeed[bucket + 1]) - bucketOffset), e);
        return (edgeOffsetSeed & 0xFFFFFFFFFFFFFFL) + GOVMinimalPerfectHashFunction128.countNonzeroPairs(bucketOffset, bucketOffset + (long)e[(int)(this.values.getLong((long)e[0] + bucketOffset) + this.values.getLong((long)e[1] + bucketOffset) + this.values.getLong((long)e[2] + bucketOffset)) % 3], this.array);
    }

    @Override
    public long size64() {
        return this.n;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.array = this.bitVector.bits();
    }

    public void dump(String file) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.edgeOffsetAndSeed.length * 8 + 32).order(ByteOrder.nativeOrder());
        FileOutputStream fos = new FileOutputStream(file);
        FileChannel channel = fos.getChannel();
        buffer.clear();
        buffer.putLong(this.size64());
        buffer.putLong(this.multiplier);
        buffer.putLong(this.globalSeed);
        buffer.putLong(this.edgeOffsetAndSeed.length);
        for (long l : this.edgeOffsetAndSeed) {
            buffer.putLong(l);
        }
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        buffer.putLong(this.array.length);
        for (long l : this.array) {
            if (!buffer.hasRemaining()) {
                buffer.flip();
                channel.write(buffer);
                buffer.clear();
            }
            buffer.putLong(l);
        }
        buffer.flip();
        channel.write(buffer);
        fos.close();
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(GOVMinimalPerfectHashFunction128.class.getName(), "Builds a minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new FlaggedOption("signatureWidth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 's', "signature-width", "If specified, the signature width in bits."), new UnflaggedOption("n", (StringParser)JSAP.LONG_PARSER, JSAP.NO_DEFAULT, true, false, "The number of keys in the minimal perfect hash function."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised minimal perfect hash function.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        final long n = jsapResult.getLong("n");
        File tempDir = jsapResult.getFile("tempDir");
        int signatureWidth = jsapResult.getInt("signatureWidth", 0);
        Iterable iterable = () -> new Iterator<BitVector>(){
            private final XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator(0L);
            private int i = 0;
            private final LongArrayBitVector bv = LongArrayBitVector.ofLength((long)128L);
            private final long[] bits = this.bv.bits();

            @Override
            public boolean hasNext() {
                return (long)this.i < n;
            }

            @Override
            public BitVector next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.bits[0] = this.r.nextLong();
                this.bits[1] = this.r.nextLong();
                ++this.i;
                return this.bv;
            }
        };
        BinIO.storeObject(new GOVMinimalPerfectHashFunction128(iterable, TransformationStrategies.identity(), signatureWidth, tempDir, null), (CharSequence)functionName);
        LOGGER.info("Saved.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected int signatureWidth;
        protected File tempDir;
        protected BucketedHashStore<T> bucketedHashStore;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> signed(int signatureWidth) {
            this.signatureWidth = signatureWidth;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(BucketedHashStore<T> bucketedHashStore) {
            this.bucketedHashStore = bucketedHashStore;
            return this;
        }

        public GOVMinimalPerfectHashFunction128<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            if (this.transform == null) {
                if (this.bucketedHashStore != null) {
                    this.transform = this.bucketedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given BucketedHashStore");
                }
            }
            return new GOVMinimalPerfectHashFunction128<T>(this.keys, this.transform, this.signatureWidth, this.tempDir, this.bucketedHashStore);
        }
    }
}

