/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;

public class FunctionSpeedTest {
    private static final int NUM_WARMUPS = 4;
    private static final int NUM_SAMPLES = 11;

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(FunctionSpeedTest.class.getName(), "Tests the speed of a function on character sequences. Sequential tests (the default) read keys from disk, whereas random tests cache keys in a contiguous region of memory. Performs a few warmup repetitions, and then the median of a sample is printed on standard output. The detailed results are logged to standard error.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new Switch("random", 'r', "random", "Test a subset of strings cached contiguously in memory."), new Switch("shuffle", 'S', "shuffle", "Shuffle the subset of strings used for random tests."), new FlaggedOption("n", (StringParser)JSAP.INTSIZE_PARSER, "1000000", false, 'n', "number-of-strings", "The (maximum) number of strings used for random testing."), new FlaggedOption("save", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 's', "save", "In case of a random test, save to this file the strings used."), new Switch("check", 'c', "check", "Check that each string in the list is mapped to its ordinal position."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "Read strings from this file.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean check = jsapResult.getBoolean("check");
        boolean shuffle = jsapResult.getBoolean("shuffle");
        boolean random = jsapResult.getBoolean("random");
        String save = jsapResult.getString("save");
        int maxStrings = jsapResult.getInt("n");
        if (check && random) {
            throw new IllegalArgumentException("You cannot perform checks in random tests");
        }
        if (shuffle && !random) {
            throw new IllegalArgumentException("You can shuffle random tests only");
        }
        if (jsapResult.userSpecified("n") && !random) {
            throw new IllegalArgumentException("The number of string is meaningful for random tests only");
        }
        if (save != null && !random) {
            throw new IllegalArgumentException("You can save test string only for random tests");
        }
        Object2LongFunction function = (Object2LongFunction)BinIO.loadObject((CharSequence)functionName);
        FileLinesCollection flc = new FileLinesCollection((CharSequence)stringFile, encoding.name(), zipped);
        long size = flc.size();
        if (random) {
            int n = (int)Math.min((long)maxStrings, size);
            MutableString[] test = new MutableString[n];
            int step = (int)(size / (long)n) - 1;
            FileLinesCollection.FileLinesIterator iterator = flc.iterator();
            for (int i = 0; i < n; ++i) {
                test[i] = new MutableString((CharSequence)iterator.next());
                int j = step;
                while (j-- != 0) {
                    iterator.next();
                }
            }
            if (shuffle) {
                Collections.shuffle(Arrays.asList(test));
            }
            if (save != null) {
                PrintStream ps = new PrintStream(save, encoding.name());
                for (MutableString s : test) {
                    s.println(ps);
                }
                ps.close();
            }
            int[] length = new int[n];
            int totalLength = 0;
            for (int i = 0; i < n; ++i) {
                length[i] = test[i].length();
                totalLength += length[i];
            }
            char[] a = new char[totalLength];
            int s = 0;
            for (int i = 0; i < n; ++i) {
                System.arraycopy(test[i].array(), 0, a, s, length[i]);
                s += length[i];
            }
            System.gc();
            System.gc();
            long t = -1L;
            long[] sample = new long[11];
            System.err.println("Warmup...");
            int k = 15;
            while (k-- != 0) {
                long time = -System.nanoTime();
                int s2 = 0;
                for (int i = 0; i < n; ++i) {
                    t ^= function.getLong((Object)new MutableString(a, s2, length[i]));
                    s2 += length[i];
                    if ((i & 0xFFFFF) != 0) continue;
                    System.err.print('.');
                }
                System.err.println();
                time += System.nanoTime();
                if (k < 11) {
                    sample[k] = time;
                }
                System.err.println(Util.format((double)((double)time / 1.0E9)) + "s, " + Util.format((double)((double)time / (double)n)) + " ns/item");
                if (k != 11) continue;
                System.err.println("Sampling " + n + " strings...");
            }
            LongArrays.quickSort((long[])sample);
            System.out.println("Median: " + Util.format((double)((double)sample[5] / 1.0E9)) + "s, " + Util.format((double)((double)sample[5] / (double)n)) + " ns/item");
            if (t == 0L) {
                System.err.println(t);
            }
        } else {
            System.gc();
            System.gc();
            long t = -1L;
            long[] sample = new long[11];
            System.err.println("Warmup...");
            int k = 15;
            while (k-- != 0) {
                FileLinesCollection.FileLinesIterator iterator = flc.iterator();
                long time = -System.nanoTime();
                for (long i = 0L; i < size; ++i) {
                    long index = function.getLong(iterator.next());
                    t ^= index;
                    if (check && index != i) {
                        throw new AssertionError((Object)(index + " != " + i));
                    }
                    if ((i & 0xFFFFFL) != 0L) continue;
                    System.err.print('.');
                }
                System.err.println();
                time += System.nanoTime();
                if (k < 11) {
                    sample[k] = time;
                }
                System.err.println(Util.format((double)((double)time / 1.0E9)) + "s, " + Util.format((double)((double)time / (double)size)) + " ns/item");
                if (k != 11) continue;
                System.err.println("Scanning " + size + " strings...");
            }
            LongArrays.quickSort((long[])sample);
            System.out.println("Median: " + Util.format((double)((double)sample[5] / 1.0E9)) + "s, " + Util.format((double)((double)sample[5] / (double)size)) + " ns/item");
            if (t == 0L) {
                System.err.println(t);
            }
        }
    }
}

