/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;

public class EliasFanoMonotoneLongBigListSpeedTest {
    public static void main(String[] arg) throws JSAPException {
        int i;
        long time;
        SimpleJSAP jsap = new SimpleJSAP(EliasFanoMonotoneLongBigListSpeedTest.class.getName(), "Tests the speed Elias-Fano monotone lists.", new Parameter[]{new UnflaggedOption("numElements", (StringParser)JSAP.INTSIZE_PARSER, "1Mi", false, false, "The number of elements."), new UnflaggedOption("density", (StringParser)JSAP.DOUBLE_PARSER, ".5", false, false, "The density."), new FlaggedOption("numPos", (StringParser)JSAP.INTSIZE_PARSER, "1Mi", false, 'p', "positions", "The number of positions to test"), new FlaggedOption("bulk", (StringParser)JSAP.INTSIZE_PARSER, "10", false, 'b', "bulk", "The number of positions to read with the bulk method")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int numElements = jsapResult.getInt("numElements");
        double density = jsapResult.getDouble("density");
        int numPos = jsapResult.getInt("numPos");
        int bulk = jsapResult.getInt("bulk");
        XoRoShiRo128PlusRandomGenerator random = new XoRoShiRo128PlusRandomGenerator(42L);
        IntArrayList list = new IntArrayList(numElements);
        long i2 = numElements;
        while (i2-- != 0L) {
            list.add(random.nextDouble() < density ? 0 : 100);
        }
        int[] position = new int[numPos];
        int i3 = numPos;
        while (i3-- != 0) {
            position[i3] = (random.nextInt() & Integer.MAX_VALUE) % (numElements - bulk);
        }
        long[] elements = new long[list.size()];
        elements[0] = list.getInt(0);
        for (int i4 = 1; i4 < list.size(); ++i4) {
            elements[i4] = (long)list.getInt(i4) + elements[i4 - 1];
        }
        EliasFanoMonotoneLongBigList eliasFanoMonotoneLongBigList = new EliasFanoMonotoneLongBigList((LongIterable)LongArrayList.wrap((long[])elements));
        long u = 0L;
        System.err.println("getLong():");
        int k = 10;
        while (k-- != 0) {
            time = -System.nanoTime();
            for (int i5 = 0; i5 < numPos; ++i5) {
                u += eliasFanoMonotoneLongBigList.getLong(position[i5]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)numPos + " ns/element");
        }
        long[] dest = new long[bulk];
        System.err.println("get():");
        int k2 = 10;
        while (k2-- != 0) {
            time = -System.nanoTime();
            for (i = 0; i < numPos; ++i) {
                eliasFanoMonotoneLongBigList.get(position[i], dest);
                u += dest[0];
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)(numPos * bulk) + " ns/element");
        }
        System.err.println("getDelta():");
        k2 = 10;
        while (k2-- != 0) {
            time = -System.nanoTime();
            for (i = 0; i < numPos; ++i) {
                u += eliasFanoMonotoneLongBigList.getDelta(position[i]);
            }
            System.err.println((double)(time += System.nanoTime()) / 1.0E9 + "s, " + (double)time / (double)(numPos * bulk) + " ns/element");
        }
        if (u == 0L) {
            System.out.println();
        }
    }
}

