/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.scratch;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import java.math.BigInteger;

public class NumberToBitVector
implements TransformationStrategy<BigInteger> {
    private static final long serialVersionUID = 1L;
    private final int width;

    public NumberToBitVector(int width) {
        this.width = width;
    }

    public TransformationStrategy<BigInteger> copy() {
        return new NumberToBitVector(this.width);
    }

    public long numBits() {
        return 0L;
    }

    public long length(BigInteger x) {
        return this.width;
    }

    public BitVector toBitVector(BigInteger x) {
        LongArrayBitVector res = LongArrayBitVector.getInstance((long)this.width);
        for (int i = 0; i < this.width; ++i) {
            res.add(x.testBit(this.width - i - 1));
        }
        return res;
    }

    public static void main(String[] arg) {
        NumberToBitVector ntbv = new NumberToBitVector(15);
        System.out.println(ntbv.toBitVector(new BigInteger("567")));
    }
}

