/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.scratch;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MergedBitVectorIterator
implements ObjectIterator<BitVector> {
    private final Iterator<? extends BitVector> it0;
    private final Iterator<? extends BitVector> it1;
    private BitVector curr0;
    private BitVector curr1;
    private final LongArrayBitVector result;

    public MergedBitVectorIterator(Iterator<? extends BitVector> it0, Iterator<? extends BitVector> it1) {
        this.it0 = it0;
        this.it1 = it1;
        this.result = LongArrayBitVector.getInstance();
        if (it0.hasNext()) {
            this.curr0 = it0.next();
        }
        if (it1.hasNext()) {
            this.curr1 = it1.next();
        }
    }

    public boolean hasNext() {
        return this.curr0 != null || this.curr1 != null;
    }

    public BitVector next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.curr0 == null) {
            this.result.replace(this.curr1);
            this.curr1 = this.it1.hasNext() ? this.it1.next() : null;
        } else if (this.curr1 == null) {
            this.result.replace(this.curr0);
            this.curr0 = this.it0.hasNext() ? this.it0.next() : null;
        } else {
            int cmp = this.curr0.compareTo((Object)this.curr1);
            if (cmp < 0) {
                this.result.replace(this.curr0);
                this.curr0 = this.it0.hasNext() ? this.it0.next() : null;
            } else if (cmp > 0) {
                this.result.replace(this.curr1);
                this.curr1 = this.it1.hasNext() ? this.it1.next() : null;
            } else {
                this.result.replace(this.curr1);
                this.curr0 = this.it0.hasNext() ? this.it0.next() : null;
                this.curr1 = this.it1.hasNext() ? this.it1.next() : null;
            }
        }
        return this.result;
    }
}

