/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.scratch;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;

public class EliasFanoMonotoneLongBigListTables
extends AbstractLongBigList
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final int LOG_2_QUANTUM = 9;
    protected final long length;
    protected final int l;
    protected final long mask;
    protected final long[] lowerBits;
    protected final long[] upperBits;
    protected final long[] skipToOne;
    protected final long[] skipToZero;
    protected final int quantum;
    protected final int log2Quantum;

    protected EliasFanoMonotoneLongBigListTables(long length, int l, long[] skipToOne, long[] skipToZero, long[] upperBits, long[] lowerBits) {
        this.length = length;
        this.l = l;
        this.mask = (1L << l) - 1L;
        this.lowerBits = lowerBits;
        this.upperBits = upperBits;
        this.skipToOne = skipToOne;
        this.skipToZero = skipToZero;
        this.log2Quantum = 9;
        this.quantum = 512;
    }

    public EliasFanoMonotoneLongBigListTables(IntIterable list) {
        this(() -> LongIterators.wrap((IntIterator)list.iterator()));
    }

    public EliasFanoMonotoneLongBigListTables(ShortIterable list) {
        this(() -> LongIterators.wrap((ShortIterator)list.iterator()));
    }

    public EliasFanoMonotoneLongBigListTables(ByteIterable list) {
        this(() -> LongIterators.wrap((ByteIterator)list.iterator()));
    }

    public EliasFanoMonotoneLongBigListTables(LongIterable list) {
        this(EliasFanoMonotoneLongBigListTables.computeParameters(list.iterator()), list.iterator());
    }

    private static long[] computeParameters(LongIterator iterator) {
        long v = -1L;
        long prev = -1L;
        long c = 0L;
        while (iterator.hasNext()) {
            v = iterator.nextLong();
            if (prev > v) {
                throw new IllegalArgumentException("The list of values is not monotone: " + prev + " > " + v);
            }
            prev = v;
            ++c;
        }
        return new long[]{c, v};
    }

    public EliasFanoMonotoneLongBigListTables(long n, long upperBound, ByteIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ByteIterator)iterator));
    }

    public EliasFanoMonotoneLongBigListTables(long n, long upperBound, ShortIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ShortIterator)iterator));
    }

    public EliasFanoMonotoneLongBigListTables(long n, long upperBound, IntIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((IntIterator)iterator));
    }

    public EliasFanoMonotoneLongBigListTables(long n, long upperBound, LongIterator iterator) {
        this(new long[]{n, upperBound}, iterator);
    }

    protected EliasFanoMonotoneLongBigListTables(long[] a, LongIterator iterator) {
        this.length = a[0];
        this.log2Quantum = 9;
        this.quantum = 512;
        long v = -1L;
        long upperBound = a[1];
        this.l = this.length == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(upperBound / this.length)));
        this.mask = (1L << this.l) - 1L;
        long lowerBitsMask = (1L << this.l) - 1L;
        LongArrayBitVector lowerBitVector = LongArrayBitVector.getInstance();
        LongBigList lowerBitsList = lowerBitVector.asLongBigList(this.l);
        lowerBitsList.size(this.length);
        LongArrayBitVector upperBitVector = LongArrayBitVector.getInstance().length(this.length + (upperBound >>> this.l) + 1L);
        long last = Long.MIN_VALUE;
        for (long i = 0L; i < this.length; ++i) {
            v = iterator.nextLong();
            if (v > upperBound) {
                throw new IllegalArgumentException("Too large value: " + v + " > " + upperBound);
            }
            if (v < last) {
                throw new IllegalArgumentException("Values are not nondecreasing: " + v + " < " + last);
            }
            if (this.l != 0) {
                lowerBitsList.set(i, v & lowerBitsMask);
            }
            upperBitVector.set((v >>> this.l) + i);
            last = v;
        }
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("There are more than " + this.length + " values in the provided iterator");
        }
        this.lowerBits = lowerBitVector.bits();
        this.upperBits = upperBitVector.bits();
        if (this.length == 0L) {
            this.skipToZero = null;
            this.skipToOne = null;
        } else {
            this.skipToZero = new long[(int)(upperBound >>> this.l >>> this.log2Quantum)];
            this.skipToOne = new long[(int)(this.length - 1L >>> this.log2Quantum)];
        }
        int po = 0;
        int pz = 0;
        long cz = 0L;
        long co = 0L;
        for (long i = 0L; i < upperBitVector.length(); ++i) {
            boolean bit = upperBitVector.getBoolean(i);
            if (bit) {
                if (co != 0L && co % (long)this.quantum == 0L) {
                    this.skipToOne[po++] = i;
                }
                ++co;
                continue;
            }
            if (cz != 0L && cz % (long)this.quantum == 0L) {
                this.skipToZero[pz++] = i;
            }
            ++cz;
        }
        assert (po == this.skipToOne.length) : po + " != " + this.skipToOne.length;
        assert (pz == this.skipToZero.length) : pz + " != " + this.skipToZero.length;
    }

    public long numBits() {
        return ((long)this.upperBits.length + (long)this.lowerBits.length + (long)(this.skipToOne != null ? this.skipToOne.length : 0) + (long)(this.skipToZero != null ? this.skipToZero.length : 0)) * 64L;
    }

    public long getLong(long index) {
        int select;
        int bitCount;
        long window;
        long delta = index;
        int curr = 0;
        if (index >= (long)this.quantum) {
            long block = index >>> this.log2Quantum;
            assert (block > 0L);
            assert (block <= (long)this.skipToOne.length);
            long position = this.skipToOne[(int)(block - 1L)];
            curr = LongArrayBitVector.word((long)position);
            window = this.upperBits[curr] & -1L << (int)position;
            delta = index - (block << this.log2Quantum);
        } else {
            curr = 0;
            window = this.upperBits[0];
        }
        while ((long)(bitCount = Long.bitCount(window)) <= delta) {
            window = this.upperBits[++curr];
            delta -= (long)bitCount;
        }
        assert (window != 0L);
        if (delta != 0L) {
            long word = window;
            assert (delta < (long)Long.bitCount(word)) : delta + " >= " + Long.bitCount(word);
            long byteSums = word - ((word & 0xAAAAAAAAAAAAAAAAL) >>> 1);
            byteSums = (byteSums & 0x3333333333333333L) + (byteSums >>> 2 & 0x3333333333333333L);
            byteSums = byteSums + (byteSums >>> 4) & 0xF0F0F0F0F0F0F0FL;
            long rankStep8 = delta * 0x101010101010101L;
            long byteOffset = (((rankStep8 | 0x8080808080808080L) - (byteSums *= 0x101010101010101L) & 0x8080808080808080L) >>> 7) * 0x101010101010101L >>> 53 & 0xFFFFFFFFFFFFFFF8L;
            int byteRank = (int)(delta - (byteSums << 8 >>> (int)byteOffset & 0xFFL));
            select = (int)(byteOffset + (long)Fast.selectInByte[(int)(word >>> (int)byteOffset & 0xFFL) | byteRank << 8]);
        } else {
            select = Long.numberOfTrailingZeros(window);
        }
        long upperBits = LongArrayBitVector.bits((int)curr) + (long)select - index << this.l;
        if (this.l == 0) {
            return upperBits;
        }
        long position = index * (long)this.l;
        int startWord = LongArrayBitVector.word((long)position);
        int startBit = LongArrayBitVector.bit((long)position);
        long result = this.lowerBits[startWord] >>> startBit;
        return upperBits | (startBit + this.l <= 64 ? result : result | this.lowerBits[startWord + 1] << -startBit) & this.mask;
    }

    public long size64() {
        return this.length;
    }
}

