/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph.solve;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class Modulo2SparseSystem {
    private static final boolean DEBUG = false;
    private final ArrayList<Modulo2Equation> equations;
    private final int numVars;

    public Modulo2SparseSystem(int numVars) {
        this.numVars = numVars;
        this.equations = new ArrayList();
    }

    protected Modulo2SparseSystem(int numVars, ArrayList<Modulo2Equation> system) {
        this.numVars = numVars;
        this.equations = system;
    }

    public void print() {
        for (Modulo2Equation equation : this.equations) {
            System.out.println(equation);
        }
    }

    public void add(Modulo2Equation equation) {
        this.equations.add(equation);
    }

    public boolean solve(int[] solution) {
        if (!this.echelonForm()) {
            return false;
        }
        int i = this.equations.size();
        while (i-- != 0) {
            Modulo2Equation equation = this.equations.get(i);
            if (equation.variables.isEmpty()) continue;
            int count = equation.variables.size();
            int c = equation.c;
            int size = equation.variables.size();
            int j = size / 2;
            while (j-- != 0) {
                Collections.swap(equation.variables, j, size - j - 1);
            }
            IntListIterator iterator = equation.variables.iterator();
            while (iterator.hasNext()) {
                int e = iterator.nextInt();
                if (count == 1) {
                    assert (solution[e] == 0);
                    solution[e] = c;
                }
                --count;
            }
        }
        return true;
    }

    public int size() {
        return this.equations.size();
    }

    public Modulo2SparseSystem copy() {
        Modulo2SparseSystem s = new Modulo2SparseSystem(this.numVars);
        for (Modulo2Equation e : this.equations) {
            s.add(e.copy());
        }
        return s;
    }

    public boolean check(long[] solution) {
        for (Modulo2Equation equation : this.equations) {
            int sum = 0;
            IntListIterator i = equation.variables.iterator();
            while (i.hasNext()) {
                int e = i.nextInt();
                sum = (int)((long)sum ^ solution[e]);
            }
            if (equation.c == sum) continue;
            System.err.println(equation + " " + Arrays.toString(solution));
            return false;
        }
        return true;
    }

    private boolean echelonForm() {
        block0: for (int i = 0; i < this.equations.size() - 1; ++i) {
            assert (this.equations.get(i).firstVar() != Integer.MAX_VALUE);
            for (int j = i + 1; j < this.equations.size(); ++j) {
                Modulo2Equation eqJ = this.equations.get(j);
                Modulo2Equation eqI = this.equations.get(i);
                assert (eqI.firstVar() != Integer.MAX_VALUE);
                assert (eqJ.firstVar() != Integer.MAX_VALUE);
                int firstVar = eqI.firstVar();
                if (firstVar == eqJ.firstVar()) {
                    eqI.add(eqJ);
                    if (eqI.isUnsolvable()) {
                        return false;
                    }
                    if (eqI.isIdentity()) continue block0;
                }
                if (eqI.firstVar() <= eqJ.firstVar()) continue;
                Collections.swap(this.equations, i, j);
            }
        }
        return true;
    }

    public boolean gaussianElimination(long[] solution) {
        assert (solution.length == this.numVars);
        if (!this.echelonForm()) {
            return false;
        }
        int i = this.equations.size();
        while (i-- != 0) {
            Modulo2Equation equation = this.equations.get(i);
            if (equation.isIdentity()) continue;
            assert (solution[equation.firstVar()] == 0L) : equation.firstVar();
            solution[equation.firstVar()] = (long)equation.c ^ Modulo2Equation.scalarProduct(equation, solution);
        }
        return true;
    }

    public boolean lazyGaussianElimination(long[] solution) {
        IntListIterator iterator;
        int[][] var2Eq = new int[this.numVars][];
        int[] d = new int[this.numVars];
        for (Modulo2Equation equation : this.equations) {
            iterator = equation.variables.iterator();
            while (iterator.hasNext()) {
                int n = iterator.nextInt();
                d[n] = d[n] + 1;
            }
        }
        int v = this.numVars;
        while (v-- != 0) {
            var2Eq[v] = new int[d[v]];
        }
        Arrays.fill(d, 0);
        long[] c = new long[this.equations.size()];
        for (int e = 0; e < this.equations.size(); ++e) {
            c[e] = this.equations.get((int)e).c;
            iterator = this.equations.get((int)e).variables.iterator();
            while (iterator.hasNext()) {
                int v2;
                int n = v2 = iterator.nextInt();
                int n2 = d[n];
                d[n] = n2 + 1;
                var2Eq[v2][n2] = e;
            }
        }
        return Modulo2SparseSystem.lazyGaussianElimination(this, var2Eq, c, Util.identity((int)this.numVars), solution);
    }

    public static boolean lazyGaussianElimination(int[][] var2Eq, long[] c, int[] variable, long[] solution) {
        return Modulo2SparseSystem.lazyGaussianElimination(null, var2Eq, c, variable, solution);
    }

    public static boolean lazyGaussianElimination(Modulo2SparseSystem system, int[][] var2Eq, long[] c, int[] variable, long[] solution) {
        int pivot;
        Modulo2Equation equation;
        int i;
        boolean buildSystem;
        int numEquations = c.length;
        if (numEquations == 0) {
            return true;
        }
        int numVars = var2Eq.length;
        assert (solution.length == numVars);
        boolean bl = buildSystem = system == null;
        if (buildSystem) {
            system = new Modulo2SparseSystem(numVars);
            for (long element : c) {
                system.add(new Modulo2Equation((int)element));
            }
        }
        int[] weight = new int[numVars];
        int[] priority = new int[numEquations];
        for (int v : variable) {
            int[] eq = var2Eq[v];
            if (eq.length == 0) continue;
            int currEq = eq[0];
            boolean currCoeff = true;
            int j = 0;
            for (i = 1; i < eq.length; ++i) {
                if (eq[i] != currEq) {
                    assert (eq[i] > currEq);
                    if (currCoeff) {
                        if (buildSystem) {
                            system.equations.get(currEq).add(v);
                        }
                        int n = v;
                        weight[n] = weight[n] + 1;
                        int n2 = currEq;
                        priority[n2] = priority[n2] + 1;
                        eq[j++] = currEq;
                    }
                    currEq = eq[i];
                    currCoeff = true;
                    continue;
                }
                currCoeff = !currCoeff;
            }
            if (currCoeff) {
                if (buildSystem) {
                    system.equations.get(currEq).add(v);
                }
                int n = v;
                weight[n] = weight[n] + 1;
                int n3 = currEq;
                priority[n3] = priority[n3] + 1;
                eq[j++] = currEq;
            }
            if (j == eq.length) continue;
            var2Eq[v] = Arrays.copyOf(var2Eq[v], j);
        }
        int[] t = Util.identity((int)numVars);
        int[] u = new int[t.length];
        int[] count = new int[numEquations + 1];
        int i2 = t.length;
        while (i2-- != 0) {
            int n = weight[t[i2]];
            count[n] = count[n] + 1;
        }
        for (i2 = 1; i2 < count.length; ++i2) {
            int n = i2;
            count[n] = count[n] + count[i2 - 1];
        }
        i2 = t.length;
        while (i2-- != 0) {
            int n = weight[t[i2]];
            int n4 = count[n] - 1;
            count[n] = n4;
            u[n4] = t[i2];
        }
        IntArrayList variables = IntArrayList.wrap((int[])u);
        IntArrayList equationList = new IntArrayList();
        int i3 = priority.length;
        while (i3-- != 0) {
            if (priority[i3] > 1) continue;
            equationList.add(i3);
        }
        ArrayList<Modulo2Equation> dense = new ArrayList<Modulo2Equation>();
        ArrayList<Modulo2Equation> solved = new ArrayList<Modulo2Equation>();
        IntArrayList pivots = new IntArrayList();
        ArrayList<Modulo2Equation> equations = system.equations;
        boolean[] idle = new boolean[numVars];
        Arrays.fill(idle, true);
        int remaining = equations.size();
        while (remaining != 0) {
            if (equationList.isEmpty()) {
                int var;
                while (weight[var = variables.popInt()] == 0) {
                }
                idle[var] = false;
                int[] nArray = var2Eq[var];
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    int equationIndex;
                    int n5 = equationIndex = nArray[j];
                    priority[n5] = priority[n5] - 1;
                    if (priority[n5] != 1) continue;
                    equationList.push(equationIndex);
                }
                continue;
            }
            --remaining;
            int first = equationList.popInt();
            equation = equations.get(first);
            if (priority[first] == 0) {
                if (equation.isUnsolvable()) {
                    return false;
                }
                if (equation.isIdentity()) continue;
                dense.add(equation);
                continue;
            }
            if (priority[first] != 1) continue;
            pivot = -1;
            IntListIterator iterator = equation.variables.iterator();
            while (iterator.hasNext() && !idle[pivot = iterator.nextInt()]) {
            }
            pivots.add(pivot);
            solved.add(equation);
            weight[pivot] = 0;
            for (int equationIndex : var2Eq[pivot]) {
                if (equationIndex == first) continue;
                int n = equationIndex;
                priority[n] = priority[n] - 1;
                if (priority[n] == 1) {
                    equationList.add(equationIndex);
                }
                equations.get(equationIndex).add(equation);
            }
        }
        Modulo2SparseSystem denseSystem = new Modulo2SparseSystem(numVars, dense);
        if (!denseSystem.gaussianElimination(solution)) {
            return false;
        }
        i = solved.size();
        while (i-- != 0) {
            equation = (Modulo2Equation)solved.get(i);
            pivot = pivots.getInt(i);
            assert (solution[pivot] == 0L) : pivot;
            solution[pivot] = (long)equation.c ^ Modulo2Equation.scalarProduct(equation, solution);
        }
        return true;
    }

    public static boolean gaussianElimination(int[][] var2Eq, long[] c, int[] variable, long[] solution) {
        int numEquations = c.length;
        if (numEquations == 0) {
            return true;
        }
        int numVars = var2Eq.length;
        assert (solution.length == numVars);
        Modulo2SparseSystem system = new Modulo2SparseSystem(numVars);
        for (long element : c) {
            system.add(new Modulo2Equation((int)element));
        }
        for (int v : variable) {
            int[] eq = var2Eq[v];
            if (eq.length == 0) continue;
            int currEq = eq[0];
            boolean currCoeff = true;
            int j = 0;
            for (int i = 1; i < eq.length; ++i) {
                if (eq[i] != currEq) {
                    assert (eq[i] > currEq);
                    if (currCoeff) {
                        system.equations.get(currEq).add(v);
                        eq[j++] = currEq;
                    }
                    currEq = eq[i];
                    currCoeff = true;
                    continue;
                }
                currCoeff = !currCoeff;
            }
            if (currCoeff) {
                system.equations.get(currEq).add(v);
                eq[j++] = currEq;
            }
            if (j == eq.length) continue;
            var2Eq[v] = Arrays.copyOf(var2Eq[v], j);
        }
        return system.gaussianElimination(solution);
    }

    public static class Modulo2Equation {
        public final IntArrayList variables;
        public int c;

        public Modulo2Equation(int c) {
            this.variables = new IntArrayList();
            this.c = c;
        }

        public Modulo2Equation add(int variable) {
            if (!this.variables.isEmpty() && variable < this.variables.getInt(this.variables.size() - 1)) {
                throw new IllegalArgumentException();
            }
            this.variables.add(variable);
            return this;
        }

        protected Modulo2Equation(Modulo2Equation equation) {
            this.variables = equation.variables.clone();
            this.c = equation.c;
        }

        public void eliminate(Modulo2Equation equation) {
            assert (this.variables.getInt(0) == equation.variables.getInt(0)) : this.variables.getInt(0) + " != " + equation.variables.getInt(0);
            this.add(equation);
        }

        public int firstVar() {
            return this.variables.size() != 0 ? this.variables.getInt(0) : Integer.MAX_VALUE;
        }

        public void add(Modulo2Equation equation) {
            int i = 0;
            int j = 0;
            int k = 0;
            int s = this.variables.size();
            int t = equation.variables.size();
            int[] a = this.variables.elements();
            int[] b = equation.variables.elements();
            int[] result = new int[s + t];
            if (t != 0 && s != 0) {
                while (true) {
                    if (a[i] < b[j]) {
                        result[k++] = a[i++];
                        if (i != s) continue;
                        break;
                    }
                    if (a[i] > b[j]) {
                        result[k++] = b[j++];
                        if (j != t) continue;
                        break;
                    }
                    if (++i == s || ++j == t) break;
                }
            }
            while (i < s) {
                result[k++] = a[i++];
            }
            while (j < t) {
                result[k++] = b[j++];
            }
            this.c ^= equation.c;
            this.variables.size(k);
            System.arraycopy(result, 0, this.variables.elements(), 0, k);
        }

        public boolean isUnsolvable() {
            return this.variables.isEmpty() && this.c != 0;
        }

        public boolean isIdentity() {
            return this.variables.isEmpty() && this.c == 0;
        }

        public Modulo2Equation copy() {
            return new Modulo2Equation(this);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            boolean someNonZero = false;
            IntListIterator iterator = this.variables.iterator();
            while (iterator.hasNext()) {
                int v = iterator.nextInt();
                if (someNonZero) {
                    b.append(" + ");
                }
                someNonZero = true;
                b.append("x_").append(v);
            }
            if (!someNonZero) {
                b.append('0');
            }
            return b.append(" = ").append(this.c).toString();
        }

        public static long scalarProduct(Modulo2Equation e, long[] solution) {
            long sum = 0L;
            IntListIterator iterator = e.variables.iterator();
            while (iterator.hasNext()) {
                sum ^= solution[iterator.nextInt()];
            }
            return sum;
        }
    }
}

