/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.HuTuckerTransformationStrategy;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.BucketedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.GOV3Function;
import it.unimi.dsi.sux4j.mph.Hashes;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LcpMonotoneMinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Size64,
Serializable {
    public static final long serialVersionUID = 5L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LcpMonotoneMinimalPerfectHashFunction.class);
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    protected final long n;
    protected final int bucketSize;
    protected final int log2BucketSize;
    protected final int bucketSizeMask;
    protected final GOV3Function<BitVector> offsetLcpLength;
    protected final GOV3Function<BitVector> lcp2Bucket;
    protected final TransformationStrategy<? super T> transform;
    protected final long seed;
    protected final long signatureMask;
    protected final LongBigList signatures;

    protected LcpMonotoneMinimalPerfectHashFunction(Iterable<? extends T> keys, long numKeys, TransformationStrategy<? super T> transform, int signatureWidth, File tempDir) throws IOException {
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        this.transform = transform;
        if (numKeys == -1L) {
            if (keys instanceof Size64) {
                this.n = ((Size64)keys).size64();
            } else if (keys instanceof Collection) {
                this.n = ((Collection)keys).size();
            } else {
                long c = 0L;
                for (T dummy : keys) {
                    ++c;
                }
                this.n = c;
            }
        } else {
            this.n = numKeys;
        }
        this.defRetValue = -1L;
        if (this.n == 0L) {
            this.log2BucketSize = 0;
            this.bucketSizeMask = 0;
            this.bucketSize = 0;
            this.lcp2Bucket = null;
            this.offsetLcpLength = null;
            this.signatureMask = 0L;
            this.seed = 0L;
            this.signatures = null;
            return;
        }
        int theoreticalBucketSize = (int)Math.ceil(1.0 + GOV3Function.C * Math.log(2.0) + Math.log(this.n) - Math.log(1.0 + Math.log(this.n)));
        this.log2BucketSize = Fast.ceilLog2((int)theoreticalBucketSize);
        this.bucketSize = 1 << this.log2BucketSize;
        this.bucketSizeMask = this.bucketSize - 1;
        LOGGER.debug("Bucket size: " + this.bucketSize);
        long numBuckets = (this.n + (long)this.bucketSize - 1L) / (long)this.bucketSize;
        LongArrayBitVector prev = LongArrayBitVector.getInstance();
        LongArrayBitVector curr = LongArrayBitVector.getInstance();
        int currLcp = 0;
        OfflineIterable lcps = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
        final int[][] lcpLengths = IntBigArrays.newBigArray((long)numBuckets);
        int maxLcp = 0;
        long maxLength = 0L;
        pl.expectedUpdates = this.n;
        BucketedHashStore<LongArrayBitVector> bucketedHashStore = new BucketedHashStore<LongArrayBitVector>(TransformationStrategies.identity(), tempDir, pl);
        bucketedHashStore.reset(Util.randomSeed());
        pl.start((CharSequence)"Scanning collection...");
        Iterator<T> iterator = keys.iterator();
        for (long b = 0L; b < numBuckets; ++b) {
            prev.replace(transform.toBitVector(iterator.next()));
            bucketedHashStore.add(prev);
            pl.lightUpdate();
            maxLength = Math.max(maxLength, prev.length());
            currLcp = (int)prev.length();
            int currBucketSize = (int)Math.min((long)this.bucketSize, this.n - b * (long)this.bucketSize);
            for (int i = 0; i < currBucketSize - 1; ++i) {
                curr.replace(transform.toBitVector(iterator.next()));
                bucketedHashStore.add(curr);
                pl.lightUpdate();
                int prefix = (int)curr.longestCommonPrefixLength(prev);
                if ((long)prefix == prev.length() && (long)prefix == curr.length()) {
                    throw new IllegalArgumentException("The input bit vectors are not distinct@" + (b * (long)this.bucketSize + (long)i) + " (\"" + curr + "\" = \"" + prev + "\")");
                }
                if ((long)prefix == prev.length() || (long)prefix == curr.length()) {
                    throw new IllegalArgumentException("The input bit vectors are not prefix-free@" + (b * (long)this.bucketSize + (long)i) + " (\"" + curr + "\" is a prefix or a suffix of \"" + prev + "\")");
                }
                if (prev.getBoolean(prefix)) {
                    throw new IllegalArgumentException("The input bit vectors are not lexicographically sorted @" + (b * (long)this.bucketSize + (long)i) + " (\"" + curr + "\" < \"" + prev + "\")");
                }
                currLcp = Math.min(prefix, currLcp);
                prev.replace(curr);
                maxLength = Math.max(maxLength, prev.length());
            }
            lcps.add((Object)prev.subVector(0L, (long)currLcp));
            BigArrays.set((int[][])lcpLengths, (long)b, (int)currLcp);
            maxLcp = Math.max(maxLcp, currLcp);
        }
        pl.done();
        LOGGER.info("Generating the map from keys to LCP lengths and offsets...");
        this.offsetLcpLength = new GOV3Function.Builder().keys(TransformationStrategies.wrap(keys, transform)).transform(TransformationStrategies.identity()).store(bucketedHashStore).values((LongIterable)new AbstractLongBigList(){

            public long getLong(long index) {
                return (long)(BigArrays.get((int[][])lcpLengths, (long)(index >>> LcpMonotoneMinimalPerfectHashFunction.this.log2BucketSize)) << LcpMonotoneMinimalPerfectHashFunction.this.log2BucketSize) | index & (long)LcpMonotoneMinimalPerfectHashFunction.this.bucketSizeMask;
            }

            public long size64() {
                return LcpMonotoneMinimalPerfectHashFunction.this.n;
            }
        }, this.log2BucketSize + Fast.length((int)maxLcp)).indirect().build();
        LOGGER.info("Generating the map from LCPs to buckets...");
        this.lcp2Bucket = new GOV3Function.Builder().keys(lcps).transform(TransformationStrategies.identity()).tempDir(tempDir).build();
        lcps.close();
        this.seed = bucketedHashStore.seed();
        LOGGER.debug("Forecast bit cost per element: " + (Fast.log2((double)Math.E) + GOV3Function.C - Fast.log2((double)Fast.log2((double)Math.E)) + Fast.log2((double)(1.0 + Fast.log2((double)this.n))) + Fast.log2((double)((double)maxLength - Fast.log2((double)(1.0 + Fast.log2((double)this.n)))))));
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.n);
        if (signatureWidth != 0) {
            this.signatureMask = -1L >>> -signatureWidth;
            this.signatures = bucketedHashStore.signatures(signatureWidth, pl);
        } else {
            this.signatureMask = 0L;
            this.signatures = null;
        }
        bucketedHashStore.close();
    }

    public long getLong(Object o) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        BitVector bitVector = this.transform.toBitVector(o);
        long[] signature = new long[2];
        Hashes.spooky4(bitVector, this.seed, signature);
        long value = this.offsetLcpLength.getLongBySignature(signature);
        long prefix = value >>> this.log2BucketSize;
        if (prefix > bitVector.length()) {
            return this.defRetValue;
        }
        long result = (this.lcp2Bucket.getLong(bitVector.subVector(0L, prefix)) << this.log2BucketSize) + (value & (long)this.bucketSizeMask);
        if (this.signatureMask != 0L) {
            return result < 0L || result >= this.n || this.signatures.getLong(result) != (signature[0] & this.signatureMask) ? this.defRetValue : result;
        }
        return result < 0L || result >= this.n ? this.defRetValue : result;
    }

    @Override
    public long size64() {
        return this.n;
    }

    public long numBits() {
        return this.offsetLcpLength.numBits() + this.lcp2Bucket.numBits() + this.transform.numBits();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        Object collection;
        SimpleJSAP jsap = new SimpleJSAP(LcpMonotoneMinimalPerfectHashFunction.class.getName(), "Builds an LCP-based monotone minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("huTucker", 'h', "hu-tucker", "Use Hu-Tucker coding to reduce string length."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new FlaggedOption("signatureWidth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 's', "signature-width", "If specified, the signature width in bits; if negative, the generated function will be a dictionary."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised monotone minimal perfect hash function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        File tempDir = jsapResult.getFile("tempDir");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        boolean huTucker = jsapResult.getBoolean("huTucker");
        int signatureWidth = jsapResult.getInt("signatureWidth", 0);
        if ("-".equals(stringFile)) {
            ProgressLogger pl = new ProgressLogger(LOGGER);
            pl.displayLocalSpeed = true;
            pl.displayFreeMemory = true;
            pl.start((CharSequence)"Loading strings...");
            collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
            pl.done();
        } else {
            collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
        }
        HuTuckerTransformationStrategy transformationStrategy = huTucker ? new HuTuckerTransformationStrategy((Iterable)collection, true) : (iso ? TransformationStrategies.prefixFreeIso() : (utf32 ? TransformationStrategies.prefixFreeUtf32() : TransformationStrategies.prefixFreeUtf16()));
        BinIO.storeObject(new LcpMonotoneMinimalPerfectHashFunction(collection, -1L, transformationStrategy, signatureWidth, tempDir), (CharSequence)functionName);
        LOGGER.info("Completed.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected long numKeys = -1L;
        protected int signatureWidth;
        protected File tempDir;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> numKeys(long numKeys) {
            this.numKeys = numKeys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> signed(int signatureWidth) {
            this.signatureWidth = signatureWidth;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public LcpMonotoneMinimalPerfectHashFunction<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            return new LcpMonotoneMinimalPerfectHashFunction<T>(this.keys, this.numKeys, this.transform, this.signatureWidth, this.tempDir);
        }
    }
}

