/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.logging.ProgressLogger;

public class Hashes {
    private static final long ARBITRARY_BITS = -7046029254386353133L;
    private static final long M = -4132994306676758123L;
    private static final int R = 47;

    private Hashes() {
    }

    public static void jenkins(BitVector bv, long seed, long[] h) {
        long b;
        long length = bv.length();
        long from = 0L;
        if (length == 0L) {
            h[0] = seed ^ 0x8DE6A918D6538324L;
            h[1] = seed ^ 0x6BDA2AEF21654E7DL;
            h[2] = seed ^ 0x36071E726D0BA0C5L;
            return;
        }
        long a = b = seed;
        long c = -7046029254386353133L;
        while (length - from > 128L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, Math.min(from + 192L, length)));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            from += 192L;
        }
        c += length;
        long residual = length - from;
        if (residual > 0L) {
            if (residual > 64L) {
                a += bv.getLong(from, from + 64L);
                residual -= 64L;
            }
            if (residual != 0L) {
                b += bv.getLong(length - residual, length);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        h[0] = a;
        h[1] = b;
        h[2] = c ^= b >>> 22;
    }

    public static long jenkins(BitVector bv, long seed) {
        long b;
        long length = bv.length();
        long from = 0L;
        if (length == 0L) {
            return seed ^ 0x36071E726D0BA0C5L;
        }
        long a = b = seed;
        long c = -7046029254386353133L;
        while (length - from > 128L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, Math.min(from + 192L, length)));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            from += 192L;
        }
        c += length;
        long residual = length - from;
        if (residual > 0L) {
            if (residual > 64L) {
                a += bv.getLong(from, from + 64L);
                residual -= 64L;
            }
            if (residual != 0L) {
                b += bv.getLong(length - residual, length);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        return c ^= b >>> 22;
    }

    public static long jenkins(BitVector bv) {
        return Hashes.jenkins(bv, 0L);
    }

    public static long[][] preprocessJenkins(BitVector bv, long seed) {
        long b;
        long length = bv.length();
        int wordLength = (int)(length / 192L) + 1;
        long[] aa = new long[wordLength];
        long[] bb = new long[wordLength];
        long[] cc = new long[wordLength];
        long from = 0L;
        if (aa.length == 0) {
            return new long[3][0];
        }
        int i = 0;
        long a = b = seed;
        long c = -7046029254386353133L;
        aa[i] = a;
        bb[i] = b;
        cc[i] = c;
        ++i;
        while (length - from >= 192L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, from + 192L));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            from += 192L;
            aa[i] = a;
            bb[i] = b;
            cc[i] = c ^= b >>> 22;
            ++i;
        }
        return new long[][]{aa, bb, cc};
    }

    public static void jenkins(BitVector bv, long prefixLength, long[] aa, long[] bb, long[] cc, long[] h) {
        if (prefixLength == 0L) {
            long seed = aa[0];
            h[0] = seed ^ 0x8DE6A918D6538324L;
            h[1] = seed ^ 0x6BDA2AEF21654E7DL;
            h[2] = seed ^ 0x36071E726D0BA0C5L;
            return;
        }
        int stateOffset = (int)(prefixLength / 192L);
        long from = stateOffset * 3 * 64;
        long a = aa[stateOffset];
        long b = bb[stateOffset];
        long c = cc[stateOffset];
        if (prefixLength - from > 128L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, Math.min(from + 192L, prefixLength)));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            from += 192L;
        }
        c += prefixLength;
        long residual = prefixLength - from;
        if (residual > 0L) {
            if (residual > 64L) {
                a += bv.getLong(from, from + 64L);
                residual -= 64L;
            }
            if (residual != 0L) {
                b += bv.getLong(prefixLength - residual, prefixLength);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        h[0] = a;
        h[1] = b;
        h[2] = c ^= b >>> 22;
    }

    public static long jenkins(BitVector bv, long prefixLength, long[] aa, long[] bb, long[] cc) {
        if (prefixLength == 0L) {
            return aa[0] ^ 0x36071E726D0BA0C5L;
        }
        int stateOffset = (int)(prefixLength / 192L);
        long from = stateOffset * 3 * 64;
        long a = aa[stateOffset];
        long b = bb[stateOffset];
        long c = cc[stateOffset];
        if (prefixLength - from > 128L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, Math.min(from + 192L, prefixLength)));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            from += 192L;
        }
        c += prefixLength;
        long residual = prefixLength - from;
        if (residual > 0L) {
            if (residual > 64L) {
                a += bv.getLong(from, from + 64L);
                residual -= 64L;
            }
            if (residual != 0L) {
                b += bv.getLong(prefixLength - residual, prefixLength);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        return c ^= b >>> 22;
    }

    public static void jenkins(long[] triple, long seed, long[] h) {
        long b;
        long a = b = seed;
        long c = -7046029254386353133L;
        a += triple[0];
        a -= (b += triple[1]);
        a -= (c += triple[2]);
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        h[0] = a;
        h[1] = b;
        h[2] = c ^= b >>> 22;
    }

    public static long murmur(BitVector bv, long seed) {
        long k;
        long h = seed;
        long from = 0L;
        long length = bv.length();
        while (length - from >= 64L) {
            k = bv.getLong(from, from += 64L);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        if (length > from) {
            k = bv.getLong(from, length);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        k = length;
        k *= -4132994306676758123L;
        k ^= k >>> 47;
        h ^= (k *= -4132994306676758123L);
        return h *= -4132994306676758123L;
    }

    public static long murmur(BitVector bv, long prefixLength, long[] state) {
        long k;
        long precomputedUpTo = prefixLength & 0xFFFFFFFFFFFFFFC0L;
        long h = state[LongArrayBitVector.word((long)precomputedUpTo)];
        if (prefixLength > precomputedUpTo) {
            k = bv.getLong(precomputedUpTo, prefixLength);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        k = prefixLength;
        k *= -4132994306676758123L;
        k ^= k >>> 47;
        h ^= (k *= -4132994306676758123L);
        return h *= -4132994306676758123L;
    }

    public static long murmur(BitVector bv, long prefixLength, long[] state, long lcp) {
        long k;
        int startStateWord = LongArrayBitVector.word((long)Math.min(lcp, prefixLength));
        long h = state[startStateWord];
        long from = LongArrayBitVector.bits((int)startStateWord);
        while (prefixLength - from >= 64L) {
            k = bv.getLong(from, from += 64L);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        if (prefixLength > from) {
            k = bv.getLong(from, prefixLength);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        k = prefixLength;
        k *= -4132994306676758123L;
        k ^= k >>> 47;
        h ^= (k *= -4132994306676758123L);
        return h *= -4132994306676758123L;
    }

    public static long[] preprocessMurmur(BitVector bv, long seed) {
        long h = seed;
        long from = 0L;
        long length = bv.length();
        int wordLength = LongArrayBitVector.word((long)length);
        long[] state = new long[wordLength + 1];
        int i = 0;
        state[i++] = h;
        while (length - from >= 64L) {
            long k = bv.getLong(from, from += 64L);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            state[i] = h *= -4132994306676758123L;
            ++i;
        }
        return state;
    }

    private static final long finalizeMurmur3(long x) {
        x ^= x >>> 33;
        x *= -49064778989728563L;
        x ^= x >>> 33;
        x *= -4265267296055464877L;
        x ^= x >>> 33;
        return x;
    }

    public static void murmur3(BitVector bv, long seed, long[] h) {
        long k2;
        long k1;
        long h1 = 0x9368E53C2F6AF274L ^ seed;
        long h2 = 0x586DCD208F7CD3FDL ^ seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long from = 0L;
        long length = bv.length();
        while (length - from >= 128L) {
            k1 = bv.getLong(from, from + 64L);
            k2 = bv.getLong(from + 64L, from += 128L);
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        if (length > from) {
            if (length - from > 64L) {
                k1 = bv.getLong(from, from + 64L);
                k2 = bv.getLong(from + 64L, length);
            } else {
                k1 = bv.getLong(from, length);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= length);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        h1 += h2;
        h[0] = h1;
        h[1] = h2 += h1;
    }

    public static long murmur3(BitVector bv, long seed) {
        long k2;
        long k1;
        long h1 = 0x9368E53C2F6AF274L ^ seed;
        long h2 = 0x586DCD208F7CD3FDL ^ seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long from = 0L;
        long length = bv.length();
        while (length - from >= 128L) {
            k1 = bv.getLong(from, from + 64L);
            k2 = bv.getLong(from + 64L, from += 128L);
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        if (length > from) {
            if (length - from > 64L) {
                k1 = bv.getLong(from, from + 64L);
                k2 = bv.getLong(from + 64L, length);
            } else {
                k1 = bv.getLong(from, length);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= length);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        return h1 + h2;
    }

    public static void murmur3(BitVector bv, long prefixLength, long[] hh1, long[] hh2, long[] cc1, long[] cc2, long[] h) {
        int startStateWord = (int)(prefixLength / 128L);
        long precomputedUpTo = (long)startStateWord * 2L * 64L;
        long h1 = hh1[startStateWord];
        long h2 = hh2[startStateWord];
        long c1 = cc1[startStateWord];
        long c2 = cc2[startStateWord];
        if (prefixLength > precomputedUpTo) {
            long k2;
            long k1;
            if (prefixLength - precomputedUpTo > 64L) {
                k1 = bv.getLong(precomputedUpTo, precomputedUpTo += 64L);
                k2 = bv.getLong(precomputedUpTo, prefixLength);
            } else {
                k1 = bv.getLong(precomputedUpTo, prefixLength);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= prefixLength);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        h1 += h2;
        h[0] = h1;
        h[1] = h2 += h1;
    }

    public static long murmur3(BitVector bv, long prefixLength, long[] hh1, long[] hh2, long[] cc1, long[] cc2) {
        int startStateWord = (int)(prefixLength / 128L);
        long precomputedUpTo = (long)startStateWord * 2L * 64L;
        long h1 = hh1[startStateWord];
        long h2 = hh2[startStateWord];
        long c1 = cc1[startStateWord];
        long c2 = cc2[startStateWord];
        if (prefixLength > precomputedUpTo) {
            long k2;
            long k1;
            if (prefixLength - precomputedUpTo > 64L) {
                k1 = bv.getLong(precomputedUpTo, precomputedUpTo += 64L);
                k2 = bv.getLong(precomputedUpTo, prefixLength);
            } else {
                k1 = bv.getLong(precomputedUpTo, prefixLength);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= prefixLength);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        return h1 + h2;
    }

    public static void murmur3(BitVector bv, long prefixLength, long[] hh1, long[] hh2, long[] cc1, long[] cc2, long lcp, long[] h) {
        long k2;
        long k1;
        int startStateWord = (int)(Math.min(lcp, prefixLength) / 128L);
        long from = (long)startStateWord * 2L * 64L;
        long h1 = hh1[startStateWord];
        long h2 = hh2[startStateWord];
        long c1 = cc1[startStateWord];
        long c2 = cc2[startStateWord];
        while (prefixLength - from >= 128L) {
            k1 = bv.getLong(from, from + 64L);
            k2 = bv.getLong(from + 64L, from += 128L);
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        if (prefixLength - from != 0L) {
            if (prefixLength - from > 64L) {
                k1 = bv.getLong(from, from + 64L);
                k2 = bv.getLong(from + 64L, prefixLength);
            } else {
                k1 = bv.getLong(from, prefixLength);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= prefixLength);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        h1 += h2;
        h[0] = h1;
        h[1] = h2 += h1;
    }

    public static long murmur3(BitVector bv, long prefixLength, long[] hh1, long[] hh2, long[] cc1, long[] cc2, long lcp) {
        long k2;
        long k1;
        int startStateWord = (int)(Math.min(lcp, prefixLength) / 128L);
        long from = (long)startStateWord * 2L * 64L;
        long h1 = hh1[startStateWord];
        long h2 = hh2[startStateWord];
        long c1 = cc1[startStateWord];
        long c2 = cc2[startStateWord];
        while (prefixLength - from >= 128L) {
            k1 = bv.getLong(from, from + 64L);
            k2 = bv.getLong(from + 64L, from += 128L);
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        if (prefixLength - from != 0L) {
            if (prefixLength - from > 64L) {
                k1 = bv.getLong(from, from + 64L);
                k2 = bv.getLong(from + 64L, prefixLength);
            } else {
                k1 = bv.getLong(from, prefixLength);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= prefixLength);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        return h1 + h2;
    }

    public static long[][] preprocessMurmur3(BitVector bv, long seed) {
        long from = 0L;
        long length = bv.length();
        long h1 = 0x9368E53C2F6AF274L ^ seed;
        long h2 = 0x586DCD208F7CD3FDL ^ seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int wordLength = (int)(length / 128L);
        long[][] state = new long[4][wordLength + 1];
        int i = 0;
        state[0][i] = h1;
        state[1][i] = h2;
        state[2][i] = c1;
        state[3][i] = c2;
        ++i;
        while (length - from >= 128L) {
            long k1 = bv.getLong(from, from + 64L);
            long k2 = bv.getLong(from + 64L, from += 128L);
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 23);
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = Long.rotateLeft(h2, 41);
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 23);
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
            state[0][i] = h1;
            state[1][i] = h2;
            state[2][i] = c1;
            state[3][i] = c2;
            ++i;
        }
        return state;
    }

    public static void spooky4(BitVector bv, long seed, long[] tuple) {
        int length;
        long h0 = seed;
        long h1 = seed;
        long h2 = -7046029254386353133L;
        long h3 = -7046029254386353133L;
        int remaining = length = (int)bv.length();
        int pos = 0;
        while (remaining >= 256) {
            h2 += bv.getLong((long)(pos + 0), (long)(pos + 64));
            h2 = Long.rotateLeft(h2, 50);
            h0 ^= (h2 += (h3 += bv.getLong((long)(pos + 64), (long)(pos + 128))));
            h3 = Long.rotateLeft(h3, 52);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 30);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 41);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 54);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 48);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 38);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 37);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 62);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 34);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 5);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 36);
            h3 ^= (h1 += h2);
            h0 += bv.getLong((long)(pos + 128), (long)(pos + 192));
            h1 += bv.getLong((long)(pos + 192), (long)(pos + 256));
            remaining -= 256;
            pos += 256;
        }
        if (remaining >= 128) {
            h2 += bv.getLong((long)(pos + 0), (long)(pos + 64));
            h3 += bv.getLong((long)(pos + 64), (long)(pos + 128));
            remaining -= 128;
            pos += 128;
            h2 = Long.rotateLeft(h2, 50);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 52);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 30);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 41);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 54);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 48);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 38);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 37);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 62);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 34);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 5);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 36);
            h3 ^= (h1 += h2);
        }
        if (remaining > 64) {
            h2 += bv.getLong((long)(pos + 0), (long)(pos + 64));
            h3 += bv.getLong((long)(pos + 64), (long)length);
        } else if (remaining > 0) {
            h2 += bv.getLong((long)pos, (long)length);
        } else {
            h2 += -7046029254386353133L;
            h3 += -7046029254386353133L;
        }
        h0 += (long)length;
        h3 ^= h2;
        h2 = Long.rotateLeft(h2, 15);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 26);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 51);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 28);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 9);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 47);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 54);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 32);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 25);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 63);
        h1 += h0;
        switch (tuple.length) {
            case 4: {
                tuple[3] = h3;
            }
            case 3: {
                tuple[2] = h2;
            }
            case 2: {
                tuple[1] = h1;
            }
            case 1: {
                tuple[0] = h0;
            }
        }
    }

    public static long spooky4(BitVector bv, long seed) {
        int length;
        long h0 = seed;
        long h1 = seed;
        long h2 = -7046029254386353133L;
        long h3 = -7046029254386353133L;
        int remaining = length = (int)bv.length();
        int pos = 0;
        while (remaining >= 256) {
            h2 += bv.getLong((long)(pos + 0), (long)(pos + 64));
            h2 = Long.rotateLeft(h2, 50);
            h0 ^= (h2 += (h3 += bv.getLong((long)(pos + 64), (long)(pos + 128))));
            h3 = Long.rotateLeft(h3, 52);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 30);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 41);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 54);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 48);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 38);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 37);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 62);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 34);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 5);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 36);
            h3 ^= (h1 += h2);
            h0 += bv.getLong((long)(pos + 128), (long)(pos + 192));
            h1 += bv.getLong((long)(pos + 192), (long)(pos + 256));
            remaining -= 256;
            pos += 256;
        }
        if (remaining >= 128) {
            h2 += bv.getLong((long)(pos + 0), (long)(pos + 64));
            h3 += bv.getLong((long)(pos + 64), (long)(pos + 128));
            remaining -= 128;
            pos += 128;
            h2 = Long.rotateLeft(h2, 50);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 52);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 30);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 41);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 54);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 48);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 38);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 37);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 62);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 34);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 5);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 36);
            h3 ^= (h1 += h2);
        }
        if (remaining > 64) {
            h2 += bv.getLong((long)(pos + 0), (long)(pos + 64));
            h3 += bv.getLong((long)(pos + 64), (long)length);
        } else if (remaining > 0) {
            h2 += bv.getLong((long)pos, (long)length);
        } else {
            h2 += -7046029254386353133L;
            h3 += -7046029254386353133L;
        }
        h0 += (long)length;
        h3 ^= h2;
        h2 = Long.rotateLeft(h2, 15);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 26);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 51);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 28);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 9);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 47);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 54);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 32);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 25);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 63);
        h1 += h0;
        return h0;
    }

    public static void spooky12(BitVector bv, long seed, long[] tuple) {
        long remaining;
        long h10;
        long h9;
        if (bv.length() < 768L) {
            Hashes.spooky4(bv, seed, tuple);
            return;
        }
        long h6 = h9 = seed;
        long h3 = h9;
        long h0 = h9;
        long h7 = h10 = seed;
        long h4 = h10;
        long h1 = h10;
        long h11 = -7046029254386353133L;
        long h8 = -7046029254386353133L;
        long h5 = -7046029254386353133L;
        long h2 = -7046029254386353133L;
        long length = bv.length();
        long pos = 0L;
        for (remaining = length; remaining >= 704L; remaining -= 768L) {
            h2 ^= h10;
            h11 ^= (h0 += bv.getLong(pos + 0L, pos + 64L));
            h0 = Long.rotateLeft(h0, 11);
            h11 += h1;
            h3 ^= h11;
            h0 ^= (h1 += bv.getLong(pos + 64L, pos + 128L));
            h1 = Long.rotateLeft(h1, 32);
            h0 += h2;
            h4 ^= h0;
            h1 ^= (h2 += bv.getLong(pos + 128L, pos + 192L));
            h2 = Long.rotateLeft(h2, 43);
            h1 += h3;
            h5 ^= h1;
            h2 ^= (h3 += bv.getLong(pos + 192L, pos + 256L));
            h3 = Long.rotateLeft(h3, 31);
            h2 += h4;
            h6 ^= h2;
            h3 ^= (h4 += bv.getLong(pos + 256L, pos + 320L));
            h4 = Long.rotateLeft(h4, 17);
            h3 += h5;
            h7 ^= h3;
            h4 ^= (h5 += bv.getLong(pos + 320L, pos + 384L));
            h5 = Long.rotateLeft(h5, 28);
            h4 += h6;
            h8 ^= h4;
            h5 ^= (h6 += bv.getLong(pos + 384L, pos + 448L));
            h6 = Long.rotateLeft(h6, 39);
            h5 += h7;
            h9 ^= h5;
            h6 ^= (h7 += bv.getLong(pos + 448L, pos + 512L));
            h7 = Long.rotateLeft(h7, 57);
            h6 += h8;
            h10 ^= h6;
            h7 ^= (h8 += bv.getLong(pos + 512L, pos + 576L));
            h8 = Long.rotateLeft(h8, 55);
            h7 += h9;
            h11 ^= h7;
            h8 ^= (h9 += bv.getLong(pos + 576L, pos + 640L));
            h9 = Long.rotateLeft(h9, 54);
            h8 += h10;
            h0 ^= h8;
            h9 ^= (h10 += bv.getLong(pos + 640L, pos + 704L));
            h10 = Long.rotateLeft(h10, 22);
            h9 += h11;
            h1 ^= h9;
            h10 ^= (h11 += bv.getLong(pos + 704L, Math.min(length, pos + 768L)));
            h11 = Long.rotateLeft(h11, 46);
            h10 += h0;
            pos += 768L;
        }
        int remainingWords = LongArrayBitVector.word((long)remaining);
        switch (remainingWords) {
            case 10: {
                h9 += bv.getLong(pos + 576L, pos + 640L);
            }
            case 9: {
                h8 += bv.getLong(pos + 512L, pos + 576L);
            }
            case 8: {
                h7 += bv.getLong(pos + 448L, pos + 512L);
            }
            case 7: {
                h6 += bv.getLong(pos + 384L, pos + 448L);
            }
            case 6: {
                h5 += bv.getLong(pos + 320L, pos + 384L);
            }
            case 5: {
                h4 += bv.getLong(pos + 256L, pos + 320L);
            }
            case 4: {
                h3 += bv.getLong(pos + 192L, pos + 256L);
            }
            case 3: {
                h2 += bv.getLong(pos + 128L, pos + 192L);
            }
            case 2: {
                h1 += bv.getLong(pos + 64L, pos + 128L);
            }
            case 1: {
                h0 += bv.getLong(pos + 0L, pos + 64L);
            }
        }
        int bits = (int)(remaining & 0x3FL);
        if (bits > 0) {
            long partial = bv.getLong(length - (long)bits, length);
            switch (remainingWords) {
                case 0: {
                    h0 += partial;
                    break;
                }
                case 1: {
                    h1 += partial;
                    break;
                }
                case 2: {
                    h2 += partial;
                    break;
                }
                case 3: {
                    h3 += partial;
                    break;
                }
                case 4: {
                    h4 += partial;
                    break;
                }
                case 5: {
                    h5 += partial;
                    break;
                }
                case 6: {
                    h6 += partial;
                    break;
                }
                case 7: {
                    h7 += partial;
                    break;
                }
                case 8: {
                    h8 += partial;
                    break;
                }
                case 9: {
                    h9 += partial;
                    break;
                }
                case 10: {
                    h10 += partial;
                }
            }
        }
        h11 += length;
        for (int i = 0; i < 3; ++i) {
            h2 ^= (h11 += h1);
            h1 = Long.rotateLeft(h1, 44);
            h3 ^= (h0 += h2);
            h2 = Long.rotateLeft(h2, 15);
            h4 ^= (h1 += h3);
            h3 = Long.rotateLeft(h3, 34);
            h5 ^= (h2 += h4);
            h4 = Long.rotateLeft(h4, 21);
            h6 ^= (h3 += h5);
            h5 = Long.rotateLeft(h5, 38);
            h7 ^= (h4 += h6);
            h6 = Long.rotateLeft(h6, 33);
            h8 ^= (h5 += h7);
            h7 = Long.rotateLeft(h7, 10);
            h9 ^= (h6 += h8);
            h8 = Long.rotateLeft(h8, 13);
            h10 ^= (h7 += h9);
            h9 = Long.rotateLeft(h9, 38);
            h11 ^= (h8 += h10);
            h10 = Long.rotateLeft(h10, 53);
            h0 ^= (h9 += h11);
            h11 = Long.rotateLeft(h11, 42);
            h1 ^= (h10 += h0);
            h0 = Long.rotateLeft(h0, 54);
        }
        switch (tuple.length) {
            case 4: {
                tuple[3] = h3;
            }
            case 3: {
                tuple[2] = h2;
            }
            case 2: {
                tuple[1] = h1;
            }
            case 1: {
                tuple[0] = h0;
            }
        }
    }

    public static long[] preprocessSpooky4(BitVector bv, long seed) {
        long length = bv.length();
        if (length < 128L) {
            return null;
        }
        long[] state = new long[4 * (int)(length + 128L) / 256];
        long h0 = seed;
        long h1 = seed;
        long h2 = -7046029254386353133L;
        long h3 = -7046029254386353133L;
        long remaining = length;
        long pos = 0L;
        int p = 0;
        while (true) {
            h2 += bv.getLong(pos + 0L, pos + 64L);
            h2 = Long.rotateLeft(h2, 50);
            h0 ^= (h2 += (h3 += bv.getLong(pos + 64L, pos + 128L)));
            h3 = Long.rotateLeft(h3, 52);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 30);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 41);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 54);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 48);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 38);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 37);
            h3 ^= (h1 += h2);
            h2 = Long.rotateLeft(h2, 62);
            h0 ^= (h2 += h3);
            h3 = Long.rotateLeft(h3, 34);
            h1 ^= (h3 += h0);
            h0 = Long.rotateLeft(h0, 5);
            h2 ^= (h0 += h1);
            h1 = Long.rotateLeft(h1, 36);
            state[p + 0] = h0;
            state[p + 1] = h1;
            state[p + 2] = h2;
            state[p + 3] = h3 ^= (h1 += h2);
            p += 4;
            if (remaining < 384L) break;
            h0 += bv.getLong(pos + 128L, pos + 192L);
            h1 += bv.getLong(pos + 192L, pos + 256L);
            remaining -= 256L;
            pos += 256L;
        }
        return state;
    }

    public static void spooky4(BitVector bv, long prefixLength, long seed, long[] state, long[] tuple) {
        long pos;
        long h0 = seed;
        long h1 = seed;
        long h2 = -7046029254386353133L;
        long h3 = -7046029254386353133L;
        if (prefixLength >= 128L) {
            int p = 4 * (int)((prefixLength - 128L) / 256L);
            h0 = state[p + 0];
            h1 = state[p + 1];
            h2 = state[p + 2];
            h3 = state[p + 3];
            pos = LongArrayBitVector.bits((int)p) + 128L;
        } else {
            pos = 0L;
        }
        long remaining = prefixLength - pos;
        if (remaining >= 128L) {
            h0 += bv.getLong(pos + 0L, pos + 64L);
            h1 += bv.getLong(pos + 64L, pos + 128L);
            remaining -= 128L;
            pos += 128L;
        }
        if (remaining > 64L) {
            h2 += bv.getLong(pos + 0L, pos + 64L);
            h3 += bv.getLong(pos + 64L, prefixLength);
        } else if (remaining > 0L) {
            h2 += bv.getLong(pos, prefixLength);
        } else {
            h2 += -7046029254386353133L;
            h3 += -7046029254386353133L;
        }
        h0 += prefixLength;
        h3 ^= h2;
        h2 = Long.rotateLeft(h2, 15);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 26);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 51);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 28);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 9);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 47);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 54);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 32);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 25);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 63);
        h1 += h0;
        switch (tuple.length) {
            case 4: {
                tuple[3] = h3;
            }
            case 3: {
                tuple[2] = h2;
            }
            case 2: {
                tuple[1] = h1;
            }
            case 1: {
                tuple[0] = h0;
            }
        }
    }

    public static long spooky4(BitVector bv, long prefixLength, long seed, long[] state) {
        long pos;
        long h0 = seed;
        long h1 = seed;
        long h2 = -7046029254386353133L;
        long h3 = -7046029254386353133L;
        if (prefixLength >= 128L) {
            int p = 4 * (int)((prefixLength - 128L) / 256L);
            h0 = state[p + 0];
            h1 = state[p + 1];
            h2 = state[p + 2];
            h3 = state[p + 3];
            pos = LongArrayBitVector.bits((int)p) + 128L;
        } else {
            pos = 0L;
        }
        long remaining = prefixLength - pos;
        if (remaining >= 128L) {
            h0 += bv.getLong(pos + 0L, pos + 64L);
            h1 += bv.getLong(pos + 64L, pos + 128L);
            remaining -= 128L;
            pos += 128L;
        }
        if (remaining > 64L) {
            h2 += bv.getLong(pos + 0L, pos + 64L);
            h3 += bv.getLong(pos + 64L, prefixLength);
        } else if (remaining > 0L) {
            h2 += bv.getLong(pos, prefixLength);
        } else {
            h2 += -7046029254386353133L;
            h3 += -7046029254386353133L;
        }
        h0 += prefixLength;
        h3 ^= h2;
        h2 = Long.rotateLeft(h2, 15);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 26);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 51);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 28);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 9);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 47);
        h2 ^= (h1 += h0);
        h1 = Long.rotateLeft(h1, 54);
        h3 ^= (h2 += h1);
        h2 = Long.rotateLeft(h2, 32);
        h0 ^= (h3 += h2);
        h3 = Long.rotateLeft(h3, 25);
        h1 ^= (h0 += h3);
        h0 = Long.rotateLeft(h0, 63);
        h1 += h0;
        return h0;
    }

    public static void spooky4(long[] triple, long seed, long[] tuple) {
        long h0 = seed;
        long h1 = -7046029254386353133L + triple[0];
        long h2 = -7046029254386353133L + triple[1];
        long h3 = -7046029254386353133L + triple[2];
        h2 = Long.rotateLeft(h2, 50);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 30);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 41);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 54);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 48);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 38);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 37);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 62);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 34);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 5);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 36);
        h3 ^= (h1 += h2);
        switch (tuple.length) {
            case 4: {
                tuple[3] = h3;
            }
            case 3: {
                tuple[2] = h2;
            }
            case 2: {
                tuple[1] = h1;
            }
            case 1: {
                tuple[0] = h0;
            }
        }
    }

    public static void spooky4(long x, long y, long seed, long[] tuple) {
        long h0 = seed;
        long h1 = -7046029254386353133L + x;
        long h2 = -7046029254386353133L + y;
        long h3 = -7046029254386353133L;
        h2 = Long.rotateLeft(h2, 50);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 30);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 41);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 54);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 48);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 38);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 37);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 62);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 34);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 5);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 36);
        h3 ^= (h1 += h2);
        switch (tuple.length) {
            case 4: {
                tuple[3] = h3;
            }
            case 3: {
                tuple[2] = h2;
            }
            case 2: {
                tuple[1] = h1;
            }
            case 1: {
                tuple[0] = h0;
            }
        }
    }

    public static void main(String[] arg) {
        int l = Integer.parseInt(arg[0]);
        int n = Integer.parseInt(arg[1]);
        LongArrayBitVector bv = LongArrayBitVector.ofLength((long)l);
        ProgressLogger pl = new ProgressLogger();
        long t = 0L;
        long[] h = new long[3];
        int k = 4;
        while (k-- != 0) {
            pl.start((CharSequence)"Timing MurmurHash...");
            int i = n;
            while (i-- != 0) {
                t += Hashes.murmur((BitVector)bv, 0L);
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            pl.start((CharSequence)"Timing MurmurHash3...");
            i = n;
            while (i-- != 0) {
                Hashes.murmur3((BitVector)bv, 0L, h);
                t += h[0];
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            pl.start((CharSequence)"Timing Jenkins's hash...");
            i = n;
            while (i-- != 0) {
                Hashes.jenkins((BitVector)bv, 0L, h);
                t += h[0];
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            pl.start((CharSequence)"Timing SpookyHash4...");
            i = n;
            while (i-- != 0) {
                Hashes.spooky4((BitVector)bv, 0L, h);
                t += h[0];
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            pl.start((CharSequence)"Timing SpookyHash12...");
            i = n;
            while (i-- != 0) {
                Hashes.spooky12((BitVector)bv, 0L, h);
                t += h[0];
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            long[] preprocessMurmur = Hashes.preprocessMurmur((BitVector)bv, 0L);
            pl.start((CharSequence)"Timing preprocessed MurmurHash...");
            int i2 = n;
            while (i2-- != 0) {
                t += Hashes.murmur((BitVector)bv, l - 1, preprocessMurmur);
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            long[][] preprocessMurmur3 = Hashes.preprocessMurmur3((BitVector)bv, 0L);
            long[] hh1 = preprocessMurmur3[0];
            long[] hh2 = preprocessMurmur3[1];
            long[] cc1 = preprocessMurmur3[2];
            long[] cc2 = preprocessMurmur3[3];
            pl.start((CharSequence)"Timing preprocessed MurmurHash3...");
            int i3 = n / l;
            while (i3-- != 0) {
                int j = l;
                while (j-- != 0) {
                    t += Hashes.murmur3((BitVector)bv, j, hh1, hh2, cc1, cc2);
                }
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            long[][] preprocessJenkins = Hashes.preprocessJenkins((BitVector)bv, 0L);
            long[] aa = preprocessJenkins[0];
            long[] bb = preprocessJenkins[1];
            long[] cc = preprocessJenkins[2];
            pl.start((CharSequence)"Timing preprocessed Jenkins's hash...");
            int i4 = n / l;
            while (i4-- != 0) {
                int j = l;
                while (j-- != 0) {
                    t += Hashes.jenkins((BitVector)bv, j, aa, bb, cc);
                }
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            long[] preprocessSpooky4 = Hashes.preprocessSpooky4((BitVector)bv, 0L);
            pl.start((CharSequence)"Timing preprocessed SpookyHash...");
            int i5 = n / l;
            while (i5-- != 0) {
                int j = l;
                while (j-- != 0) {
                    t += Hashes.spooky4((BitVector)bv, (long)j, 0L, preprocessSpooky4);
                }
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
        }
    }
}

