/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.io.FileLinesByteArrayCollection;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.LongBigArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.BucketedHashStore;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.solve.Linear4SystemSolver;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import it.unimi.dsi.util.concurrent.ReorderingBlockingQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GOV4Function<T>
extends AbstractObject2LongFunction<T>
implements Serializable,
Size64 {
    private static final long serialVersionUID = 6L;
    private static final LongArrayBitVector END_OF_SOLUTION_QUEUE = LongArrayBitVector.getInstance();
    private static final BucketedHashStore.Bucket END_OF_BUCKET_QUEUE = new BucketedHashStore.Bucket();
    private static final Logger LOGGER = LoggerFactory.getLogger(GOV4Function.class);
    private static final boolean DEBUG = false;
    private static final long SEED_STEP = 0x100000000000000L;
    private static final long OFFSET_MASK = 0xFFFFFFFFFFFFFFL;
    public static double C = 1.03;
    private static long C_TIMES_256 = (long)Math.floor(C * 256.0);
    public static final String NUMBER_OF_THREADS_PROPERTY = "it.unimi.dsi.sux4j.mph.threads";
    public static final int BUCKET_SIZE = 1500;
    private final long multiplier;
    protected final long n;
    protected final long m;
    protected final int width;
    protected final long globalSeed;
    protected final long[] offsetAndSeed;
    protected final LongBigList data;
    protected final TransformationStrategy<? super T> transform;
    protected final long signatureMask;
    protected final LongBigList signatures;

    protected GOV4Function(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, int signatureWidth, LongIterable values, int dataWidth, File tempDir, BucketedHashStore<T> bucketedHashStore, boolean indirect) throws IOException {
        boolean givenBucketedHashStore;
        this.transform = transform;
        boolean bl = givenBucketedHashStore = bucketedHashStore != null;
        if (signatureWidth != 0 && values != null) {
            throw new IllegalArgumentException("You cannot sign a function if you specify its values");
        }
        if (signatureWidth != 0 && dataWidth != -1) {
            throw new IllegalArgumentException("You cannot specify a signature width and a data width");
        }
        if (values == null && dataWidth != -1 && !givenBucketedHashStore && !indirect) {
            throw new IllegalArgumentException("You cannot specify a data width but no values and no direct bucketed hash store");
        }
        if (values != null && dataWidth == -1) {
            throw new IllegalArgumentException("You cannot specify values but no data width");
        }
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        pl.itemsName = "keys";
        if (bucketedHashStore == null) {
            if (keys == null) {
                throw new IllegalArgumentException("If you do not provide a bucketed hash store, you must provide the keys");
            }
            bucketedHashStore = new BucketedHashStore<T>(transform, tempDir, -Math.min(signatureWidth, 0), pl);
            bucketedHashStore.reset(r.nextLong());
            if (values == null || indirect) {
                bucketedHashStore.addAll(keys.iterator());
            } else {
                bucketedHashStore.addAll(keys.iterator(), values.iterator());
            }
        }
        this.n = bucketedHashStore.size();
        this.defRetValue = signatureWidth < 0 ? 0L : -1L;
        bucketedHashStore.bucketSize(1500);
        int numBuckets = (int)(this.n / 1500L + 1L);
        this.multiplier = (long)numBuckets * 2L;
        LOGGER.debug("Number of buckets: " + numBuckets);
        this.offsetAndSeed = new long[numBuckets + 1];
        this.width = signatureWidth < 0 ? -signatureWidth : (dataWidth == -1 ? Math.max(0, Fast.ceilLog2((long)this.n)) : dataWidth);
        OfflineIterable offlineData = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
        int duplicates = 0;
        while (true) {
            LOGGER.debug("Generating GOV function with " + this.width + " output bits...");
            pl.expectedUpdates = numBuckets;
            pl.itemsName = "buckets";
            pl.start((CharSequence)"Analysing buckets... ");
            AtomicLong unsolvable = new AtomicLong();
            try {
                int numberOfThreads = Integer.parseInt(System.getProperty(NUMBER_OF_THREADS_PROPERTY, Integer.toString(Math.min(4, Runtime.getRuntime().availableProcessors()))));
                ArrayBlockingQueue bucketQueue = new ArrayBlockingQueue(numberOfThreads * 8);
                ReorderingBlockingQueue queue = new ReorderingBlockingQueue(numberOfThreads * 128);
                ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads + 2);
                ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
                executorCompletionService.submit(() -> {
                    LongArrayBitVector data;
                    while ((data = (LongArrayBitVector)queue.take()) != END_OF_SOLUTION_QUEUE) {
                        offlineData.add((Object)data);
                    }
                    return null;
                });
                BucketedHashStore<Object> chs = bucketedHashStore;
                executorCompletionService.submit(() -> {
                    try {
                        Iterator<BucketedHashStore.Bucket> iterator = chs.iterator();
                        int i1 = 0;
                        while (iterator.hasNext()) {
                            BucketedHashStore.Bucket bucket = new BucketedHashStore.Bucket(iterator.next());
                            assert (i1 == bucket.index());
                            long bucketDataSize = Math.max(C_TIMES_256 * (long)bucket.size() >>> 8, (long)(bucket.size() + 1));
                            assert (bucketDataSize <= Integer.MAX_VALUE);
                            long[] lArray = this.offsetAndSeed;
                            // MONITORENTER : this.offsetAndSeed
                            this.offsetAndSeed[i1 + 1] = this.offsetAndSeed[i1] + bucketDataSize;
                            assert (this.offsetAndSeed[i1 + 1] <= 0x100000000000000L) : this.offsetAndSeed[i1 + 1] + " > " + 0x100000000000000L;
                            // MONITOREXIT : lArray
                            bucketQueue.put(bucket);
                            ++i1;
                        }
                        return null;
                    }
                    finally {
                        int i2 = numberOfThreads;
                        while (true) {
                            if (i2-- == 0) {
                            }
                            bucketQueue.put(END_OF_BUCKET_QUEUE);
                        }
                    }
                });
                AtomicInteger activeThreads = new AtomicInteger(numberOfThreads);
                int i = numberOfThreads;
                while (i-- != 0) {
                    executorCompletionService.submit(() -> {
                        Thread.currentThread().setPriority(1);
                        long bucketTime = 0L;
                        long outputTime = 0L;
                        while (true) {
                            int n;
                            long[] lArray;
                            LongBigList data;
                            LongArrayBitVector dataBitVector;
                            BucketedHashStore.Bucket bucket;
                            long start;
                            block9: {
                                start = System.nanoTime();
                                bucket = (BucketedHashStore.Bucket)bucketQueue.take();
                                bucketTime += System.nanoTime() - start;
                                if (bucket == END_OF_BUCKET_QUEUE) {
                                    if (activeThreads.decrementAndGet() == 0) {
                                        queue.put((Object)END_OF_SOLUTION_QUEUE, (long)numBuckets);
                                    }
                                    LOGGER.debug("Queue waiting time: " + Util.format((double)((double)bucketTime / 1.0E9)) + "s");
                                    LOGGER.debug("Output waiting time: " + Util.format((double)((double)outputTime / 1.0E9)) + "s");
                                    return null;
                                }
                                long seed = 0L;
                                Linear4SystemSolver solver = new Linear4SystemSolver((int)(this.offsetAndSeed[bucket.index() + 1] - this.offsetAndSeed[bucket.index()] & 0xFFFFFFFFFFFFFFL), bucket.size());
                                do {
                                    boolean solved22 = solver.generateAndSolve(bucket, seed, bucket.valueList((LongIterable)(indirect ? values : null)));
                                    unsolvable.addAndGet(solver.unsolvable);
                                    if (!solved22) continue;
                                    long[] solved22 = this.offsetAndSeed;
                                    // MONITORENTER : this.offsetAndSeed
                                    int n2 = bucket.index();
                                    this.offsetAndSeed[n2] = this.offsetAndSeed[n2] | seed;
                                    // MONITOREXIT : solved22
                                    dataBitVector = LongArrayBitVector.getInstance();
                                    data = dataBitVector.asLongBigList(this.width);
                                    lArray = solver.solution;
                                    n = lArray.length;
                                    break block9;
                                } while ((seed += 0x100000000000000L) != 0L);
                                throw new AssertionError((Object)"Exhausted local seeds");
                            }
                            for (int i = 0; i < n; ++i) {
                                long l = lArray[i];
                                data.add(l);
                            }
                            start = System.nanoTime();
                            queue.put((Object)dataBitVector, (long)bucket.index());
                            outputTime += System.nanoTime() - start;
                            ProgressLogger progressLogger = pl;
                            // MONITORENTER : progressLogger
                            pl.update();
                            // MONITOREXIT : progressLogger
                        }
                    });
                }
                try {
                    i = numberOfThreads + 2;
                    while (i-- != 0) {
                        executorCompletionService.take().get();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof BucketedHashStore.DuplicateException) {
                        throw (BucketedHashStore.DuplicateException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                finally {
                    executorService.shutdown();
                }
                LOGGER.info("Unsolvable systems: " + unsolvable.get() + "/" + (unsolvable.get() + (long)numBuckets) + " (" + Util.format((double)(100.0 * (double)unsolvable.get() / (double)(unsolvable.get() + (long)numBuckets))) + "%)");
                pl.done();
            }
            catch (BucketedHashStore.DuplicateException e) {
                if (keys == null) {
                    throw new IllegalStateException("You provided no keys, but the bucketed hash store was not checked");
                }
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing signatures...");
                bucketedHashStore.reset(r.nextLong());
                pl.itemsName = "keys";
                if (values == null || indirect) {
                    bucketedHashStore.addAll(keys.iterator());
                } else {
                    bucketedHashStore.addAll(keys.iterator(), values.iterator());
                }
                offlineData.clear();
                Arrays.fill(this.offsetAndSeed, 0L);
                continue;
            }
            break;
        }
        this.globalSeed = bucketedHashStore.seed();
        this.m = this.offsetAndSeed[this.offsetAndSeed.length - 1];
        OfflineIterable.OfflineIterator iterator = offlineData.iterator();
        if ((this.m + 1L) * (long)this.width < LongArrayBitVector.bits((int)0x7FFFFFF7)) {
            LongArrayBitVector dataBitVector = LongArrayBitVector.getInstance((long)((this.m + 1L) * (long)this.width));
            this.data = dataBitVector.asLongBigList(this.width);
            while (iterator.hasNext()) {
                dataBitVector.append((BitVector)iterator.next());
            }
        } else {
            LongBigArrayBitVector dataBitVector = LongBigArrayBitVector.getInstance((long)((this.m + 1L) * (long)this.width));
            this.data = dataBitVector.asLongBigList(this.width);
            while (iterator.hasNext()) {
                dataBitVector.append((BitVector)iterator.next());
            }
        }
        iterator.close();
        offlineData.close();
        this.data.add(0L);
        LOGGER.info("Completed.");
        LOGGER.info("Forecast bit cost per element: " + C * (double)this.width);
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.n);
        if (signatureWidth > 0) {
            this.signatureMask = -1L >>> -signatureWidth;
            this.signatures = bucketedHashStore.signatures(signatureWidth, pl);
        } else if (signatureWidth < 0) {
            this.signatureMask = -1L >>> 64 + signatureWidth;
            this.signatures = null;
        } else {
            this.signatureMask = 0L;
            this.signatures = null;
        }
        if (!givenBucketedHashStore) {
            bucketedHashStore.close();
        }
    }

    public long getLong(Object o) {
        long[] signature = new long[2];
        Hashes.spooky4(this.transform.toBitVector(o), this.globalSeed, signature);
        return this.getLongBySignature(signature);
    }

    public long getLongBySignature(long[] signature) {
        int[] e = new int[4];
        int bucket = (int)Math.multiplyHigh(signature[0] >>> 1, this.multiplier);
        long bucketOffset = this.offsetAndSeed[bucket] & 0xFFFFFFFFFFFFFFL;
        Linear4SystemSolver.signatureToEquation(signature, this.offsetAndSeed[bucket] & 0xFF00000000000000L, (int)((this.offsetAndSeed[bucket + 1] & 0xFFFFFFFFFFFFFFL) - bucketOffset), e);
        long e0 = (long)e[0] + bucketOffset;
        long e1 = (long)e[1] + bucketOffset;
        long e2 = (long)e[2] + bucketOffset;
        long e3 = (long)e[3] + bucketOffset;
        long result = this.data.getLong(e0) ^ this.data.getLong(e1) ^ this.data.getLong(e2) ^ this.data.getLong(e3);
        if (this.signatureMask == 0L) {
            return result;
        }
        if (this.signatures != null) {
            return result >= this.n || ((this.signatures.getLong(result) ^ signature[0]) & this.signatureMask) != 0L ? this.defRetValue : result;
        }
        return ((result ^ signature[0]) & this.signatureMask) != 0L ? this.defRetValue : 1L;
    }

    public long size64() {
        return this.n;
    }

    @Deprecated
    public int size() {
        return this.n > Integer.MAX_VALUE ? -1 : (int)this.n;
    }

    public long numBits() {
        if (this.n == 0L) {
            return 0L;
        }
        return (this.data != null ? this.data.size64() : 0L) * (long)this.width + (long)this.offsetAndSeed.length * 64L;
    }

    public boolean containsKey(Object o) {
        return true;
    }

    public void dump(String file) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000).order(ByteOrder.nativeOrder());
        FileOutputStream fos = new FileOutputStream(file);
        FileChannel channel = fos.getChannel();
        buffer.clear();
        buffer.putLong(this.size64());
        buffer.putLong(this.width);
        buffer.putLong(this.multiplier);
        buffer.putLong(this.globalSeed);
        buffer.putLong(this.offsetAndSeed.length);
        for (long l : this.offsetAndSeed) {
            if (!buffer.hasRemaining()) {
                buffer.flip();
                channel.write(buffer);
                buffer.clear();
            }
            buffer.putLong(l);
        }
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        LongBigArrayBitVector v = LongBigArrayBitVector.getInstance().ensureCapacity(this.data.size64() * (long)this.width + 64L - 1L & 0xFFFFFFFFFFFFFFC0L);
        LongBigListIterator longBigListIterator = this.data.iterator();
        while (longBigListIterator.hasNext()) {
            long d = (Long)longBigListIterator.next();
            v.append(d, this.width);
        }
        v.length(this.data.size64() * (long)this.width + 64L - 1L & 0xFFFFFFFFFFFFFFC0L);
        LongBigList list = v.asLongBigList(64);
        buffer.putLong(list.size64());
        LongBigListIterator longBigListIterator2 = list.iterator();
        while (longBigListIterator2.hasNext()) {
            long l;
            l = (Long)longBigListIterator2.next();
            if (!buffer.hasRemaining()) {
                buffer.flip();
                channel.write(buffer);
                buffer.clear();
            }
            buffer.putLong(l);
        }
        buffer.flip();
        channel.write(buffer);
        fos.close();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        LongIterable values;
        SimpleJSAP jsap = new SimpleJSAP(GOV4Function.class.getName(), "Builds a GOV function mapping a newline-separated list of strings to their ordinal position, or to specific values.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new FlaggedOption("signatureWidth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 's', "signature-width", "If specified, the signature width in bits; if negative, the generated function will be an approximate dictionary."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new FlaggedOption("values", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'v', "values", "A binary file in DataInput format containing a long for each string (otherwise, the values will be the ordinal positions of the strings)."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised GOV function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        File tempDir = jsapResult.getFile("tempDir");
        boolean byteArray = jsapResult.getBoolean("byteArray");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        int signatureWidth = jsapResult.getInt("signatureWidth", 0);
        LongIterable longIterable = values = jsapResult.userSpecified("values") ? BinIO.asLongIterable((CharSequence)jsapResult.getString("values")) : null;
        if (byteArray) {
            if ("-".equals(stringFile)) {
                throw new IllegalArgumentException("Cannot read from standard input when building byte-array functions");
            }
            if (iso || utf32 || jsapResult.userSpecified("encoding")) {
                throw new IllegalArgumentException("Encoding options are not available when building byte-array functions");
            }
            FileLinesByteArrayCollection collection = new FileLinesByteArrayCollection((CharSequence)stringFile, zipped);
            if (values != null) {
                int dataWidth = -1;
                LongIterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    dataWidth = Math.max(dataWidth, Fast.length((long)iterator.nextLong()));
                }
                BinIO.storeObject(new GOV4Function(collection, TransformationStrategies.rawByteArray(), signatureWidth, values, dataWidth, tempDir, null, false), (CharSequence)functionName);
            } else {
                BinIO.storeObject(new GOV4Function(collection, TransformationStrategies.rawByteArray(), signatureWidth, null, -1, tempDir, null, false), (CharSequence)functionName);
            }
        } else {
            TransformationStrategy transformationStrategy;
            Object collection;
            if ("-".equals(stringFile)) {
                ProgressLogger pl = new ProgressLogger(LOGGER);
                pl.displayLocalSpeed = true;
                pl.displayFreeMemory = true;
                pl.start((CharSequence)"Loading strings...");
                collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
                pl.done();
            } else {
                collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
            }
            TransformationStrategy transformationStrategy2 = iso ? TransformationStrategies.rawIso() : (transformationStrategy = utf32 ? TransformationStrategies.rawUtf32() : TransformationStrategies.rawUtf16());
            if (values != null) {
                int dataWidth = -1;
                LongIterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    dataWidth = Math.max(dataWidth, Fast.length((long)iterator.nextLong()));
                }
                BinIO.storeObject(new GOV4Function(collection, transformationStrategy, signatureWidth, values, dataWidth, tempDir, null, false), (CharSequence)functionName);
            } else {
                BinIO.storeObject(new GOV4Function(collection, transformationStrategy, signatureWidth, null, -1, tempDir, null, false), (CharSequence)functionName);
            }
        }
        LOGGER.info("Completed.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected int signatureWidth;
        protected File tempDir;
        protected BucketedHashStore<T> bucketedHashStore;
        protected LongIterable values;
        protected int outputWidth = -1;
        protected boolean indirect;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> signed(int signatureWidth) {
            this.signatureWidth = signatureWidth;
            return this;
        }

        public Builder<T> dictionary(int signatureWidth) {
            this.signatureWidth = -signatureWidth;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(BucketedHashStore<T> bucketedHashStore) {
            this.bucketedHashStore = bucketedHashStore;
            return this;
        }

        public Builder<T> store(BucketedHashStore<T> bucketedHashStore, int outputWidth) {
            this.bucketedHashStore = bucketedHashStore;
            this.outputWidth = outputWidth;
            return this;
        }

        public Builder<T> values(LongIterable values, int outputWidth) {
            this.values = values;
            this.outputWidth = outputWidth;
            return this;
        }

        public Builder<T> values(LongIterable values) {
            this.values = values;
            int outputWidth = 0;
            LongIterator i = values.iterator();
            while (i.hasNext()) {
                outputWidth = Math.max(outputWidth, Fast.length((long)i.nextLong()));
            }
            this.outputWidth = outputWidth;
            return this;
        }

        public Builder<T> indirect() {
            this.indirect = true;
            return this;
        }

        public GOV4Function<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            if (this.transform == null) {
                if (this.bucketedHashStore != null) {
                    this.transform = this.bucketedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given BucketedHashStore");
                }
            }
            return new GOV4Function<T>(this.keys, this.transform, this.signatureWidth, this.values, this.outputWidth, this.tempDir, this.bucketedHashStore, this.indirect);
        }
    }
}

