/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.sux4j.bits.AbstractRank;
import it.unimi.dsi.sux4j.bits.Rank;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Rank9
extends AbstractRank
implements Rank {
    private static final long serialVersionUID = 1L;
    protected transient long[] bits;
    protected final BitVector bitVector;
    protected final long[] count;
    protected final int numWords;
    protected final long numOnes;
    protected final long lastOne;

    public Rank9(long[] bits, long length) {
        this((BitVector)LongArrayBitVector.wrap((long[])bits, (long)length));
    }

    public Rank9(BitVector bitVector) {
        this.bitVector = bitVector;
        this.bits = bitVector.bits();
        long length = bitVector.length();
        this.numWords = LongArrayBitVector.words((long)length);
        int numCounts = (int)((length + 512L - 1L) / 512L) * 2;
        this.count = new long[numCounts + 1];
        long c = 0L;
        long l = -1L;
        int pos = 0;
        int i = 0;
        while (i < this.numWords) {
            this.count[pos] = c;
            c += (long)Long.bitCount(this.bits[i]);
            if (this.bits[i] != 0L) {
                l = LongArrayBitVector.bits((int)i) + (long)Fast.mostSignificantBit((long)this.bits[i]);
            }
            for (int j = 1; j < 8; ++j) {
                int n = pos + 1;
                this.count[n] = this.count[n] | (i + j <= this.numWords ? c - this.count[pos] : 511L) << 9 * (j - 1);
                if (i + j >= this.numWords) continue;
                c += (long)Long.bitCount(this.bits[i + j]);
                if (this.bits[i + j] == 0L) continue;
                l = LongArrayBitVector.bits((int)(i + j)) + (long)Fast.mostSignificantBit((long)this.bits[i + j]);
            }
            i += 8;
            pos += 2;
        }
        this.numOnes = c;
        this.lastOne = l;
        this.count[numCounts] = c;
    }

    @Override
    public long rank(long pos) {
        assert (pos >= 0L);
        assert (pos <= this.bitVector.length());
        if (pos > this.lastOne) {
            return this.numOnes;
        }
        int word = LongArrayBitVector.word((long)pos);
        int block = word >>> 2 & 0xFFFFFFFE;
        int offset = (word & 7) - 1;
        return this.count[block] + (this.count[block + 1] >>> (offset + (offset >>> 28 & 8)) * 9 & 0x1FFL) + (long)Long.bitCount(this.bits[word] & (1L << (int)pos) - 1L);
    }

    @Override
    public long numBits() {
        return (long)this.count.length * 64L;
    }

    @Override
    public long count() {
        return this.numOnes;
    }

    @Override
    public long rank(long from, long to) {
        return this.rank(to) - this.rank(from);
    }

    public long lastOne() {
        return this.lastOne;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.bits = this.bitVector.bits();
    }

    @Override
    public BitVector bitVector() {
        return this.bitVector;
    }
}

