/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.sux4j.bits.AbstractRank;
import it.unimi.dsi.sux4j.bits.Rank;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Rank16
extends AbstractRank
implements Rank {
    private static final long serialVersionUID = 1L;
    private static final int LOG2_BLOCK_LENGTH = 10;
    private static final int BLOCK_LENGTH = 1024;
    protected transient long[] bits;
    protected final long[] superCount;
    protected final short[] count;
    protected final int numWords;
    protected final long numOnes;
    protected final long lastOne;
    protected final BitVector bitVector;

    public Rank16(long[] bits, long length) {
        this((BitVector)LongArrayBitVector.wrap((long[])bits, (long)length));
    }

    public Rank16(BitVector bitVector) {
        this.bitVector = bitVector;
        this.bits = bitVector.bits();
        this.numWords = LongArrayBitVector.words((long)bitVector.length());
        int numSuperCounts = (int)(bitVector.length() + 1024L - 1L >>> 10);
        int numCounts = this.numWords + 1 >> 1;
        this.count = new short[numCounts];
        this.superCount = new long[numSuperCounts];
        long c = 0L;
        long l = -1L;
        for (int i = 0; i < this.numWords; ++i) {
            if ((i & 0x3FF) == 0) {
                this.superCount[i >>> 10] = c;
            }
            if (i % 2 == 0) {
                this.count[i >> 1] = (short)(c - this.superCount[i >>> 10]);
            }
            c += (long)Long.bitCount(this.bits[i]);
            if (this.bits[i] == 0L) continue;
            l = LongArrayBitVector.bits((int)i) + (long)Fast.mostSignificantBit((long)this.bits[i]);
        }
        this.numOnes = c;
        this.lastOne = l;
    }

    @Override
    public long rank(long pos) {
        assert (pos >= 0L);
        assert (pos <= this.bitVector.length());
        if (pos > this.lastOne) {
            return this.numOnes;
        }
        int word = LongArrayBitVector.word((long)pos);
        int block = word >>> 10;
        int offset = word >> 1;
        return (word & 1) == 0 ? this.superCount[block] + (long)(this.count[offset] & 0xFFFF) + (long)Long.bitCount(this.bits[word] & (1L << (int)pos) - 1L) : this.superCount[block] + (long)(this.count[offset] & 0xFFFF) + (long)Long.bitCount(this.bits[word - 1]) + (long)Long.bitCount(this.bits[word] & (1L << (int)pos) - 1L);
    }

    @Override
    public long numBits() {
        return (long)this.count.length * 16L + (long)this.superCount.length * 64L;
    }

    @Override
    public long count() {
        return this.numOnes;
    }

    @Override
    public long rank(long from, long to) {
        return this.rank(to) - this.rank(from);
    }

    public long lastOne() {
        return this.lastOne;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.bits = this.bitVector.bits();
    }

    @Override
    public BitVector bitVector() {
        return this.bitVector;
    }
}

