/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.sux4j.bits.AbstractRank;
import it.unimi.dsi.sux4j.bits.Rank;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Rank11
extends AbstractRank
implements Rank {
    private static final long serialVersionUID = 1L;
    private static final int LOG2_WORDS_PER_SUPERBLOCK = 5;
    private static final int WORDS_PER_SUPERBLOCK = 32;
    protected transient long[] bits;
    protected final BitVector bitVector;
    protected final long[] count;
    protected final int numWords;
    protected final long numOnes;
    protected final long lastOne;

    public Rank11(long[] bits, long length) {
        this((BitVector)LongArrayBitVector.wrap((long[])bits, (long)length));
    }

    public Rank11(BitVector bitVector) {
        this.bitVector = bitVector;
        this.bits = bitVector.bits();
        long length = bitVector.length();
        this.numWords = LongArrayBitVector.words((long)length);
        int numCounts = (int)((length + 2048L - 1L) / 2048L) * 2;
        this.count = new long[numCounts + 1];
        long c = 0L;
        long l = -1L;
        int pos = 0;
        int i = 0;
        while (i < this.numWords) {
            this.count[pos] = c;
            for (int j = 0; j < 32; ++j) {
                if (j != 0 && j % 6 == 0) {
                    int n = pos + 1;
                    this.count[n] = this.count[n] | (i + j <= this.numWords ? c - this.count[pos] : 2047L) << 12 * (j / 6 - 1);
                }
                if (i + j >= this.numWords) continue;
                if (this.bits[i + j] != 0L) {
                    l = LongArrayBitVector.bits((int)(i + j)) + (long)Fast.mostSignificantBit((long)this.bits[i + j]);
                }
                c += (long)Long.bitCount(this.bits[i + j]);
            }
            i += 32;
            pos += 2;
        }
        this.numOnes = c;
        this.lastOne = l;
        this.count[numCounts] = c;
    }

    @Override
    public long rank(long pos) {
        assert (pos >= 0L);
        assert (pos <= this.bitVector.length());
        if (pos > this.lastOne) {
            return this.numOnes;
        }
        int word = LongArrayBitVector.word((long)pos);
        int block = word >>> 4 & 0xFFFFFFFE;
        int offset = (word & 0x1F) / 6 - 1;
        long result = this.count[block] + (this.count[block + 1] >> 12 * (offset + (offset >>> 28 & 6)) & 0x7FFL) + (long)Long.bitCount(this.bits[word] & (1L << (int)pos) - 1L);
        int todo = (word & 0x1F) % 6;
        while (todo-- != 0) {
            result += (long)Long.bitCount(this.bits[--word]);
        }
        return result;
    }

    @Override
    public long numBits() {
        return LongArrayBitVector.bits((int)this.count.length);
    }

    @Override
    public long count() {
        return this.numOnes;
    }

    @Override
    public long rank(long from, long to) {
        return this.rank(to) - this.rank(from);
    }

    public long lastOne() {
        return this.lastOne;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.bits = this.bitVector.bits();
    }

    @Override
    public BitVector bitVector() {
        return this.bitVector;
    }
}

