/*
	* Copyright (C) 2020-2021 Sebastiano Vigna
	*
	* Licensed under the Apache License, Version 2.0 (the "License");
	* you may not use this file except in compliance with the License.
	* You may obtain a copy of the License at
	*
	*     http://www.apache.org/licenses/LICENSE-2.0
	*
	* Unless required by applicable law or agreed to in writing, software
	* distributed under the License is distributed on an "AS IS" BASIS,
	* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	* See the License for the specific language governing permissions and
	* limitations under the License.
	*/
package it.unimi.dsi.fastutil.chars;
/**
 * A type-specific {@link it.unimi.dsi.fastutil.Pair Pair}; provides some
 * additional methods that use polymorphism to avoid (un)boxing.
 */
public interface CharLongPair extends it.unimi.dsi.fastutil.Pair<Character, Long> {
	/**
	 * Returns the left element of this pair.
	 *
	 * @return the left element of this pair.
	 */
	public char leftChar();
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default Character left() {
		return Character.valueOf(leftChar());
	}
	/**
	 * Sets the left element of this pair (optional operation).
	 *
	 * @param l
	 *            a new value for the left element.
	 *
	 * @implSpec This implementation throws an
	 *           {@link UnsupportedOperationException}.
	 */
	public default CharLongPair left(final char l) {
		throw new UnsupportedOperationException();
	}
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default CharLongPair left(final Character l) {
		return left((l).charValue());
	}
	/**
	 * Returns the left element of this pair.
	 *
	 * @return the left element of this pair.
	 *
	 * @implSpec This implementation delegates to {@link #left()}.
	 *
	 */
	public default char firstChar() {
		return leftChar();
	}
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default Character first() {
		return Character.valueOf(firstChar());
	}
	/**
	 * Sets the left element of this pair (optional operation).
	 *
	 * @param l
	 *            a new value for the left element.
	 *
	 * @implSpec This implementation delegates to {@link #left(Object)}.
	 */
	public default CharLongPair first(final char l) {
		return left(l);
	}
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default CharLongPair first(final Character l) {
		return first((l).charValue());
	}
	/**
	 * Returns the left element of this pair.
	 *
	 * @return the left element of this pair.
	 *
	 * @implSpec This implementation delegates to {@link #left()}.
	 *
	 */
	public default char keyChar() {
		return firstChar();
	}
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default Character key() {
		return Character.valueOf(keyChar());
	}
	/**
	 * Sets the left element of this pair (optional operation).
	 *
	 * @param l
	 *            a new value for the left element.
	 *
	 * @implSpec This implementation delegates to {@link #left(Object)}.
	 */
	public default CharLongPair key(final char l) {
		return left(l);
	}
	@Override
	@Deprecated
	public default CharLongPair key(Character l) {
		return key((l).charValue());
	}
	/**
	 * Returns the right element of this pair.
	 *
	 * @return the right element of this pair.
	 */
	public long rightLong();
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default Long right() {
		return Long.valueOf(rightLong());
	}
	/**
	 * Sets the right element of this pair (optional operation).
	 *
	 * @param r
	 *            a new value for the right element.
	 *
	 * @implSpec This implementation throws an
	 *           {@link UnsupportedOperationException}.
	 */
	public default CharLongPair right(final long r) {
		throw new UnsupportedOperationException();
	}
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default CharLongPair right(final Long l) {
		return right((l).longValue());
	}
	/**
	 * Returns the right element of this pair.
	 *
	 * @return the right element of this pair.
	 *
	 * @implSpec This implementation delegates to {@link #right()}.
	 *
	 */
	public default long secondLong() {
		return rightLong();
	}
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default Long second() {
		return Long.valueOf(secondLong());
	}
	/**
	 * Sets the right element of this pair (optional operation).
	 *
	 * @param r
	 *            a new value for the right element.
	 *
	 * @implSpec This implementation delegates to {@link #right(Object)}.
	 */
	public default CharLongPair second(final long r) {
		return right(r);
	}
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default CharLongPair second(final Long l) {
		return second((l).longValue());
	}
	/**
	 * Returns the right element of this pair.
	 *
	 * @return the right element of this pair.
	 *
	 * @implSpec This implementation delegates to {@link #right()}.
	 *
	 */
	public default long valueLong() {
		return rightLong();
	}
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default Long value() {
		return Long.valueOf(valueLong());
	}
	/**
	 * Sets the right element of this pair (optional operation).
	 *
	 * @param r
	 *            a new value for the right element.
	 *
	 * @implSpec This implementation delegates to {@link #right(Object)}.
	 */
	public default CharLongPair value(final long r) {
		return right(r);
	}
	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@SuppressWarnings("deprecation")
	@Deprecated
	@Override
	public default CharLongPair value(final Long l) {
		return value((l).longValue());
	}
	/**
	 * Returns a new type-specific immutable {@link it.unimi.dsi.fastutil.Pair Pair}
	 * with given left and right value.
	 * 
	 * @param left
	 *            the left value.
	 * @param right
	 *            the right value.
	 */
	public static CharLongPair of(final char left, final long right) {
		return new CharLongImmutablePair(left, right);
	}
}
