/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.NoSuchElementException;

public class IntArrayFIFOQueue
extends AbstractIntPriorityQueue {
    public static final int INITIAL_CAPACITY = 16;
    protected int[] array = IntArrays.EMPTY_ARRAY;
    protected int length;
    protected int start;
    protected int end;

    public IntArrayFIFOQueue(int capacity) {
        if (capacity > 0) {
            this.array = new int[capacity];
        }
        this.length = this.array.length;
    }

    public IntArrayFIFOQueue() {
        this(16);
    }

    @Override
    public IntComparator comparator() {
        return null;
    }

    @Override
    public int dequeueInt() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        int t = this.array[this.start];
        if (++this.start == this.length) {
            this.start = 0;
        }
        return t;
    }

    @Override
    public void enqueue(int x) {
        this.array[this.end++] = x;
        if (this.end == this.length) {
            this.end = 0;
        }
        if (this.end == this.start) {
            int[] newArray = IntArrays.grow(this.array, this.length + 1, 0);
            System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
            System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
            this.start = 0;
            this.end = this.length;
            this.array = newArray;
            this.length = newArray.length;
        }
    }

    @Override
    public int firstInt() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[this.start];
    }

    @Override
    public int lastInt() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[(this.end == 0 ? this.length : this.end) - 1];
    }

    @Override
    public void clear() {
        this.end = 0;
        this.start = 0;
    }

    public void trim() {
        int size = this.size();
        int[] newArray = new int[size + 1];
        if (this.start <= this.end) {
            System.arraycopy(this.array, this.start, newArray, 0, this.end - this.start);
        } else {
            System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
            System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
        }
        this.start = 0;
        this.end = size;
        this.length = this.end + 1;
        this.array = newArray;
    }

    @Override
    public int size() {
        int apparentLength = this.end - this.start;
        return apparentLength >= 0 ? apparentLength : this.length + apparentLength;
    }
}

