/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractCharPriorityQueue;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharComparator;
import java.util.NoSuchElementException;

public class CharArrayFIFOQueue
extends AbstractCharPriorityQueue {
    public static final int INITIAL_CAPACITY = 16;
    protected char[] array = CharArrays.EMPTY_ARRAY;
    protected int length;
    protected int start;
    protected int end;

    public CharArrayFIFOQueue(int capacity) {
        if (capacity > 0) {
            this.array = new char[capacity];
        }
        this.length = this.array.length;
    }

    public CharArrayFIFOQueue() {
        this(16);
    }

    @Override
    public CharComparator comparator() {
        return null;
    }

    @Override
    public char dequeueChar() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        char t = this.array[this.start];
        if (++this.start == this.length) {
            this.start = 0;
        }
        return t;
    }

    @Override
    public void enqueue(char x) {
        this.array[this.end++] = x;
        if (this.end == this.length) {
            this.end = 0;
        }
        if (this.end == this.start) {
            char[] newArray = CharArrays.grow(this.array, this.length + 1, 0);
            System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
            System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
            this.start = 0;
            this.end = this.length;
            this.array = newArray;
            this.length = newArray.length;
        }
    }

    @Override
    public char firstChar() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[this.start];
    }

    @Override
    public char lastChar() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[(this.end == 0 ? this.length : this.end) - 1];
    }

    @Override
    public void clear() {
        this.end = 0;
        this.start = 0;
    }

    public void trim() {
        int size = this.size();
        char[] newArray = new char[size + 1];
        if (this.start <= this.end) {
            System.arraycopy(this.array, this.start, newArray, 0, this.end - this.start);
        } else {
            System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
            System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
        }
        this.start = 0;
        this.end = size;
        this.length = this.end + 1;
        this.array = newArray;
    }

    @Override
    public int size() {
        int apparentLength = this.end - this.start;
        return apparentLength >= 0 ? apparentLength : this.length + apparentLength;
    }
}

