/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.webmvc;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.servlet.HttpServletAdapter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public final class TracingHandlerInterceptor
implements HandlerInterceptor {
    static final String BEST_MATCHING_PATTERN_ATTRIBUTE = "org.springframework.web.servlet.HandlerMapping.bestMatchingPattern";
    static final Propagation.Getter<HttpServletRequest, String> GETTER = new Propagation.Getter<HttpServletRequest, String>(){

        public String get(HttpServletRequest carrier, String key) {
            return carrier.getHeader(key);
        }

        public String toString() {
            return "HttpServletRequest::getHeader";
        }
    };
    final Tracer tracer;
    final HttpServerHandler<HttpServletRequest, HttpServletResponse> handler;
    final TraceContext.Extractor<HttpServletRequest> extractor;

    public static HandlerInterceptor create(Tracing tracing) {
        return new TracingHandlerInterceptor(HttpTracing.create((Tracing)tracing));
    }

    public static HandlerInterceptor create(HttpTracing httpTracing) {
        return new TracingHandlerInterceptor(httpTracing);
    }

    @Autowired
    TracingHandlerInterceptor(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)new Adapter());
        this.extractor = httpTracing.tracing().propagation().extractor(GETTER);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) {
        if (request.getAttribute(Tracer.SpanInScope.class.getName()) != null) {
            return true;
        }
        Span span = this.handler.handleReceive(this.extractor, (Object)request);
        request.setAttribute(Tracer.SpanInScope.class.getName(), (Object)this.tracer.withSpanInScope(span));
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception ex) {
        Span span = this.tracer.currentSpan();
        if (span == null) {
            return;
        }
        ((Tracer.SpanInScope)request.getAttribute(Tracer.SpanInScope.class.getName())).close();
        Object template = request.getAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE);
        this.handler.handleSend((Object)new DecoratedHttpServletResponse(response, request.getMethod(), template), (Throwable)ex, span);
    }

    static final class Adapter
    extends HttpServletAdapter {
        Adapter() {
        }

        public String methodFromResponse(HttpServletResponse response) {
            return ((DecoratedHttpServletResponse)response).method;
        }

        public String route(HttpServletResponse response) {
            return ((DecoratedHttpServletResponse)response).template;
        }

        public String toString() {
            return "WebMVCAdapter{}";
        }
    }

    static class DecoratedHttpServletResponse
    extends HttpServletResponseWrapper {
        final String method;
        final String template;

        DecoratedHttpServletResponse(HttpServletResponse response, String method, Object template) {
            super(response);
            this.method = method;
            this.template = template != null ? template.toString() : "";
        }
    }
}

