/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.rbac.api;

import io.weaviate.client.v1.rbac.api.WeaviatePermission;
import io.weaviate.client.v1.rbac.model.Permission;
import io.weaviate.client.v1.rbac.model.Role;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class WeaviateRole {
    String name;
    List<WeaviatePermission> permissions;

    public WeaviateRole(String name, List<Permission<?>> permissions) {
        this.name = name;
        this.permissions = WeaviatePermission.mergePermissions(permissions);
    }

    WeaviateRole(String name, WeaviatePermission ... permissions) {
        this.name = name;
        this.permissions = Arrays.asList(permissions);
    }

    public Role toRole() {
        List<Permission<?>> permissions = this.permissions.stream().map(perm -> Permission.fromWeaviate(perm)).filter(Objects::nonNull).collect(Collectors.toList());
        return new Role(this.name, Permission.merge(permissions));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<WeaviatePermission> getPermissions() {
        return this.permissions;
    }
}

