/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import lombok.Generated;

public class Bm25Argument
implements Argument {
    private final String query;
    private final String[] properties;
    private final SearchOperator searchOperator;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        arg.add(String.format("query:%s", Serializer.quote(this.query)));
        if (this.properties != null) {
            arg.add(String.format("properties:%s", Serializer.arrayWithQuotes(this.properties)));
        }
        if (this.searchOperator != null) {
            arg.add(String.format("searchOperator:%s", this.searchOperator.build()));
        }
        return String.format("bm25:{%s}", String.join((CharSequence)" ", arg));
    }

    @Generated
    Bm25Argument(String query, String[] properties, SearchOperator searchOperator) {
        this.query = query;
        this.properties = properties;
        this.searchOperator = searchOperator;
    }

    @Generated
    public static Bm25ArgumentBuilder builder() {
        return new Bm25ArgumentBuilder();
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String[] getProperties() {
        return this.properties;
    }

    @Generated
    public SearchOperator getSearchOperator() {
        return this.searchOperator;
    }

    @Generated
    public String toString() {
        return "Bm25Argument(query=" + this.getQuery() + ", properties=" + Arrays.deepToString(this.getProperties()) + ", searchOperator=" + this.getSearchOperator() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bm25Argument)) {
            return false;
        }
        Bm25Argument other = (Bm25Argument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getProperties(), other.getProperties())) {
            return false;
        }
        SearchOperator this$searchOperator = this.getSearchOperator();
        SearchOperator other$searchOperator = other.getSearchOperator();
        return !(this$searchOperator == null ? other$searchOperator != null : !this$searchOperator.equals(other$searchOperator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bm25Argument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProperties());
        SearchOperator $searchOperator = this.getSearchOperator();
        result = result * 59 + ($searchOperator == null ? 43 : $searchOperator.hashCode());
        return result;
    }

    public static class SearchOperator
    implements Argument {
        private static final String OR = "Or";
        private static final String AND = "And";
        private String operator;
        private int minimumMatch;

        public static SearchOperator and() {
            return new SearchOperator(AND, 0);
        }

        public static SearchOperator or(int minimumMatch) {
            return new SearchOperator(OR, minimumMatch);
        }

        @Override
        public String build() {
            return String.format("{operator:%s minimumOrTokensMatch:%s}", this.operator, this.minimumMatch);
        }

        @Generated
        private SearchOperator(String operator, int minimumMatch) {
            this.operator = operator;
            this.minimumMatch = minimumMatch;
        }
    }

    @Generated
    public static class Bm25ArgumentBuilder {
        @Generated
        private String query;
        @Generated
        private String[] properties;
        @Generated
        private SearchOperator searchOperator;

        @Generated
        Bm25ArgumentBuilder() {
        }

        @Generated
        public Bm25ArgumentBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        public Bm25ArgumentBuilder properties(String[] properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public Bm25ArgumentBuilder searchOperator(SearchOperator searchOperator) {
            this.searchOperator = searchOperator;
            return this;
        }

        @Generated
        public Bm25Argument build() {
            return new Bm25Argument(this.query, this.properties, this.searchOperator);
        }

        @Generated
        public String toString() {
            return "Bm25Argument.Bm25ArgumentBuilder(query=" + this.query + ", properties=" + Arrays.deepToString(this.properties) + ", searchOperator=" + this.searchOperator + ")";
        }
    }
}

