/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.experimental;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.weaviate.client.Config;
import io.weaviate.client.base.grpc.GrpcClient;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoProperties;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoSearchGet;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.experimental.NearVector;
import io.weaviate.client.v1.experimental.SearchResult;
import io.weaviate.client.v1.grpc.GRPC;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SearchClient<T> {
    private final AccessTokenProvider tokenProvider;
    private final Config config;
    private final String collection;
    private final Gson gson;
    private final Class<T> cls;

    public SearchResult<Map<String, Object>> nearVectorUntyped(float[] vector) {
        return this.nearVectorUntyped(vector, nop -> {});
    }

    public SearchResult<Map<String, Object>> nearVectorUntyped(float[] vector, Consumer<NearVector.Options> options) {
        NearVector operator = new NearVector(vector, options);
        WeaviateProtoSearchGet.SearchRequest.Builder req = WeaviateProtoSearchGet.SearchRequest.newBuilder();
        req.setCollection(this.collection);
        req.setUses123Api(true);
        req.setUses125Api(true);
        req.setUses127Api(true);
        operator.append(req);
        return this.searchUntyped(req.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResult<Map<String, Object>> searchUntyped(WeaviateProtoSearchGet.SearchRequest req) {
        GrpcClient grpc = GrpcClient.create(this.config, this.tokenProvider);
        try {
            SearchResult<Map<String, Object>> searchResult = SearchClient.deserializeUntyped(grpc.search(req));
            return searchResult;
        }
        finally {
            grpc.shutdown();
        }
    }

    public static SearchResult<Map<String, Object>> deserializeUntyped(WeaviateProtoSearchGet.SearchReply reply) {
        List objects = reply.getResultsList().stream().map(res -> {
            Map<String, Object> properties = SearchClient.convertProtoMap(res.getProperties().getNonRefProps().getFieldsMap());
            WeaviateProtoSearchGet.MetadataResult meta = res.getMetadata();
            SearchResult.SearchObject.SearchMetadata metadata = new SearchResult.SearchObject.SearchMetadata(meta.getId(), meta.getDistancePresent() ? Float.valueOf(meta.getDistance()) : null, GRPC.fromByteString(meta.getVectorBytes()));
            return new SearchResult.SearchObject<Map<String, Object>>(properties, metadata);
        }).collect(Collectors.toList());
        return new SearchResult<Map<String, Object>>(objects);
    }

    public SearchResult<T> nearVector(float[] vector) {
        return this.nearVector(vector, nop -> {});
    }

    public SearchResult<T> nearVector(float[] vector, Consumer<NearVector.Options> options) {
        NearVector operator = new NearVector(vector, options);
        WeaviateProtoSearchGet.SearchRequest.Builder req = WeaviateProtoSearchGet.SearchRequest.newBuilder();
        req.setCollection(this.collection);
        req.setUses123Api(true);
        req.setUses125Api(true);
        req.setUses127Api(true);
        operator.append(req);
        return this.search(req.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResult<T> search(WeaviateProtoSearchGet.SearchRequest req) {
        GrpcClient grpc = GrpcClient.create(this.config, this.tokenProvider);
        try {
            SearchResult<T> searchResult = this.deserialize(grpc.search(req));
            return searchResult;
        }
        finally {
            grpc.shutdown();
        }
    }

    private SearchResult<T> deserialize(WeaviateProtoSearchGet.SearchReply reply) {
        List objects = reply.getResultsList().stream().map(res -> {
            Map<String, Object> propertiesMap = SearchClient.convertProtoMap(res.getProperties().getNonRefProps().getFieldsMap());
            JsonElement el = this.gson.toJsonTree(propertiesMap);
            Object properties = this.gson.fromJson(el, this.cls);
            WeaviateProtoSearchGet.MetadataResult meta = res.getMetadata();
            SearchResult.SearchObject.SearchMetadata metadata = new SearchResult.SearchObject.SearchMetadata(meta.getId(), meta.getDistancePresent() ? Float.valueOf(meta.getDistance()) : null, GRPC.fromByteString(meta.getVectorBytes()));
            return new SearchResult.SearchObject<Object>(properties, metadata);
        }).collect(Collectors.toList());
        return new SearchResult(objects);
    }

    private static Map<String, Object> convertProtoMap(Map<String, WeaviateProtoProperties.Value> map) {
        return map.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), SearchClient.convertProtoValue((WeaviateProtoProperties.Value)e.getValue())), HashMap::putAll);
    }

    private static Object convertProtoValue(WeaviateProtoProperties.Value value) {
        if (value.hasTextValue()) {
            return value.getTextValue();
        }
        if (value.hasBoolValue()) {
            return value.getBoolValue();
        }
        if (value.hasIntValue()) {
            return value.getIntValue();
        }
        if (value.hasNumberValue()) {
            return value.getNumberValue();
        }
        if (value.hasDateValue()) {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(value.getDateValue());
            return Date.from(offsetDateTime.toInstant());
        }
        if (value.hasNullValue()) {
            return null;
        }
        assert (false) : "branch not covered";
        return null;
    }

    SearchClient(Config config, AccessTokenProvider tokenProvider, String collection, Class<T> cls) {
        this.config = config;
        this.tokenProvider = tokenProvider;
        this.collection = collection;
        this.gson = new Gson();
        this.cls = cls;
    }
}

