/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.experimental;

import io.weaviate.client.Config;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.util.DbVersionSupport;
import io.weaviate.client.base.util.GrpcVersionSupport;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.batch.Batch;
import io.weaviate.client.v1.batch.api.ObjectsBatcher;
import io.weaviate.client.v1.batch.model.ObjectGetResponse;
import io.weaviate.client.v1.data.Data;
import io.weaviate.client.v1.data.model.WeaviateObject;
import io.weaviate.client.v1.experimental.Batcher$InsertBatch$;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.time.DateFormatUtils;

public class Batcher<T>
implements AutoCloseable {
    private final Class<T> cls;
    private final ObjectsBatcher objectsBatcher;

    public Batcher(Config config, HttpClient httpClient, AccessTokenProvider tokenProvider, DbVersionSupport dbVersion, GrpcVersionSupport grpcVersion, Data data, Class<T> cls) {
        this.cls = cls;
        this.objectsBatcher = new Batch(httpClient, config, dbVersion, grpcVersion, tokenProvider, data).objectsBatcher();
    }

    public boolean insert(Consumer<InsertBatch<T>> data) {
        InsertBatch<T> batch = new InsertBatch<T>(this.cls, data);
        batch.append(this.objectsBatcher);
        Result<ObjectGetResponse[]> result = this.objectsBatcher.run();
        return !result.hasErrors();
    }

    @Override
    public void close() {
        this.objectsBatcher.close();
    }

    public static class InsertBatch<T> {
        private final Class<T> cls;
        private final List<InsertBatch$$WeaviateObject<T>> objects = new ArrayList<InsertBatch$$WeaviateObject<T>>();

        public void add(T properties) {
            this.add(properties, null, null);
        }

        public void add(T properties, String id) {
            this.add(properties, id, null);
        }

        public void add(T properties, Float[] vector) {
            this.add(properties, null, vector);
        }

        public void add(T properties, String id, Float[] vector) {
            this.objects.add(new InsertBatch$$WeaviateObject<T>(id, vector, properties));
        }

        InsertBatch(Class<T> cls, Consumer<InsertBatch<T>> populate) {
            this.cls = cls;
            populate.accept(this);
        }

        void append(ObjectsBatcher batcher) {
            for (InsertBatch$$WeaviateObject<T> object : this.objects) {
                batcher.withObject(WeaviateObject.builder().className(this.cls.getSimpleName() + "s").vector(object.vector).properties(this.toMap(object.properties)).id(object.id).build());
            }
        }

        private Map<String, Object> toMap(T properties) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            for (Field field : this.cls.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object value = field.get(properties);
                    if (value instanceof Date) {
                        value = DateFormatUtils.format((Date)((Date)value), (String)"yyyy-MM-dd'T'HH:mm:ssZZZZZ");
                    }
                    fieldMap.put(field.getName(), value);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return fieldMap;
        }
    }
}

