/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client;

import io.weaviate.client.Config;
import io.weaviate.client.WeaviateClient;
import io.weaviate.client.v1.auth.ApiKeyFlow;
import io.weaviate.client.v1.auth.BearerTokenFlow;
import io.weaviate.client.v1.auth.ClientCredentialsFlow;
import io.weaviate.client.v1.auth.ResourceOwnerPasswordFlow;
import io.weaviate.client.v1.auth.exception.AuthException;
import java.util.List;

public class WeaviateAuthClient {
    private static final String HEADER_X_WEAVIATE_API_KEY = "X-Weaviate-Api-Key";
    private static final String HEADER_X_WEAVIATE_CLUSTER_URL = "X-Weaviate-Cluster-URL";

    public static WeaviateClient clientCredentials(Config config, String clientSecret, List<String> scopes) throws AuthException {
        ClientCredentialsFlow clientCredentialsFlow = new ClientCredentialsFlow(clientSecret);
        return clientCredentialsFlow.getAuthClient(config, scopes);
    }

    public static WeaviateClient clientPassword(Config config, String username, String password, List<String> scopes) throws AuthException {
        ResourceOwnerPasswordFlow resourceOwnerPasswordFlow = new ResourceOwnerPasswordFlow(username, password);
        return resourceOwnerPasswordFlow.getAuthClient(config, scopes);
    }

    public static WeaviateClient bearerToken(Config config, String accessToken, long accessTokenLifetime, String refreshToken) throws AuthException {
        BearerTokenFlow bearerTokenFlow = new BearerTokenFlow(accessToken, accessTokenLifetime, refreshToken);
        return bearerTokenFlow.getAuthClient(config, null);
    }

    public static WeaviateClient apiKey(Config config, String apiKey) throws AuthException {
        ApiKeyFlow flow = new ApiKeyFlow(apiKey);
        if (WeaviateAuthClient.isWeaviateDomain(config.getHost())) {
            WeaviateAuthClient.addWeaviateHeaders(config, apiKey);
        }
        return flow.getAuthClient(config);
    }

    private static void addWeaviateHeaders(Config config, String apiKey) {
        config.setHeader(HEADER_X_WEAVIATE_API_KEY, apiKey);
        config.setHeader(HEADER_X_WEAVIATE_CLUSTER_URL, "https://" + config.getHost());
    }

    private static boolean isWeaviateDomain(String host) {
        String lower = host.toLowerCase();
        return lower.contains("weaviate.io") || lower.contains("semi.technology") || lower.contains("weaviate.cloud");
    }
}

