/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.override;

import io.wcm.config.spi.ParameterOverrideProvider;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true, metatype=true, label="wcm.io Configuration Property Override Provider: Request Header", description="Allows to define configuration property default values or overrides from inconming request headers.")
@Service(value={ParameterOverrideProvider.class, Filter.class})
public final class RequestHeaderOverrideProvider
implements ParameterOverrideProvider,
Filter {
    public static final String REQUEST_HEADER_PREFIX = "config.override.";
    private static final ThreadLocal<Map<String, String>> OVERRIDE_MAP_THREADLOCAL = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    @Property(label="Enabled", boolValue={false}, description="Enable parameter override provider")
    static final String PROPERTY_ENABLED = "enabled";
    static final boolean DEFAULT_ENABLED = false;
    @Property(label="Service Ranking", intValue={1000}, description="Priority of parameter override providers (lower = higher priority)", propertyPrivate=false)
    static final String PROPERTY_RANKING = "service.ranking";
    static final int DEFAULT_RANKING = 1000;
    private boolean enabled;

    public Map<String, String> getOverrideMap() {
        return OVERRIDE_MAP_THREADLOCAL.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabled && request instanceof HttpServletRequest) {
            Map<String, String> map = OVERRIDE_MAP_THREADLOCAL.get();
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            Enumeration keys = httpRequest.getHeaderNames();
            while (keys.hasMoreElements()) {
                String key;
                Object keyObject = keys.nextElement();
                if (!(keyObject instanceof String) || !StringUtils.startsWith((CharSequence)(key = (String)keyObject), (CharSequence)REQUEST_HEADER_PREFIX)) continue;
                map.put(StringUtils.substringAfter((String)key, (String)REQUEST_HEADER_PREFIX), httpRequest.getHeader(key));
            }
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            if (this.enabled) {
                OVERRIDE_MAP_THREADLOCAL.get().clear();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    @Activate
    void activate(ComponentContext ctx) {
        Dictionary config = ctx.getProperties();
        this.enabled = PropertiesUtil.toBoolean(config.get(PROPERTY_ENABLED), (boolean)false);
    }
}

