/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.override;

import com.google.common.collect.ImmutableMap;
import io.wcm.config.spi.ParameterOverrideProvider;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true, metatype=true, configurationFactory=true, label="wcm.io Configuration Property Override Provider: OSGi configuration", description="Allows to define configuration property default values or overrides from OSGi configuration.")
@Service(value={ParameterOverrideProvider.class})
public final class OsgiConfigOverrideProvider
implements ParameterOverrideProvider {
    @Property(label="Enabled", boolValue={false}, description="Enable parameter override provider")
    static final String PROPERTY_ENABLED = "enabled";
    static final boolean DEFAULT_ENABLED = false;
    @Property(label="Service Ranking", intValue={3000}, description="Priority of parameter override providers (lower = higher priority)", propertyPrivate=false)
    static final String PROPERTY_RANKING = "service.ranking";
    static final int DEFAULT_RANKING = 3000;
    @Property(label="Overrides", cardinality=0x7FFFFFFF, description="Key/Value pairs defining parameter overrides.\nSyntax: [{scope}]{parameterName}={value}\nExamples:\n[default]param1 - Override default value for parameter 'param1'\nparam1 - Override value for parameter 'param1' for all configurations\n[/content/region1/site1]param1 - Override value for parameter 'param1' for the configurations at /content/region1/site1. This has higher precedence than the other variants.")
    static final String PROPERTY_OVERRIDES = "overrides";
    static final String[] DEFAULT_OVERRIDES = new String[0];
    private Map<String, String> overrideMap;

    public Map<String, String> getOverrideMap() {
        return this.overrideMap;
    }

    @Activate
    void activate(ComponentContext ctx) {
        Map overrides;
        Dictionary config = ctx.getProperties();
        boolean enabled = PropertiesUtil.toBoolean(config.get(PROPERTY_ENABLED), (boolean)false);
        HashMap map = new HashMap();
        if (enabled && (overrides = PropertiesUtil.toMap(config.get(PROPERTY_OVERRIDES), (String[])DEFAULT_OVERRIDES)) != null) {
            map.putAll(overrides);
        }
        this.overrideMap = ImmutableMap.copyOf(map);
    }
}

