/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.management.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import io.wcm.config.api.Parameter;
import io.wcm.config.core.management.ParameterOverride;
import io.wcm.config.core.management.ParameterPersistence;
import io.wcm.config.core.management.ParameterPersistenceData;
import io.wcm.config.core.management.ParameterResolver;
import io.wcm.config.core.management.impl.PersistenceTypeConversion;
import io.wcm.config.core.util.TypeConversion;
import io.wcm.config.spi.ParameterProvider;
import io.wcm.sling.commons.osgi.RankedServices;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=false)
@Service(value={ParameterResolver.class})
public final class ParameterResolverImpl
implements ParameterResolver {
    private static final Logger log = LoggerFactory.getLogger(ParameterResolverImpl.class);
    @Reference
    private ParameterPersistence parameterPersistence;
    @Reference
    private ParameterOverride parameterOverride;
    private BundleContext bundleContext;
    private volatile Set<Parameter<?>> allParameters = ImmutableSet.of();
    private volatile Map<String, Parameter<?>> allParametersMap = ImmutableMap.of();
    @Reference(name="parameterProvider", referenceInterface=ParameterProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<ParameterProvider> parameterProviders = new RankedServices((RankedServices.ChangeListener)new ParameterProviderChangeListener());

    @Override
    public Map<String, Object> getEffectiveValues(ResourceResolver resolver, Collection<String> configurationIds) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        this.applyDefaultValues(parameterValues);
        this.applyOverrideSystemDefault(parameterValues);
        String[] configurationIdArray = (String[])Iterators.toArray(configurationIds.iterator(), String.class);
        Object lockedParameterNames = ImmutableSortedSet.of();
        for (int i = configurationIdArray.length - 1; i >= 0; --i) {
            String configurationId = configurationIdArray[i];
            lockedParameterNames = this.applyConfiguredValues(resolver, configurationId, parameterValues, (SortedSet<String>)lockedParameterNames);
            this.applyOverrideForce(configurationId, parameterValues);
        }
        return parameterValues;
    }

    @Override
    public Set<Parameter<?>> getAllParameters() {
        return this.allParameters;
    }

    private void applyDefaultValues(Map<String, Object> parameterValues) {
        for (Parameter<?> parameter : this.allParameters) {
            parameterValues.put(parameter.getName(), this.getParameterDefaultValue(parameter));
        }
    }

    private <T> T getParameterDefaultValue(Parameter<T> parameter) {
        String defaultOsgiConfigProperty = parameter.getDefaultOsgiConfigProperty();
        if (StringUtils.isNotBlank((CharSequence)defaultOsgiConfigProperty)) {
            String[] parts = StringUtils.split((String)defaultOsgiConfigProperty, (String)":");
            String className = parts[0];
            String propertyName = parts[1];
            ServiceReference ref = this.bundleContext.getServiceReference(className);
            if (ref != null) {
                Object value = ref.getProperty(propertyName);
                return (T)TypeConversion.osgiPropertyToObject(value, parameter.getType(), parameter.getDefaultValue());
            }
        }
        return (T)parameter.getDefaultValue();
    }

    private void applyOverrideSystemDefault(Map<String, Object> parameterValues) {
        for (Parameter<?> parameter : this.allParameters) {
            Object overrideValue = this.parameterOverride.getOverrideSystemDefault(parameter);
            if (overrideValue == null) continue;
            parameterValues.put(parameter.getName(), overrideValue);
        }
    }

    private SortedSet<String> applyConfiguredValues(ResourceResolver resolver, String configurationId, Map<String, Object> parameterValues, SortedSet<String> ancestorLockedParameterNames) {
        ParameterPersistenceData data = this.parameterPersistence.getData(resolver, configurationId);
        Map<String, Object> configuredValues = this.ensureValidValueTypes(data.getValues());
        if (!ancestorLockedParameterNames.isEmpty()) {
            for (Map.Entry<String, Object> entry : configuredValues.entrySet()) {
                if (ancestorLockedParameterNames.contains(entry.getKey())) continue;
                parameterValues.put(entry.getKey(), entry.getValue());
            }
        } else {
            parameterValues.putAll(configuredValues);
        }
        SortedSet<String> lockedParameterNames = ancestorLockedParameterNames;
        if (!data.getLockedParameterNames().isEmpty()) {
            lockedParameterNames = new TreeSet<String>();
            lockedParameterNames.addAll(ancestorLockedParameterNames);
            lockedParameterNames.addAll(data.getLockedParameterNames());
        }
        return lockedParameterNames;
    }

    private Map<String, Object> ensureValidValueTypes(Map<String, Object> parameterValues) {
        HashMap<String, Object> transformedParameterValues = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : parameterValues.entrySet()) {
            Parameter<?> parameter;
            if (entry.getKey() == null || entry.getValue() == null || (parameter = this.allParametersMap.get(entry.getKey())) == null) continue;
            Object transformedValue = PersistenceTypeConversion.fromPersistenceType(entry.getValue(), parameter.getType());
            if (!parameter.getType().isAssignableFrom(transformedValue.getClass())) continue;
            transformedParameterValues.put(entry.getKey(), transformedValue);
        }
        return transformedParameterValues;
    }

    private void applyOverrideForce(String configurationId, Map<String, Object> parameterValues) {
        for (Parameter<?> parameter : this.allParameters) {
            Object overrideValue = this.parameterOverride.getOverrideForce(configurationId, parameter);
            if (overrideValue == null) continue;
            parameterValues.put(parameter.getName(), overrideValue);
        }
    }

    private void validateParameterProviders() {
        HashSet<String> applicationIds = new HashSet<String>();
        HashSet<String> parameterNames = new HashSet<String>();
        for (ParameterProvider provider : this.parameterProviders) {
            HashSet<String> applicationIdsOfThisProvider = new HashSet<String>();
            for (Parameter parameter : provider.getParameters()) {
                if (StringUtils.isNotEmpty((CharSequence)parameter.getApplicationId())) {
                    applicationIdsOfThisProvider.add(parameter.getApplicationId());
                }
                if (parameterNames.contains(parameter.getName())) {
                    log.warn("Parameter name is not unique: {} (application: {})", (Object)parameter.getName(), (Object)parameter.getApplicationId());
                    continue;
                }
                parameterNames.add(parameter.getName());
            }
            if (applicationIdsOfThisProvider.size() > 1) {
                log.warn("Parameter provider {} defines parameters with multiple application Ids: {}", (Object)provider, (Object)applicationIdsOfThisProvider.toArray(new String[applicationIdsOfThisProvider.size()]));
                continue;
            }
            if (applicationIdsOfThisProvider.size() != 1) continue;
            String applicationId = (String)applicationIdsOfThisProvider.iterator().next();
            if (applicationIds.contains(applicationId)) {
                log.warn("Parameter provider application id is not unique: {}", (Object)applicationId);
                continue;
            }
            applicationIds.add(applicationId);
        }
    }

    @Activate
    void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
    }

    void bindParameterProvider(ParameterProvider service, Map<String, Object> props) {
        this.parameterProviders.bind((Object)service, props);
        this.validateParameterProviders();
    }

    void unbindParameterProvider(ParameterProvider service, Map<String, Object> props) {
        this.parameterProviders.unbind((Object)service, props);
    }

    protected void bindParameterPersistence(ParameterPersistence parameterPersistence) {
        this.parameterPersistence = parameterPersistence;
    }

    protected void unbindParameterPersistence(ParameterPersistence parameterPersistence) {
        if (this.parameterPersistence == parameterPersistence) {
            this.parameterPersistence = null;
        }
    }

    protected void bindParameterOverride(ParameterOverride parameterOverride) {
        this.parameterOverride = parameterOverride;
    }

    protected void unbindParameterOverride(ParameterOverride parameterOverride) {
        if (this.parameterOverride == parameterOverride) {
            this.parameterOverride = null;
        }
    }

    private class ParameterProviderChangeListener
    implements RankedServices.ChangeListener {
        private ParameterProviderChangeListener() {
        }

        public void changed() {
            TreeSet parameters = new TreeSet();
            for (ParameterProvider provider : ParameterResolverImpl.this.parameterProviders) {
                parameters.addAll(provider.getParameters());
            }
            ParameterResolverImpl.this.allParameters = (Set)ImmutableSortedSet.copyOf(parameters);
            TreeMap<String, Parameter> parameterMap = new TreeMap<String, Parameter>();
            for (Parameter parameter : ParameterResolverImpl.this.allParameters) {
                parameterMap.put(parameter.getName(), parameter);
            }
            ParameterResolverImpl.this.allParametersMap = (Map)ImmutableMap.copyOf(parameterMap);
        }
    }
}

