/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.management.impl;

import com.google.common.collect.ImmutableSortedSet;
import io.wcm.config.core.management.ParameterPersistence;
import io.wcm.config.core.management.ParameterPersistenceData;
import io.wcm.config.core.management.impl.PersistenceTypeConversion;
import io.wcm.config.spi.ParameterPersistenceProvider;
import io.wcm.sling.commons.osgi.RankedServices;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;

@Component(immediate=true, metatype=false)
@Service(value={ParameterPersistence.class})
public final class ParameterPersistenceImpl
implements ParameterPersistence {
    @Reference(name="parameterPersistenceProvider", referenceInterface=ParameterPersistenceProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<ParameterPersistenceProvider> parameterPersistenceProviders = new RankedServices();

    @Override
    public ParameterPersistenceData getData(ResourceResolver resolver, String configurationId) {
        for (ParameterPersistenceProvider provider : this.parameterPersistenceProviders) {
            Map values = provider.get(resolver, configurationId);
            if (values == null) continue;
            return this.toData(values);
        }
        return ParameterPersistenceData.EMPTY;
    }

    private ParameterPersistenceData toData(Map<String, Object> valuesFromProvider) {
        String[] lockedParameterNamesArray = (String[])valuesFromProvider.get("wcmio:lockedParameterNames");
        if (lockedParameterNamesArray != null) {
            HashMap<String, Object> values = new HashMap<String, Object>(valuesFromProvider);
            values.remove("wcmio:lockedParameterNames");
            return new ParameterPersistenceData(values, (SortedSet<String>)ImmutableSortedSet.copyOf((Comparable[])lockedParameterNamesArray));
        }
        return new ParameterPersistenceData(valuesFromProvider, (SortedSet<String>)ImmutableSortedSet.of());
    }

    @Override
    public void storeData(ResourceResolver resolver, String configurationId, ParameterPersistenceData data) throws PersistenceException {
        this.storeData(resolver, configurationId, data, false);
    }

    @Override
    public void storeData(ResourceResolver resolver, String configurationId, ParameterPersistenceData data, boolean mergeWithExisting) throws PersistenceException {
        HashMap<String, Object> valuesToStore = new HashMap<String, Object>();
        if (mergeWithExisting) {
            ParameterPersistenceData existingData = this.getData(resolver, configurationId);
            this.putAllAndConvertToPersistenceTypes(valuesToStore, existingData.getValues());
            this.putAllAndConvertToPersistenceTypes(valuesToStore, data.getValues());
            TreeSet<String> lockedParameterNames = new TreeSet<String>();
            lockedParameterNames.addAll(existingData.getLockedParameterNames());
            lockedParameterNames.addAll(data.getLockedParameterNames());
            if (!lockedParameterNames.isEmpty()) {
                valuesToStore.put("wcmio:lockedParameterNames", this.toArray(lockedParameterNames));
            }
        } else {
            this.putAllAndConvertToPersistenceTypes(valuesToStore, data.getValues());
            if (!data.getLockedParameterNames().isEmpty()) {
                valuesToStore.put("wcmio:lockedParameterNames", this.toArray(data.getLockedParameterNames()));
            }
        }
        for (ParameterPersistenceProvider provider : this.parameterPersistenceProviders) {
            if (!provider.store(resolver, configurationId, valuesToStore)) continue;
            return;
        }
        throw new PersistenceException("No provider accepted to store parameter values for " + configurationId);
    }

    private String[] toArray(Set<String> set) {
        return set.toArray(new String[set.size()]);
    }

    private void putAllAndConvertToPersistenceTypes(Map<String, Object> destinationMap, Map<String, Object> sourceMap) {
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            destinationMap.put(entry.getKey(), this.toPersistenceValue(entry.getValue()));
        }
    }

    private Object toPersistenceValue(Object value) {
        if (value == null) {
            return value;
        }
        return PersistenceTypeConversion.toPersistenceType(value, value.getClass());
    }

    void bindParameterPersistenceProvider(ParameterPersistenceProvider service, Map<String, Object> props) {
        this.parameterPersistenceProviders.bind((Object)service, props);
    }

    void unbindParameterPersistenceProvider(ParameterPersistenceProvider service, Map<String, Object> props) {
        this.parameterPersistenceProviders.unbind((Object)service, props);
    }
}

