/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.management.impl;

import io.wcm.config.api.Parameter;
import io.wcm.config.core.management.ParameterOverride;
import io.wcm.config.core.util.TypeConversion;
import io.wcm.config.spi.ParameterOverrideProvider;
import io.wcm.sling.commons.osgi.RankedServices;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, metatype=false)
@Service(value={ParameterOverride.class})
public final class ParameterOverrideImpl
implements ParameterOverride {
    @Reference(name="parameterOverrideProvider", referenceInterface=ParameterOverrideProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<ParameterOverrideProvider> parameterOverrideProviders = new RankedServices();

    @Override
    public <T> T getOverrideSystemDefault(Parameter<T> parameter) {
        return this.getOverrideValue("default", parameter);
    }

    @Override
    public <T> T getOverrideForce(String configurationId, Parameter<T> parameter) {
        T value = this.getOverrideValue(configurationId, parameter);
        if (value == null) {
            value = this.getOverrideValue(null, parameter);
        }
        return value;
    }

    private <T> T getOverrideValue(String scope, Parameter<T> parameter) {
        String key = (scope != null ? "[" + scope + "]" : "") + parameter.getName();
        for (ParameterOverrideProvider provider : this.parameterOverrideProviders) {
            Map overrideMap = provider.getOverrideMap();
            String value = (String)overrideMap.get(key.toString());
            if (value == null) continue;
            return TypeConversion.stringToObject(value, parameter.getType());
        }
        return null;
    }

    void bindParameterOverrideProvider(ParameterOverrideProvider service, Map<String, Object> props) {
        this.parameterOverrideProviders.bind((Object)service, props);
    }

    void unbindParameterOverrideProvider(ParameterOverrideProvider service, Map<String, Object> props) {
        this.parameterOverrideProviders.unbind((Object)service, props);
    }
}

