/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.management.impl;

import com.google.common.collect.ImmutableList;
import io.wcm.config.api.Application;
import io.wcm.config.api.Configuration;
import io.wcm.config.core.impl.ConfigurationImpl;
import io.wcm.config.core.management.ApplicationFinder;
import io.wcm.config.core.management.ConfigurationFinder;
import io.wcm.config.core.management.ParameterResolver;
import io.wcm.config.spi.ConfigurationFinderStrategy;
import io.wcm.sling.commons.osgi.RankedServices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="wcm.io Configuration Finder", description="Configuration management service to detect context-specific configuration for resources.")
@Service(value={ConfigurationFinder.class})
public final class ConfigurationFinderImpl
implements ConfigurationFinder {
    @Property(label="Exclude paths", description="List of regular expression patterns for paths which should never be accepted as valie configuration Ids.", cardinality=0x7FFFFFFF, value={"^.*/tools$", "^.*/tools/config$"})
    static final String PROPERTY_EXCLUDE_PATH_PATTERNS = "excludePathPatterns";
    private static final String[] DEFAULT_EXCLUDE_PATH_PATTERNS = new String[]{"^.*/tools$", "^.*/tools/config$"};
    @Reference(name="configurationFinderStrategy", referenceInterface=ConfigurationFinderStrategy.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<ConfigurationFinderStrategy> finderStrategies = new RankedServices();
    @Reference
    private ApplicationFinder applicationFinder;
    @Reference
    private ParameterResolver parameterResolver;
    private List<Pattern> excludePathPatterns = ImmutableList.of();
    private static final Comparator<String> CONFIGURATION_ID_CLOSED_MATCH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o2.compareTo(o1);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ConfigurationFinderImpl.class);

    @Activate
    void activate(ComponentContext ctx) {
        String[] excludePathPatternStrings = PropertiesUtil.toStringArray(ctx.getProperties().get(PROPERTY_EXCLUDE_PATH_PATTERNS), (String[])DEFAULT_EXCLUDE_PATH_PATTERNS);
        this.excludePathPatterns = new ArrayList<Pattern>();
        for (String excludePathPatternString : excludePathPatternStrings) {
            try {
                this.excludePathPatterns.add(Pattern.compile(excludePathPatternString));
            }
            catch (PatternSyntaxException ex) {
                log.warn("Ignoring invalid regular expression: " + excludePathPatternString, (Throwable)ex);
            }
        }
    }

    @Override
    public Configuration find(Resource resource) {
        return this.find(resource, this.findApplicationId(resource));
    }

    @Override
    public Configuration find(Resource resource, String applicationId) {
        Set<String> allIds = this.getAllMatchingConfigurationIds(resource, applicationId);
        return this.readConfiguration(resource.getResourceResolver(), allIds);
    }

    @Override
    public Iterator<Configuration> findAll(Resource resource) {
        return this.findAll(resource, this.findApplicationId(resource));
    }

    private String findApplicationId(Resource resource) {
        Application application = this.applicationFinder.find(resource);
        if (application != null) {
            return application.getApplicationId();
        }
        return null;
    }

    @Override
    public Iterator<Configuration> findAll(Resource resource, String applicationId) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        LinkedList<String> allIds = new LinkedList<String>(this.getAllMatchingConfigurationIds(resource, applicationId));
        while (!allIds.isEmpty()) {
            configurations.add(this.readConfiguration(resource.getResourceResolver(), allIds));
            allIds.remove(0);
        }
        return configurations.iterator();
    }

    private Set<String> getAllMatchingConfigurationIds(Resource resource, String applicationId) {
        TreeSet<String> allIds = new TreeSet<String>(CONFIGURATION_ID_CLOSED_MATCH_COMPARATOR);
        for (ConfigurationFinderStrategy finderStrategy : this.finderStrategies) {
            if (!this.matchesApplicationId(applicationId, finderStrategy.getApplicationId())) continue;
            Iterator configurationIds = finderStrategy.findConfigurationIds(resource);
            while (configurationIds.hasNext()) {
                String configurationId = (String)configurationIds.next();
                if (!this.isAccepted(configurationId)) continue;
                allIds.add(configurationId);
            }
        }
        return allIds;
    }

    private boolean isAccepted(String configurationId) {
        for (Pattern pattern : this.excludePathPatterns) {
            if (!pattern.matcher(configurationId).matches()) continue;
            return false;
        }
        return true;
    }

    private boolean matchesApplicationId(String expected, String actual) {
        if (expected == null) {
            return true;
        }
        return StringUtils.equals((CharSequence)expected, (CharSequence)actual);
    }

    private Configuration readConfiguration(ResourceResolver resolver, Collection<String> configurationIds) {
        if (configurationIds.isEmpty()) {
            return null;
        }
        String topmostConfigurationId = configurationIds.iterator().next();
        Map<String, Object> values = this.parameterResolver.getEffectiveValues(resolver, configurationIds);
        return new ConfigurationImpl(topmostConfigurationId, values);
    }

    void bindConfigurationFinderStrategy(ConfigurationFinderStrategy service, Map<String, Object> props) {
        this.finderStrategies.bind((Object)service, props);
    }

    void unbindConfigurationFinderStrategy(ConfigurationFinderStrategy service, Map<String, Object> props) {
        this.finderStrategies.unbind((Object)service, props);
    }

    protected void bindApplicationFinder(ApplicationFinder applicationFinder) {
        this.applicationFinder = applicationFinder;
    }

    protected void unbindApplicationFinder(ApplicationFinder applicationFinder) {
        if (this.applicationFinder == applicationFinder) {
            this.applicationFinder = null;
        }
    }

    protected void bindParameterResolver(ParameterResolver parameterResolver) {
        this.parameterResolver = parameterResolver;
    }

    protected void unbindParameterResolver(ParameterResolver parameterResolver) {
        if (this.parameterResolver == parameterResolver) {
            this.parameterResolver = null;
        }
    }
}

