/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.impl;

import io.wcm.config.api.annotations.Application;
import io.wcm.config.core.impl.AdaptableUtil;
import io.wcm.config.core.management.ApplicationFinder;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.spi.ImplementationPicker;

@Component(immediate=true)
@Service(value={ImplementationPicker.class})
@Property(name="service.ranking", intValue={1000})
public class ApplicationImplementationPicker
implements ImplementationPicker {
    @Reference
    private ApplicationFinder applicationFinder;

    public Class<?> pick(Class<?> adapterType, Class<?>[] implementationsTypes, Object adaptable) {
        Class<?> classMatchingApplication = this.pickMatchingApplication(implementationsTypes, adaptable);
        if (classMatchingApplication != null) {
            return classMatchingApplication;
        }
        return this.pickFirstWithoutApplication(implementationsTypes);
    }

    private Class<?> pickMatchingApplication(Class<?>[] implementationsTypes, Object adaptable) {
        String applicationId = this.getApplicationId(adaptable);
        if (applicationId != null) {
            for (Class<?> clazz : implementationsTypes) {
                Application applicationAnnotation = clazz.getAnnotation(Application.class);
                if (applicationAnnotation == null || !StringUtils.equals((CharSequence)applicationId, (CharSequence)applicationAnnotation.value())) continue;
                return clazz;
            }
        }
        return null;
    }

    private String getApplicationId(Object adaptable) {
        io.wcm.config.api.Application application;
        Resource resource = AdaptableUtil.getResource(adaptable);
        if (resource != null && (application = this.applicationFinder.find(resource)) != null) {
            return application.getApplicationId();
        }
        return null;
    }

    private Class<?> pickFirstWithoutApplication(Class<?>[] implementationsTypes) {
        for (Class<?> clazz : implementationsTypes) {
            if (clazz.isAnnotationPresent(Application.class)) continue;
            return clazz;
        }
        return null;
    }

    protected void bindApplicationFinder(ApplicationFinder applicationFinder) {
        this.applicationFinder = applicationFinder;
    }

    protected void unbindApplicationFinder(ApplicationFinder applicationFinder) {
        if (this.applicationFinder == applicationFinder) {
            this.applicationFinder = null;
        }
    }
}

