/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.resolve;

import gg.jte.CodeResolver;
import gg.jte.compiler.IoUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DirectoryCodeResolver
implements CodeResolver {
    private final Path root;

    public DirectoryCodeResolver(Path root) {
        this.root = root;
    }

    @Override
    public String resolve(String name) {
        try {
            Path file = this.root.resolve(name);
            byte[] bytes = Files.readAllBytes(file);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean exists(String name) {
        Path file = this.root.resolve(name);
        return Files.exists(file, new LinkOption[0]);
    }

    @Override
    public long getLastModified(String name) {
        return this.getLastModified(this.root.resolve(name));
    }

    private long getLastModified(Path file) {
        return file.toFile().lastModified();
    }

    @Override
    public List<String> resolveAllTemplateNames() {
        List<String> list;
        block8: {
            Stream<Path> stream = Files.walk(this.root, FileVisitOption.FOLLOW_LINKS);
            try {
                list = stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(p -> this.root.relativize((Path)p).toString().replace('\\', '/')).filter(IoUtils::isTemplateFile).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to resolve all templates in " + this.root, e);
                }
            }
            stream.close();
        }
        return list;
    }

    public Path getRoot() {
        return this.root;
    }
}

