/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler.java;

import gg.jte.compiler.ParamInfo;
import gg.jte.compiler.TemplateParserVisitor;

public class JavaParamInfo {
    public static ParamInfo parse(String parameterString, TemplateParserVisitor visitor, int templateLine) {
        int typeStartIndex = -1;
        int typeEndIndex = -1;
        int nameStartIndex = -1;
        int nameEndIndex = -1;
        int defaultValueStartIndex = -1;
        int genericDepth = 0;
        int varArgsIndex = parameterString.indexOf("...");
        for (int i = 0; i < parameterString.length(); ++i) {
            char character = parameterString.charAt(i);
            if (character == '<') {
                ++genericDepth;
            } else if (character == '>') {
                --genericDepth;
            }
            if (genericDepth > 0) continue;
            if (typeStartIndex == -1) {
                if (Character.isWhitespace(character)) continue;
                typeStartIndex = i;
                continue;
            }
            if (typeEndIndex == -1) {
                if (!Character.isWhitespace(character) || i <= varArgsIndex) continue;
                typeEndIndex = i;
                continue;
            }
            if (nameStartIndex == -1) {
                if (Character.isWhitespace(character)) continue;
                nameStartIndex = i;
                continue;
            }
            if (nameEndIndex == -1) {
                if (!Character.isWhitespace(character) && character != '=') continue;
                nameEndIndex = i++;
                continue;
            }
            if (defaultValueStartIndex != -1 || Character.isWhitespace(character)) continue;
            defaultValueStartIndex = i;
        }
        String type = typeStartIndex == -1 || typeEndIndex == -1 ? "" : parameterString.substring(typeStartIndex, typeEndIndex);
        if (nameEndIndex == -1) {
            nameEndIndex = parameterString.length();
        }
        if (nameStartIndex == -1) {
            visitor.onError("Missing parameter name: '@param " + parameterString + "'");
        }
        String name = parameterString.substring(nameStartIndex, nameEndIndex);
        String defaultValue = defaultValueStartIndex == -1 ? null : parameterString.substring(defaultValueStartIndex);
        boolean varargs = varArgsIndex != -1;
        return new ParamInfo(type, name, defaultValue, varargs, templateLine);
    }
}

