/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler;

import gg.jte.CodeResolver;
import gg.jte.TemplateConfig;
import gg.jte.TemplateException;
import gg.jte.TemplateNotFoundException;
import gg.jte.compiler.ClassCompiler;
import gg.jte.compiler.ClassDefinition;
import gg.jte.compiler.ClassUtils;
import gg.jte.compiler.CodeGenerator;
import gg.jte.compiler.IoUtils;
import gg.jte.compiler.ParamInfo;
import gg.jte.compiler.TemplateDependency;
import gg.jte.compiler.TemplateParser;
import gg.jte.compiler.TemplateType;
import gg.jte.compiler.java.JavaClassCompiler;
import gg.jte.compiler.java.JavaCodeGenerator;
import gg.jte.output.FileOutput;
import gg.jte.runtime.ClassInfo;
import gg.jte.runtime.DebugInfo;
import gg.jte.runtime.Template;
import gg.jte.runtime.TemplateLoader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TemplateCompiler
extends TemplateLoader {
    public static final boolean DEBUG = false;
    private final TemplateConfig config;
    private final CodeResolver codeResolver;
    private final ClassLoader parentClassLoader;
    private final ConcurrentHashMap<String, LinkedHashSet<TemplateDependency>> templateDependencies = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ParamInfo>> paramOrder = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ClassInfo> templateByClassName = new ConcurrentHashMap();
    private List<String> classPath;

    public TemplateCompiler(TemplateConfig config, CodeResolver codeResolver, Path classDirectory, ClassLoader parentClassLoader) {
        super(classDirectory, config.packageName);
        this.config = config;
        this.codeResolver = codeResolver;
        this.parentClassLoader = parentClassLoader;
    }

    @Override
    public Template load(String name) {
        this.precompile(Collections.singletonList(name));
        return super.load(name);
    }

    @Override
    public Template hotReload(String name) {
        LinkedHashSet<ClassDefinition> classDefinitions = this.generate(Collections.singletonList(name), true);
        classDefinitions.removeIf(c -> !c.isChanged());
        if (!classDefinitions.isEmpty()) {
            this.precompileClasses(classDefinitions);
        }
        return super.load(name);
    }

    @Override
    protected ClassInfo getClassInfo(ClassLoader classLoader, String className) {
        return this.templateByClassName.get(className);
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.createClassLoader(this.parentClassLoader);
    }

    @Override
    public void cleanAll() {
        IoUtils.deleteDirectoryContent(this.classDirectory.resolve(this.config.packageName.replace('.', '/')));
    }

    @Override
    public List<String> generateAll() {
        LinkedHashSet<ClassDefinition> classDefinitions = this.generate(this.codeResolver.resolveAllTemplateNames(), false);
        return classDefinitions.stream().map(ClassDefinition::getSourceFileName).collect(Collectors.toList());
    }

    @Override
    public List<String> precompileAll() {
        return this.precompile(this.codeResolver.resolveAllTemplateNames());
    }

    private void generateNativeResources(LinkedHashSet<ClassDefinition> classDefinitions) {
        if (!this.config.generateNativeImageResources) {
            return;
        }
        if (this.config.resourceDirectory == null) {
            return;
        }
        if (classDefinitions.isEmpty()) {
            return;
        }
        String namespace = this.config.projectNamespace != null ? this.config.projectNamespace : this.packageName;
        Path nativeImageResourceRoot = this.config.resourceDirectory.resolve("META-INF/native-image/jte-generated/" + namespace);
        try (FileOutput properties = new FileOutput(nativeImageResourceRoot.resolve("native-image.properties"));){
            properties.writeContent("Args = -H:ReflectionConfigurationResources=${.}/reflection-config.json -H:ResourceConfigurationResources=${.}/resource-config.json\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (FileOutput reflection = new FileOutput(nativeImageResourceRoot.resolve("reflection-config.json"));){
            boolean first = true;
            reflection.writeContent("[\n");
            for (ClassDefinition classDefinition : classDefinitions) {
                if (!first) {
                    reflection.writeContent(",\n");
                }
                reflection.writeContent("{\n  \"name\":\"");
                reflection.writeContent(classDefinition.getName());
                reflection.writeContent("\",\n  \"allDeclaredMethods\":true,\n  \"allDeclaredFields\":true\n}");
                first = false;
            }
            reflection.writeContent("\n]\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (FileOutput resource = new FileOutput(nativeImageResourceRoot.resolve("resource-config.json"));){
            resource.writeContent("{\"resources\": {\"includes\": [{\"pattern\": \".*Generated\\\\.bin$\"}]}}\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<String> precompile(List<String> names) {
        LinkedHashSet<ClassDefinition> classDefinitions = this.generate(names, false);
        return this.precompileClasses(classDefinitions);
    }

    private List<String> precompileClasses(LinkedHashSet<ClassDefinition> classDefinitions) {
        List<String> classPath = this.getClassPath();
        HashSet<String> extensions = new HashSet<String>();
        String[] files = new String[classDefinitions.size()];
        int i = 0;
        for (ClassDefinition classDefinition : classDefinitions) {
            files[i++] = this.classDirectory.resolve(classDefinition.getSourceFileName()).toFile().getAbsolutePath();
            extensions.add(classDefinition.getExtension());
        }
        ArrayList<String> javaCompilerClassPath = new ArrayList<String>(classPath);
        javaCompilerClassPath.add(this.classDirectory.toAbsolutePath().toString());
        if (extensions.size() == 1) {
            ClassCompiler compiler = this.createCompiler((String)extensions.iterator().next());
            compiler.compile(files, javaCompilerClassPath, this.config, this.classDirectory, this.templateByClassName);
        } else if (extensions.size() > 1) {
            ClassCompiler kotlinCompiler = this.createCompiler("kt");
            kotlinCompiler.compile(files, classPath, this.config, this.classDirectory, this.templateByClassName);
            String[] javaFiles = (String[])Arrays.stream(files).filter(f -> f.endsWith(".java")).toArray(String[]::new);
            ClassCompiler javaCompiler = this.createCompiler("java");
            javaCompiler.compile(javaFiles, javaCompilerClassPath, this.config, this.classDirectory, this.templateByClassName);
        }
        return classDefinitions.stream().map(ClassDefinition::getSourceFileName).collect(Collectors.toList());
    }

    private List<String> getClassPath() {
        if (this.classPath == null) {
            this.classPath = this.calculateClassPath();
        }
        return this.classPath;
    }

    private List<String> calculateClassPath() {
        if (this.config.classPath != null) {
            return this.config.classPath;
        }
        ArrayList<String> classPath = new ArrayList<String>();
        ClassUtils.resolveClasspathFromClassLoader(this.parentClassLoader, classPath::add);
        return classPath;
    }

    ClassCompiler createCompiler(String extension) {
        if ("kt".equals(extension)) {
            try {
                Class<?> compilerClass = Class.forName("gg.jte.compiler.kotlin.KotlinClassCompiler");
                return (ClassCompiler)compilerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new TemplateException("Failed to create kotlin compiler. To compile .kte files, you need to add gg.jte:jte-kotlin to your project.", e);
            }
        }
        return new JavaClassCompiler();
    }

    private LinkedHashSet<ClassDefinition> generate(List<String> names, boolean trackChanges) {
        LinkedHashSet<ClassDefinition> classDefinitions = new LinkedHashSet<ClassDefinition>();
        for (String name : names) {
            LinkedHashSet<TemplateDependency> dependencies = this.initTemplateDependencies(name);
            ClassInfo templateInfo = this.generateTemplateCall(name, classDefinitions, dependencies, null);
            this.templateDependencies.put(name, dependencies);
            this.templateByClassName.put(templateInfo.name, templateInfo);
        }
        Path resourceDirectory = this.config.resourceDirectory == null ? this.classDirectory : this.config.resourceDirectory;
        for (ClassDefinition classDefinition : classDefinitions) {
            Path sourceFile = this.classDirectory.resolve(classDefinition.getSourceFileName());
            if (trackChanges) {
                String sourceFileContent = IoUtils.toString(sourceFile);
                classDefinition.setChanged(!classDefinition.getCode().equals(sourceFileContent));
            }
            try (FileOutput fileOutput = new FileOutput(sourceFile);){
                fileOutput.writeContent(classDefinition.getCode());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            List<byte[]> textParts = classDefinition.getBinaryTextParts();
            if (textParts.isEmpty()) continue;
            try {
                Files.createDirectories(resourceDirectory.resolve(classDefinition.getBinaryTextPartsFileName()).getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try {
                OutputStream os = Files.newOutputStream(resourceDirectory.resolve(classDefinition.getBinaryTextPartsFileName()), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                try {
                    for (byte[] textPart : textParts) {
                        os.write(textPart);
                    }
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.generateNativeResources(classDefinitions);
        return classDefinitions;
    }

    private LinkedHashSet<TemplateDependency> initTemplateDependencies(String name) {
        LinkedHashSet<TemplateDependency> templateDependencies = new LinkedHashSet<TemplateDependency>();
        templateDependencies.add(new TemplateDependency(name, this.codeResolver.getLastModified(name)));
        return templateDependencies;
    }

    public ClassInfo generateTemplateCall(String simpleName, String extension, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<TemplateDependency> templateDependencies, DebugInfo debugInfo) {
        String name = this.resolveTemplateName(simpleName, extension);
        try {
            return this.generateTemplateCall(name, classDefinitions, templateDependencies, debugInfo);
        }
        catch (TemplateNotFoundException e) {
            String alternativeName = this.resolveTemplateName(simpleName, "jte".equals(extension) ? "kte" : "jte");
            if (this.codeResolver.exists(alternativeName)) {
                return this.generateTemplateCall(alternativeName, classDefinitions, templateDependencies, debugInfo);
            }
            throw e;
        }
    }

    private String resolveTemplateName(String simpleName, String extension) {
        return simpleName.replace('.', '/') + "." + extension;
    }

    public ClassInfo generateTemplateCall(String name, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<TemplateDependency> templateDependencies, DebugInfo debugInfo) {
        templateDependencies.add(new TemplateDependency(name, this.codeResolver.getLastModified(name)));
        ClassInfo classInfo = new ClassInfo(name, this.config.packageName);
        ClassDefinition classDefinition = new ClassDefinition(classInfo.fullName, classInfo);
        if (classDefinitions.contains(classDefinition)) {
            return classInfo;
        }
        String code = this.resolveCode(name, debugInfo);
        classDefinitions.add(classDefinition);
        CodeGenerator codeGenerator = this.createCodeGenerator(classInfo, classDefinitions, templateDependencies);
        new TemplateParser(code, TemplateType.Template, codeGenerator, this.config, this.codeResolver).parse();
        classDefinition.setCode(codeGenerator.getCode(), codeGenerator.getBinaryTextParts());
        this.templateByClassName.put(classDefinition.getName(), classInfo);
        return classInfo;
    }

    private CodeGenerator createCodeGenerator(ClassInfo classInfo, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<TemplateDependency> templateDependencies) {
        if ("kte".equals(classInfo.extension)) {
            try {
                Class<?> compilerClass = Class.forName("gg.jte.compiler.kotlin.KotlinCodeGenerator");
                return (CodeGenerator)compilerClass.getConstructor(TemplateCompiler.class, TemplateConfig.class, ConcurrentHashMap.class, ClassInfo.class, LinkedHashSet.class, LinkedHashSet.class).newInstance(this, this.config, this.paramOrder, classInfo, classDefinitions, templateDependencies);
            }
            catch (Exception e) {
                throw new TemplateException("Failed to create kotlin generator. To handle .kte files, you need to add gg.jte:jte-kotlin to your project.", e);
            }
        }
        return new JavaCodeGenerator(this, this.config, this.paramOrder, classInfo, classDefinitions, templateDependencies);
    }

    private String resolveCode(String name, DebugInfo debugInfo) {
        String code = this.codeResolver.resolve(name);
        if (code == null) {
            String message = name + " not found";
            if (debugInfo != null) {
                message = message + ", referenced at " + debugInfo.name + ":" + debugInfo.line;
            }
            throw new TemplateNotFoundException(message);
        }
        return code;
    }

    @Override
    public boolean hasChanged(String name) {
        LinkedHashSet<TemplateDependency> dependencies = this.templateDependencies.get(name);
        if (dependencies == null) {
            return false;
        }
        for (TemplateDependency dependency : dependencies) {
            if (this.codeResolver.getLastModified(dependency.getName()) <= dependency.getLastModifiedTimestamp()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getTemplatesUsing(String name) {
        TemplateDependency dependency = new TemplateDependency(name, 0L);
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, LinkedHashSet<TemplateDependency>> dependencies : this.templateDependencies.entrySet()) {
            if (!dependencies.getValue().contains(dependency)) continue;
            result.add(dependencies.getKey());
        }
        return result;
    }
}

