/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler;

import gg.jte.compiler.CodeBuilder;
import gg.jte.compiler.TemplateParser;
import gg.jte.compiler.TemplateParserVisitor;
import java.util.List;

public interface CodeGenerator
extends TemplateParserVisitor {
    public String getCode();

    public List<byte[]> getBinaryTextParts();

    public int getCurrentTemplateLine();

    public static void writeAttributeMap(CodeBuilder code, TemplateParser.HtmlTag htmlTag) {
        code.append("gg.jte.runtime.TemplateUtils.toMap(");
        boolean firstWritten = false;
        for (TemplateParser.HtmlAttribute attribute : htmlTag.attributes) {
            if (firstWritten) {
                code.append(",");
            } else {
                firstWritten = true;
            }
            code.append("\"").append(attribute.name).append("\",");
            if (attribute.value == null) {
                if (attribute.bool) {
                    code.append("true");
                    continue;
                }
                code.append("null");
                continue;
            }
            String javaExpression = CodeGenerator.extractTemplateExpression(attribute.value);
            if (javaExpression != null) {
                code.append(javaExpression);
                continue;
            }
            code.append("\"");
            code.appendEscaped(attribute.value);
            code.append("\"");
        }
        code.append(")");
    }

    public static String extractTemplateExpression(String value) {
        int startIndex = value.indexOf("${");
        if (startIndex == -1) {
            return null;
        }
        int endIndex = value.lastIndexOf(125);
        if (endIndex == -1) {
            return null;
        }
        return value.substring(startIndex + 2, endIndex);
    }
}

