/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.templates.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.templates.RowMapper;
import io.vertx.sqlclient.templates.SqlTemplate;
import io.vertx.sqlclient.templates.TupleMapper;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class SqlTemplateImpl<I, R>
implements SqlTemplate<I, R> {
    public static final Collector<Row, Void, Void> NULL_COLLECTOR = Collector.of(() -> null, (v, row) -> {}, (a, b) -> null, new Collector.Characteristics[0]);
    protected final SqlClient client;
    protected final io.vertx.sqlclient.templates.impl.SqlTemplate sqlTemplate;
    protected final Function<I, Tuple> tupleMapper;
    protected Function<PreparedQuery<RowSet<Row>>, PreparedQuery<R>> queryMapper;

    public SqlTemplateImpl(SqlClient client, io.vertx.sqlclient.templates.impl.SqlTemplate sqlTemplate, Function<PreparedQuery<RowSet<Row>>, PreparedQuery<R>> queryMapper, Function<I, Tuple> tupleMapper) {
        this.client = client;
        this.sqlTemplate = sqlTemplate;
        this.queryMapper = queryMapper;
        this.tupleMapper = tupleMapper;
    }

    @Override
    public <T> SqlTemplate<T, R> mapFrom(TupleMapper<T> mapper) {
        return new SqlTemplateImpl<Object, R>(this.client, this.sqlTemplate, this.queryMapper, params -> mapper.map(this.sqlTemplate, this.sqlTemplate.numberOfParams(), params));
    }

    @Override
    public <U> SqlTemplate<I, SqlResult<U>> collecting(Collector<Row, ?, U> collector) {
        return new SqlTemplateImpl<I, R>(this.client, this.sqlTemplate, query -> query.collecting(collector), this.tupleMapper);
    }

    @Override
    public <U> SqlTemplate<I, RowSet<U>> mapTo(Class<U> type) {
        return this.mapTo((Row row) -> {
            JsonObject json = new JsonObject();
            for (int i = 0; i < row.size(); ++i) {
                json.getMap().put(row.getColumnName(i), row.getValue(i));
            }
            return json.mapTo(type);
        });
    }

    @Override
    public <U> SqlTemplate<I, RowSet<U>> mapTo(RowMapper<U> mapper) {
        return new SqlTemplateImpl<I, R>(this.client, this.sqlTemplate, query -> query.mapping(mapper::map), this.tupleMapper);
    }

    @Override
    public void execute(I parameters, Handler<AsyncResult<R>> handler) {
        this.queryMapper.apply((PreparedQuery<RowSet<Row>>)this.client.preparedQuery(this.sqlTemplate.getSql())).execute(this.tupleMapper.apply(parameters), handler);
    }

    @Override
    public Future<R> execute(I params) {
        return this.queryMapper.apply((PreparedQuery<RowSet<Row>>)this.client.preparedQuery(this.sqlTemplate.getSql())).execute(this.tupleMapper.apply(params));
    }

    @Override
    public void executeBatch(List<I> batch, Handler<AsyncResult<R>> handler) {
        this.queryMapper.apply((PreparedQuery<RowSet<Row>>)this.client.preparedQuery(this.sqlTemplate.getSql())).executeBatch(batch.stream().map(this.tupleMapper).collect(Collectors.toList()), handler);
    }

    @Override
    public Future<R> executeBatch(List<I> batch) {
        return this.queryMapper.apply((PreparedQuery<RowSet<Row>>)this.client.preparedQuery(this.sqlTemplate.getSql())).executeBatch(batch.stream().map(this.tupleMapper).collect(Collectors.toList()));
    }
}

