/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.netty.channel.EventLoopGroup;
import io.termd.core.readline.Keymap;
import io.termd.core.ssh.TtyCommand;
import io.termd.core.ssh.netty.AsyncAuth;
import io.termd.core.ssh.netty.AsyncUserAuthServiceFactory;
import io.termd.core.ssh.netty.NettyIoHandlerBridge;
import io.termd.core.ssh.netty.NettyIoServiceFactoryFactory;
import io.termd.core.tty.TtyConnection;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptionsBase;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.shell.impl.ShellAuth;
import io.vertx.ext.shell.term.SSHTermOptions;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.TermServer;
import io.vertx.ext.shell.term.impl.Helper;
import io.vertx.ext.shell.term.impl.SSHExec;
import io.vertx.ext.shell.term.impl.TermConnectionHandler;
import io.vertx.ext.shell.term.impl.VertxIoHandlerBridge;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.session.ServerConnectionServiceFactory;

public class SSHServer
implements TermServer {
    private static final int STATUS_STOPPED = 0;
    private static final int STATUS_STARTING = 1;
    private static final int STATUS_STARTED = 2;
    private static final int STATUS_STOPPING = 3;
    private final Vertx vertx;
    private final SSHTermOptions options;
    private Handler<Term> termHandler;
    private SshServer nativeServer;
    private final AtomicInteger status = new AtomicInteger(0);
    private ContextInternal listenContext;
    private AuthenticationProvider authProvider;
    private Handler<SSHExec> execHandler;

    public SSHServer(Vertx vertx, SSHTermOptions options) {
        this.vertx = vertx;
        this.options = new SSHTermOptions(options);
    }

    public SSHTermOptions getOptions() {
        return this.options;
    }

    public SshServer getNativeServer() {
        return this.nativeServer;
    }

    public Handler<SSHExec> getExecHandler() {
        return this.execHandler;
    }

    public TermServer setExecHandler(Handler<SSHExec> execHandler) {
        this.execHandler = execHandler;
        return this;
    }

    @Override
    public TermServer termHandler(Handler<Term> handler) {
        this.termHandler = handler;
        return this;
    }

    @Override
    public TermServer authenticationProvider(AuthenticationProvider provider) {
        this.authProvider = provider;
        return this;
    }

    @Override
    public SSHServer listen(Handler<AsyncResult<Void>> listenHandler) {
        if (!this.status.compareAndSet(0, 1)) {
            listenHandler.handle((Object)Future.failedFuture((String)("Invalid state:" + this.status.get())));
            return this;
        }
        if (this.options.getAuthOptions() != null) {
            this.authProvider = ShellAuth.load(this.vertx, this.options.getAuthOptions());
        }
        Charset defaultCharset = Charset.forName(this.options.getDefaultCharset());
        this.listenContext = (ContextInternal)this.vertx.getOrCreateContext();
        this.vertx.executeBlocking(fut -> {
            try {
                KeyCertOptions ksOptions = this.options.getKeyPairOptions();
                KeyStore ks = ksOptions instanceof KeyStoreOptionsBase ? ((KeyStoreOptionsBase)ksOptions).loadKeyStore(this.vertx) : (ksOptions instanceof PemKeyCertOptions ? ((PemKeyCertOptions)ksOptions).loadKeyStore(this.vertx) : null);
                if (ks == null) {
                    throw new VertxException("No key pair store configured");
                }
                String kpPassword = "";
                if (ksOptions instanceof JksOptions) {
                    kpPassword = ((JksOptions)ksOptions).getPassword();
                } else if (ksOptions instanceof PfxOptions) {
                    kpPassword = ((PfxOptions)ksOptions).getPassword();
                }
                final ArrayList<KeyPair> keyPairs = new ArrayList<KeyPair>();
                Enumeration<String> it = ks.aliases();
                while (it.hasMoreElements()) {
                    String alias = it.nextElement();
                    Key key = ks.getKey(alias, kpPassword.toCharArray());
                    if (!(key instanceof PrivateKey)) continue;
                    Certificate cert = ks.getCertificate(alias);
                    PublicKey publicKey = cert.getPublicKey();
                    keyPairs.add(new KeyPair(publicKey, (PrivateKey)key));
                }
                AbstractKeyPairProvider provider = new AbstractKeyPairProvider(){

                    public Iterable<KeyPair> loadKeys() {
                        return keyPairs;
                    }
                };
                Buffer inputrc = Helper.loadResource(this.vertx.fileSystem(), this.options.getIntputrc());
                if (inputrc == null) {
                    throw new VertxException("Could not load inputrc from " + this.options.getIntputrc());
                }
                Keymap keymap = new Keymap((InputStream)new ByteArrayInputStream(inputrc.getBytes()));
                TermConnectionHandler connectionHandler = new TermConnectionHandler(this.vertx, keymap, this.termHandler);
                this.nativeServer = SshServer.setUpDefaultServer();
                this.nativeServer.setShellFactory(() -> new TtyCommand(defaultCharset, connectionHandler::handle));
                Handler<SSHExec> execHandler = this.execHandler;
                if (execHandler != null) {
                    this.nativeServer.setCommandFactory(command -> new TtyCommand(defaultCharset, conn -> execHandler.handle((Object)new SSHExec(command, (TtyConnection)conn))));
                }
                this.nativeServer.setHost(this.options.getHost());
                this.nativeServer.setPort(this.options.getPort());
                this.nativeServer.setKeyPairProvider((KeyPairProvider)provider);
                this.nativeServer.setIoServiceFactoryFactory((IoServiceFactoryFactory)new NettyIoServiceFactoryFactory((EventLoopGroup)this.listenContext.nettyEventLoop(), (NettyIoHandlerBridge)new VertxIoHandlerBridge(this.listenContext)));
                this.nativeServer.setServiceFactories(Arrays.asList(ServerConnectionServiceFactory.INSTANCE, AsyncUserAuthServiceFactory.INSTANCE));
                if (this.authProvider == null) {
                    throw new VertxException("No authenticator");
                }
                this.nativeServer.setPasswordAuthenticator((username, userpass, session) -> {
                    AsyncAuth auth = new AsyncAuth();
                    this.listenContext.runOnContext(v -> this.authProvider.authenticate(new JsonObject().put("username", (Object)username).put("password", (Object)userpass), ar -> auth.setAuthed(ar.succeeded())));
                    throw auth;
                });
                this.nativeServer.start();
                this.status.set(2);
                fut.complete();
            }
            catch (Exception e) {
                this.status.set(0);
                fut.fail((Throwable)e);
            }
        }, listenHandler);
        return this;
    }

    @Override
    public int actualPort() {
        return this.nativeServer.getPort();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        if (!this.status.compareAndSet(2, 3)) {
            completionHandler.handle((Object)Future.failedFuture((String)("Invalid state:" + this.status.get())));
            return;
        }
        this.vertx.executeBlocking(fut -> {
            try {
                SshServer server = this.nativeServer;
                this.nativeServer = null;
                server.close();
                completionHandler.handle((Object)Future.succeededFuture());
            }
            catch (Exception t) {
                completionHandler.handle((Object)Future.failedFuture((Throwable)t));
            }
            finally {
                this.status.set(0);
            }
        }, completionHandler);
    }
}

