/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.termd.core.tty.TtyConnection;
import io.termd.core.util.Helper;
import io.vertx.core.Handler;
import io.vertx.ext.shell.term.Tty;

public class SSHExec
implements Tty {
    private final String command;
    private final TtyConnection conn;

    SSHExec(String command, TtyConnection conn) {
        this.command = command;
        this.conn = conn;
    }

    public String command() {
        return this.command;
    }

    public void end(int exit) {
        this.conn.close(exit);
    }

    @Override
    public String type() {
        return this.conn.terminalType();
    }

    @Override
    public int width() {
        return this.conn.size() != null ? this.conn.size().x() : -1;
    }

    @Override
    public int height() {
        return this.conn.size() != null ? this.conn.size().y() : -1;
    }

    @Override
    public Tty stdinHandler(Handler<String> handler) {
        if (handler != null) {
            this.conn.setStdinHandler(codePoints -> handler.handle((Object)Helper.fromCodePoints((int[])codePoints)));
        } else {
            this.conn.setStdinHandler(null);
        }
        return this;
    }

    @Override
    public Tty write(String data) {
        this.conn.write(data);
        return this;
    }

    @Override
    public Tty resizehandler(Handler<Void> handler) {
        if (handler != null) {
            this.conn.setSizeHandler(resize -> handler.handle(null));
        } else {
            this.conn.setSizeHandler(null);
        }
        return this;
    }
}

