/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.Shell;
import io.vertx.ext.shell.ShellServer;
import io.vertx.ext.shell.ShellServerOptions;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.command.CommandResolver;
import io.vertx.ext.shell.impl.ShellImpl;
import io.vertx.ext.shell.session.impl.SessionImpl;
import io.vertx.ext.shell.system.Process;
import io.vertx.ext.shell.system.impl.InternalCommandManager;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.TermServer;
import io.vertx.ext.shell.term.Tty;
import io.vertx.ext.shell.term.impl.SSHExec;
import io.vertx.ext.shell.term.impl.SSHServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ShellServerImpl
implements ShellServer {
    private final Vertx vertx;
    private final CopyOnWriteArrayList<CommandResolver> resolvers;
    private final InternalCommandManager commandManager;
    private final List<TermServer> termServers;
    private final long timeoutMillis;
    private final long reaperInterval;
    private final String welcomeMessage;
    private boolean closed = true;
    private long timerID = -1L;
    private final Map<String, ShellImpl> sessions;
    private final Promise<Void> sessionsClosed = Promise.promise();
    private Handler<Shell> shellHandler;

    public ShellServerImpl(Vertx vertx, ShellServerOptions options) {
        this.vertx = vertx;
        this.welcomeMessage = options.getWelcomeMessage();
        this.termServers = new ArrayList<TermServer>();
        this.timeoutMillis = options.getSessionTimeout();
        this.sessions = new ConcurrentHashMap<String, ShellImpl>();
        this.reaperInterval = options.getReaperInterval();
        this.resolvers = new CopyOnWriteArrayList();
        this.commandManager = new InternalCommandManager(this.resolvers);
        this.resolvers.add(() -> Arrays.asList(CommandBuilder.command("exit").processHandler((Handler<CommandProcess>)((Handler)process -> {})).build(vertx), CommandBuilder.command("logout").processHandler((Handler<CommandProcess>)((Handler)process -> {})).build(vertx), CommandBuilder.command("jobs").processHandler((Handler<CommandProcess>)((Handler)process -> {})).build(vertx), CommandBuilder.command("fg").processHandler((Handler<CommandProcess>)((Handler)process -> {})).build(vertx), CommandBuilder.command("bg").processHandler((Handler<CommandProcess>)((Handler)process -> {})).build(vertx)));
    }

    @Override
    public synchronized ShellServer registerCommandResolver(CommandResolver resolver) {
        this.resolvers.add(0, resolver);
        return this;
    }

    @Override
    public synchronized ShellServer registerTermServer(TermServer termServer) {
        this.termServers.add(termServer);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTerm(Term term) {
        ShellServerImpl shellServerImpl = this;
        synchronized (shellServerImpl) {
            if (this.closed) {
                term.close();
                return;
            }
        }
        ShellImpl session = this.createShell(term);
        session.setWelcome(this.welcomeMessage);
        session.closedPromise.future().onComplete(ar -> {
            boolean completeSessionClosed;
            ShellServerImpl shellServerImpl = this;
            synchronized (shellServerImpl) {
                this.sessions.remove(session.id);
                completeSessionClosed = this.sessions.isEmpty() && this.closed;
            }
            if (completeSessionClosed) {
                this.sessionsClosed.complete();
            }
        });
        session.init();
        if (this.shellHandler != null) {
            this.shellHandler.handle((Object)session);
        }
        this.sessions.put(session.id, session);
        session.readline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShellServer listen(Handler<AsyncResult<Void>> listenHandler) {
        List<TermServer> toStart;
        ShellServerImpl shellServerImpl = this;
        synchronized (shellServerImpl) {
            if (!this.closed) {
                throw new IllegalStateException("Server listening");
            }
            toStart = this.termServers;
        }
        AtomicInteger count = new AtomicInteger(toStart.size());
        if (count.get() == 0) {
            ShellServerImpl shellServerImpl2 = this;
            synchronized (shellServerImpl2) {
                this.closed = false;
            }
            listenHandler.handle((Object)Future.succeededFuture());
            return this;
        }
        AtomicBoolean failed = new AtomicBoolean();
        Handler handler = ar -> {
            if (ar.failed()) {
                failed.set(true);
            }
            if (count.decrementAndGet() == 0) {
                if (failed.get()) {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    toStart.forEach(TermServer::close);
                } else {
                    ShellServerImpl shellServerImpl = this;
                    synchronized (shellServerImpl) {
                        this.closed = false;
                    }
                    this.setTimer();
                    listenHandler.handle((Object)Future.succeededFuture());
                }
            }
        };
        toStart.forEach(termServer -> {
            if (termServer instanceof SSHServer) {
                ((SSHServer)termServer).setExecHandler((Handler<SSHExec>)((Handler)exec -> {
                    Process process = this.commandManager.createProcess(exec.command());
                    process.setSession(new SessionImpl());
                    process.setTty((Tty)exec);
                    process.terminatedHandler((Handler<Integer>)((Handler)exec::end));
                    process.run(true);
                }));
            }
            termServer.termHandler((Handler<Term>)((Handler)this::handleTerm));
            termServer.listen((Handler<AsyncResult<Void>>)handler);
        });
        return this;
    }

    private void evictSessions(long timerID) {
        long now = System.currentTimeMillis();
        HashSet<ShellImpl> toClose = new HashSet<ShellImpl>();
        for (ShellImpl session : this.sessions.values()) {
            if (now - session.lastAccessedTime() <= this.timeoutMillis) continue;
            toClose.add(session);
        }
        for (ShellImpl session : toClose) {
            session.close();
        }
        this.setTimer();
    }

    private synchronized void setTimer() {
        if (!this.closed && this.reaperInterval > 0L) {
            this.timerID = this.vertx.setTimer(this.reaperInterval, this::evictSessions);
        }
    }

    @Override
    public synchronized Shell createShell() {
        return this.createShell(null);
    }

    @Override
    public synchronized ShellImpl createShell(Term term) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        return new ShellImpl(term, this.commandManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        List<ShellImpl> toClose;
        List<Object> toStop;
        ShellServerImpl shellServerImpl = this;
        synchronized (shellServerImpl) {
            if (this.closed) {
                toStop = Collections.emptyList();
                toClose = Collections.emptyList();
            } else {
                this.closed = true;
                if (this.timerID != -1L) {
                    this.vertx.cancelTimer(this.timerID);
                }
                toStop = this.termServers;
                toClose = new ArrayList<ShellImpl>(this.sessions.values());
                if (toClose.isEmpty()) {
                    this.sessionsClosed.complete();
                }
            }
        }
        if (toStop.isEmpty() && toClose.isEmpty()) {
            completionHandler.handle((Object)Future.succeededFuture());
        } else {
            AtomicInteger count = new AtomicInteger(1 + toClose.size());
            Handler handler = ar -> {
                if (count.decrementAndGet() == 0) {
                    completionHandler.handle((Object)Future.succeededFuture());
                }
            };
            toClose.forEach(ShellImpl::close);
            toStop.forEach(termServer -> termServer.close((Handler<AsyncResult<Void>>)handler));
            this.sessionsClosed.future().onComplete(handler);
        }
    }

    @Override
    public void shellHandler(Handler<Shell> shellHandler) {
        this.shellHandler = shellHandler;
    }
}

