/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.annotations.CLIConfigurator;
import io.vertx.ext.shell.cli.CliToken;
import io.vertx.ext.shell.cli.Completion;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.command.impl.ProcessImpl;
import io.vertx.ext.shell.system.Process;
import java.util.Collections;
import java.util.List;

@VertxGen
public interface Command {
    @GenIgnore
    public static Command create(final Vertx vertx, final Class<? extends AnnotatedCommand> clazz) {
        final Context context = vertx.getOrCreateContext();
        final CLI cli = CLIConfigurator.define(clazz);
        cli.addOption(new Option().setArgName("help").setFlag(true).setShortName("h").setLongName("help").setDescription("this help").setHelp(true));
        boolean tmp = false;
        try {
            clazz.getDeclaredMethod("name", new Class[0]);
            tmp = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        final boolean overridesName = tmp;
        tmp = false;
        try {
            clazz.getDeclaredMethod("cli", new Class[0]);
            tmp = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        final boolean overridesCli = tmp;
        return new Command(){

            @Override
            public String name() {
                if (overridesName) {
                    try {
                        return ((AnnotatedCommand)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).name();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return cli.getName();
            }

            @Override
            public CLI cli() {
                if (overridesCli) {
                    try {
                        return ((AnnotatedCommand)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).cli();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return cli;
            }

            private void process(CommandProcess process) {
                AnnotatedCommand instance;
                try {
                    instance = (AnnotatedCommand)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    process.end();
                    return;
                }
                CLIConfigurator.inject((CommandLine)process.commandLine(), (Object)instance);
                instance.process(process);
            }

            @Override
            public Process createProcess(List<CliToken> args) {
                return new ProcessImpl(vertx, context, this, args, (Handler<CommandProcess>)((Handler)this::process));
            }

            @Override
            public void complete(Completion completion) {
                AnnotatedCommand instance;
                try {
                    instance = (AnnotatedCommand)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    Command.super.complete(completion);
                    return;
                }
                context.runOnContext(v -> {
                    try {
                        instance.complete(completion);
                    }
                    catch (Throwable t) {
                        completion.complete(Collections.emptyList());
                        throw t;
                    }
                });
            }
        };
    }

    default public String name() {
        return null;
    }

    default public CLI cli() {
        return null;
    }

    default public Process createProcess() {
        return this.createProcess(Collections.emptyList());
    }

    public Process createProcess(List<CliToken> var1);

    default public void complete(Completion completion) {
        completion.complete(Collections.emptyList());
    }
}

