/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.types.AbstractServiceReference;
import io.vertx.servicediscovery.types.JDBCDataSource;
import java.util.Objects;

public class JDBCDataSourceImpl
implements JDBCDataSource {
    @Override
    public String name() {
        return "jdbc";
    }

    @Override
    public ServiceReference get(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject configuration) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(record);
        Objects.requireNonNull(discovery);
        return new JdbcServiceReference(vertx, discovery, record, configuration);
    }

    private class JdbcServiceReference
    extends AbstractServiceReference<JDBCClient> {
        private final JsonObject config;

        JdbcServiceReference(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject config) {
            super(vertx, discovery, record);
            this.config = config;
        }

        @Override
        public JDBCClient retrieve() {
            JsonObject result = this.record().getMetadata().copy();
            result.mergeIn(this.record().getLocation());
            if (this.config != null) {
                result.mergeIn(this.config);
            }
            if (result.getBoolean("shared", Boolean.valueOf(false)).booleanValue()) {
                return JDBCClient.createShared((Vertx)this.vertx, (JsonObject)result);
            }
            return JDBCClient.create((Vertx)this.vertx, (JsonObject)result);
        }

        @Override
        protected void onClose() {
            ((JDBCClient)this.service).close();
        }
    }
}

