/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.spi.ServiceType;
import java.util.Objects;
import java.util.function.Function;

@VertxGen
public interface JDBCDataSource
extends ServiceType {
    public static final String TYPE = "jdbc";

    public static Record createRecord(String name, JsonObject location, JsonObject metadata) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(location);
        Record record = new Record().setName(name).setType(TYPE).setLocation(location);
        if (metadata != null) {
            record.setMetadata(metadata);
        }
        return record;
    }

    public static void getJDBCClient(ServiceDiscovery discovery, JsonObject filter, Handler<AsyncResult<JDBCClient>> resultHandler) {
        JDBCDataSource.getJDBCClient(discovery, filter).onComplete(resultHandler);
    }

    public static Future<JDBCClient> getJDBCClient(ServiceDiscovery discovery, JsonObject filter) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture(discovery.getReference((Record)res).get());
        });
    }

    public static void getJDBCClient(ServiceDiscovery discovery, Function<Record, Boolean> filter, Handler<AsyncResult<JDBCClient>> resultHandler) {
        JDBCDataSource.getJDBCClient(discovery, filter).onComplete(resultHandler);
    }

    public static Future<JDBCClient> getJDBCClient(ServiceDiscovery discovery, Function<Record, Boolean> filter) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture(discovery.getReference((Record)res).get());
        });
    }

    public static void getJDBCClient(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration, Handler<AsyncResult<JDBCClient>> resultHandler) {
        JDBCDataSource.getJDBCClient(discovery, filter, consumerConfiguration).onComplete(resultHandler);
    }

    public static Future<JDBCClient> getJDBCClient(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture(discovery.getReferenceWithConfiguration((Record)res, consumerConfiguration).get());
        });
    }

    public static void getJDBCClient(ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject consumerConfiguration, Handler<AsyncResult<JDBCClient>> resultHandler) {
        JDBCDataSource.getJDBCClient(discovery, filter, consumerConfiguration).onComplete(resultHandler);
    }

    public static Future<JDBCClient> getJDBCClient(ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject consumerConfiguration) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture(discovery.getReferenceWithConfiguration((Record)res, consumerConfiguration).get());
        });
    }
}

