/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class DefaultServiceDiscoveryBackend
implements ServiceDiscoveryBackend {
    private static final String MESSAGE_NO_REG_ID = "No registration id in the record";
    private AsyncMap<String, String> registry;
    private Vertx vertx;

    @Override
    public void init(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        if (!vertx.isClustered() || this.useLocalBackend()) {
            this.registry = (AsyncMap)vertx.sharedData().getLocalAsyncMap("service.registry").result();
        }
    }

    private boolean useLocalBackend() {
        String property = System.getProperty("vertx-service-discovery-backend-local");
        if (property != null) {
            return "true".equalsIgnoreCase(property);
        }
        property = System.getenv("VERTX-SERVICE-DISCOVERY-BACKEND-LOCAL");
        return "true".equalsIgnoreCase(property);
    }

    @Override
    public void store(Record record, Handler<AsyncResult<Record>> resultHandler) {
        String uuid = UUID.randomUUID().toString();
        if (record.getRegistration() != null) {
            throw new IllegalArgumentException("The record has already been registered");
        }
        record.setRegistration(uuid);
        this.retrieveRegistry((Handler<AsyncResult<AsyncMap<String, String>>>)((Handler)reg -> {
            if (reg.failed()) {
                resultHandler.handle(DefaultServiceDiscoveryBackend.failure(reg.cause()));
            } else {
                ((AsyncMap)reg.result()).put((Object)uuid, (Object)record.toJson().encode(), ar -> {
                    if (ar.succeeded()) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)record));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                });
            }
        }));
    }

    private synchronized void retrieveRegistry(Handler<AsyncResult<AsyncMap<String, String>>> handler) {
        if (this.registry != null) {
            handler.handle((Object)Future.succeededFuture(this.registry));
        } else {
            this.vertx.sharedData().getClusterWideMap("service.registry", ar -> {
                Class<DefaultServiceDiscoveryBackend> clazz = DefaultServiceDiscoveryBackend.class;
                synchronized (DefaultServiceDiscoveryBackend.class) {
                    if (ar.failed()) {
                        handler.handle(ar);
                    } else {
                        this.registry = (AsyncMap)ar.result();
                        handler.handle((Object)Future.succeededFuture(this.registry));
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            });
        }
    }

    @Override
    public void remove(Record record, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), MESSAGE_NO_REG_ID);
        this.remove(record.getRegistration(), resultHandler);
    }

    private static <T> Future<T> failure(Throwable e) {
        return Future.failedFuture((Throwable)new Exception("Unable to retrieve the registry", e));
    }

    @Override
    public void remove(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(uuid, MESSAGE_NO_REG_ID);
        this.retrieveRegistry((Handler<AsyncResult<AsyncMap<String, String>>>)((Handler)reg -> {
            if (reg.failed()) {
                resultHandler.handle(DefaultServiceDiscoveryBackend.failure(reg.cause()));
            } else {
                ((AsyncMap)reg.result()).remove((Object)uuid, ar -> {
                    if (ar.succeeded()) {
                        if (ar.result() == null) {
                            resultHandler.handle((Object)Future.failedFuture((String)("Record '" + uuid + "' not found")));
                        } else {
                            resultHandler.handle((Object)Future.succeededFuture((Object)new Record(new JsonObject((String)ar.result()))));
                        }
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                });
            }
        }));
    }

    @Override
    public void update(Record record, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), MESSAGE_NO_REG_ID);
        this.retrieveRegistry((Handler<AsyncResult<AsyncMap<String, String>>>)((Handler)reg -> {
            if (reg.failed()) {
                resultHandler.handle(DefaultServiceDiscoveryBackend.failure(reg.cause()));
            } else {
                ((AsyncMap)reg.result()).put((Object)record.getRegistration(), (Object)record.toJson().encode(), ar -> {
                    if (ar.succeeded()) {
                        resultHandler.handle((Object)Future.succeededFuture());
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                });
            }
        }));
    }

    @Override
    public void getRecords(Handler<AsyncResult<List<Record>>> resultHandler) {
        this.retrieveRegistry((Handler<AsyncResult<AsyncMap<String, String>>>)((Handler)reg -> {
            if (reg.failed()) {
                resultHandler.handle(DefaultServiceDiscoveryBackend.failure(reg.cause()));
            } else {
                ((AsyncMap)reg.result()).entries(ar -> {
                    if (ar.succeeded()) {
                        resultHandler.handle((Object)Future.succeededFuture(((Map)ar.result()).values().stream().map(s -> new Record(new JsonObject(s))).collect(Collectors.toList())));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                });
            }
        }));
    }

    @Override
    public void getRecord(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        this.retrieveRegistry((Handler<AsyncResult<AsyncMap<String, String>>>)((Handler)reg -> {
            if (reg.failed()) {
                resultHandler.handle(DefaultServiceDiscoveryBackend.failure(reg.cause()));
            } else {
                ((AsyncMap)reg.result()).get((Object)uuid, ar -> {
                    if (ar.succeeded()) {
                        if (ar.result() != null) {
                            resultHandler.handle((Object)Future.succeededFuture((Object)new Record(new JsonObject((String)ar.result()))));
                        } else {
                            resultHandler.handle((Object)Future.succeededFuture(null));
                        }
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                });
            }
        }));
    }
}

