/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.shareddata;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 *
 * An asynchronous map.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.AsyncMap original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.core.shareddata.AsyncMap.class)
public class AsyncMap<K,V> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncMap that = (AsyncMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<AsyncMap> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new AsyncMap((io.vertx.core.shareddata.AsyncMap) obj),
    AsyncMap::getDelegate
  );

  private final io.vertx.core.shareddata.AsyncMap delegate;
  public final io.vertx.lang.reactivex.TypeArg<K> __typeArg_0;
  public final io.vertx.lang.reactivex.TypeArg<V> __typeArg_1;
  
  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.reactivex.TypeArg.unknown();
    this.__typeArg_1 = io.vertx.lang.reactivex.TypeArg.unknown();
  }

  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate, io.vertx.lang.reactivex.TypeArg<K> typeArg_0, io.vertx.lang.reactivex.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.core.shareddata.AsyncMap getDelegate() {
    return delegate;
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later with the async result.
   */
  public void get(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.get(__typeArg_0.unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public Single<V> rxGet(K k) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<V>(handler -> {
      get(k, handler);
    });
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @param completionHandler - this will be called some time later to signify the value has been put
   */
  public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.unwrap(k), __typeArg_1.unwrap(v), completionHandler);
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Completable rxPut(K k, V v) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      put(k, v, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  public void put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.unwrap(k), __typeArg_1.unwrap(v), ttl, completionHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public Completable rxPut(K k, V v, long ttl) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      put(k, v, ttl, handler);
    });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @param completionHandler the handler
   */
  public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.unwrap(k), __typeArg_1.unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Single<V> rxPutIfAbsent(K k, V v) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<V>(handler -> {
      putIfAbsent(k, v, handler);
    });
  }

  /**
   * Link {@link io.vertx.reactivex.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  public void putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.unwrap(k), __typeArg_1.unwrap(v), ttl, new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Link {@link io.vertx.reactivex.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public Single<V> rxPutIfAbsent(K k, V v, long ttl) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<V>(handler -> {
      putIfAbsent(k, v, ttl, handler);
    });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  public void remove(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.remove(__typeArg_0.unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public Single<V> rxRemove(K k) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<V>(handler -> {
      remove(k, handler);
    });
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.removeIfPresent(__typeArg_0.unwrap(k), __typeArg_1.unwrap(v), resultHandler);
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Single<Boolean> rxRemoveIfPresent(K k, V v) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<Boolean>(handler -> {
      removeIfPresent(k, v, handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @param resultHandler the result handler will be passed the previous value
   */
  public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) { 
    delegate.replace(__typeArg_0.unwrap(k), __typeArg_1.unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @return 
   */
  public Single<V> rxReplace(K k, V v) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<V>(handler -> {
      replace(k, v, handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param resultHandler the result handler
   */
  public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.replaceIfPresent(__typeArg_0.unwrap(k), __typeArg_1.unwrap(oldValue), __typeArg_1.unwrap(newValue), resultHandler);
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return 
   */
  public Single<Boolean> rxReplaceIfPresent(K k, V oldValue, V newValue) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<Boolean>(handler -> {
      replaceIfPresent(k, oldValue, newValue, handler);
    });
  }

  /**
   * Clear all entries in the map
   * @param resultHandler called on completion
   */
  public void clear(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.clear(resultHandler);
  }

  /**
   * Clear all entries in the map
   * @return 
   */
  public Completable rxClear() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      clear(handler);
    });
  }

  /**
   * Provide the number of entries in the map
   * @param resultHandler handler which will receive the number of entries
   */
  public void size(Handler<AsyncResult<Integer>> resultHandler) { 
    delegate.size(resultHandler);
  }

  /**
   * Provide the number of entries in the map
   * @return 
   */
  public Single<Integer> rxSize() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<Integer>(handler -> {
      size(handler);
    });
  }


  public static <K,V>AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg) {
    return arg != null ? new AsyncMap<K,V>(arg) : null;
  }

  public static <K,V>AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg, io.vertx.lang.reactivex.TypeArg<K> __typeArg_K, io.vertx.lang.reactivex.TypeArg<V> __typeArg_V) {
    return arg != null ? new AsyncMap<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }
}
