/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.buffer.Buffer;

/**
 * An HTTP/2 frame.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpFrame original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.core.http.HttpFrame.class)
public class HttpFrame {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpFrame that = (HttpFrame) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<HttpFrame> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new HttpFrame((io.vertx.core.http.HttpFrame) obj),
    HttpFrame::getDelegate
  );

  private final io.vertx.core.http.HttpFrame delegate;
  
  public HttpFrame(io.vertx.core.http.HttpFrame delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.http.HttpFrame getDelegate() {
    return delegate;
  }

  /**
   * @return the 8-bit type of the frame
   */
  public int type() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.type();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the 8-bit flags specific to the frame
   */
  public int flags() { 
    if (cached_1 != null) {
      return cached_1;
    }
    int ret = delegate.flags();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the frame payload
   */
  public Buffer payload() { 
    if (cached_2 != null) {
      return cached_2;
    }
    Buffer ret = Buffer.newInstance(delegate.payload());
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private java.lang.Integer cached_1;
  private Buffer cached_2;

  public static  HttpFrame newInstance(io.vertx.core.http.HttpFrame arg) {
    return arg != null ? new HttpFrame(arg) : null;
  }
}
