/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.datagram;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.net.SocketAddress;

/**
 * A received datagram packet (UDP) which contains the data and information about the sender of the data itself.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramPacket original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.core.datagram.DatagramPacket.class)
public class DatagramPacket {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramPacket that = (DatagramPacket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<DatagramPacket> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new DatagramPacket((io.vertx.core.datagram.DatagramPacket) obj),
    DatagramPacket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramPacket delegate;
  
  public DatagramPacket(io.vertx.core.datagram.DatagramPacket delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.datagram.DatagramPacket getDelegate() {
    return delegate;
  }

  /**
   * Returns the {@link io.vertx.reactivex.core.net.SocketAddress} of the sender that sent
   * this {@link io.vertx.reactivex.core.datagram.DatagramPacket}.
   * @return the address of the sender
   */
  public SocketAddress sender() { 
    SocketAddress ret = SocketAddress.newInstance(delegate.sender());
    return ret;
  }

  /**
   * Returns the data of the {@link io.vertx.reactivex.core.datagram.DatagramPacket}
   * @return the data
   */
  public Buffer data() { 
    Buffer ret = Buffer.newInstance(delegate.data());
    return ret;
  }


  public static  DatagramPacket newInstance(io.vertx.core.datagram.DatagramPacket arg) {
    return arg != null ? new DatagramPacket(arg) : null;
  }
}
