/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ReadStreamSubscriber;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.http.HttpClientResponse;
import io.vertx.rxjava.core.http.HttpConnection;
import io.vertx.rxjava.core.http.HttpFrame;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpClientRequest.class)
public class HttpClientRequest
implements WriteStream<io.vertx.rxjava.core.buffer.Buffer> {
    public static final TypeArg<HttpClientRequest> __TYPE_ARG = new TypeArg(obj -> new HttpClientRequest((io.vertx.core.http.HttpClientRequest)obj), HttpClientRequest::getDelegate);
    private final io.vertx.core.http.HttpClientRequest delegate;
    private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;
    private MultiMap cached_0;
    private HttpConnection cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientRequest that = (HttpClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        this.delegate = delegate;
    }

    public HttpClientRequest(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientRequest)delegate;
    }

    public io.vertx.core.http.HttpClientRequest getDelegate() {
        return this.delegate;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write((Object)data.getDelegate(), handler);
    }

    @Override
    public void write(io.vertx.rxjava.core.buffer.Buffer data) {
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public HttpClientRequest setHost(String host) {
        this.delegate.setHost(host);
        return this;
    }

    public String getHost() {
        String ret = this.delegate.getHost();
        return ret;
    }

    public HttpClientRequest setPort(int port) {
        this.delegate.setPort(port);
        return this;
    }

    public int getPort() {
        int ret = this.delegate.getPort();
        return ret;
    }

    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.delegate.setFollowRedirects(followRedirects);
        return this;
    }

    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
        return this;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod getMethod() {
        HttpMethod ret = this.delegate.getMethod();
        return ret;
    }

    public HttpClientRequest setMethod(HttpMethod method) {
        this.delegate.setMethod(method);
        return this;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public String getURI() {
        String ret = this.delegate.getURI();
        return ret;
    }

    public HttpClientRequest setURI(String uri) {
        this.delegate.setURI(uri);
        return this;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpClientRequest putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    @Override
    public void write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, handler);
    }

    @Override
    public void write(String chunk) {
        this.write(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxWrite(String chunk) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(chunk, enc, handler);
    }

    public void write(String chunk, String enc) {
        this.write(chunk, enc, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxWrite(String chunk, String enc) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.write(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest earlyHintsHandler(Handler<MultiMap> handler) {
        this.delegate.earlyHintsHandler((Handler)new DelegatingHandler(handler, event -> MultiMap.newInstance(event)));
        return this;
    }

    public HttpClientRequest sendHead(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.sendHead(completionHandler);
        return this;
    }

    public HttpClientRequest sendHead() {
        return this.sendHead((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxSendHead() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.sendHead((Handler<AsyncResult<Void>>)fut)));
    }

    public void connect(Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.connect((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event))));
    }

    public void connect() {
        this.connect((Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxConnect() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect((Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public HttpClientRequest response(Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.response((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event))));
        return this;
    }

    public HttpClientRequest response() {
        return this.response((Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxResponse() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.response((Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event))));
    }

    public void send() {
        this.send((Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send((Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(String body, Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send(body, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event))));
    }

    public void send(String body) {
        this.send(body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(String body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(io.vertx.rxjava.core.buffer.Buffer body, Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send(body.getDelegate(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event))));
    }

    public void send(io.vertx.rxjava.core.buffer.Buffer body) {
        this.send(body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(io.vertx.rxjava.core.buffer.Buffer body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body, Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send(body.getDelegate(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event))));
    }

    public void send(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body) {
        this.send(body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(ReadStream<io.vertx.rxjava.core.buffer.Buffer> body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    public void send(Observable<io.vertx.rxjava.core.buffer.Buffer> body, Handler<AsyncResult<HttpClientResponse>> handler) {
        this.delegate.send(ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientResponse.newInstance(event))));
    }

    public void send(Observable<io.vertx.rxjava.core.buffer.Buffer> body) {
        this.send(body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(Observable<io.vertx.rxjava.core.buffer.Buffer> body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.send(body, (Handler<AsyncResult<HttpClientResponse>>)fut)));
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, handler);
    }

    @Override
    public void end(String chunk) {
        this.end(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd(String chunk) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk, enc, handler);
    }

    public void end(String chunk, String enc) {
        this.end(chunk, enc, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxEnd(String chunk, String enc) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(chunk, enc, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(chunk.getDelegate(), handler);
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer chunk) {
        this.end(chunk, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer chunk) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end(chunk, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Single<Void> rxEnd() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    public HttpClientRequest setTimeout(long timeoutMs) {
        this.delegate.setTimeout(timeoutMs);
        return this;
    }

    public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler((Handler)new DelegatingHandler(handler, event -> HttpClientRequest.newInstance(event)));
        return this;
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public boolean reset(long code, Throwable cause) {
        boolean ret = this.delegate.reset(code, cause);
        return ret;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public HttpClientRequest writeCustomFrame(int type, int flags, io.vertx.rxjava.core.buffer.Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public StreamPriority getStreamPriority() {
        StreamPriority ret = this.delegate.getStreamPriority();
        return ret;
    }

    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

