/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.uritemplate;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Holds a set of name/value pairs where each value can be a <code>String</code> or a <code>List<String></code> or a <code>Map<String, String></code>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.uritemplate.Variables original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.uritemplate.Variables.class)
public class Variables {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Variables that = (Variables) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Variables> __TYPE_ARG = new TypeArg<>(    obj -> new Variables((io.vertx.uritemplate.Variables) obj),
    Variables::getDelegate
  );

  private final io.vertx.uritemplate.Variables delegate;
  
  public Variables(io.vertx.uritemplate.Variables delegate) {
    this.delegate = delegate;
  }

  public Variables(Object delegate) {
    this.delegate = (io.vertx.uritemplate.Variables)delegate;
  }

  public io.vertx.uritemplate.Variables getDelegate() {
    return delegate;
  }


  /**
   * @return an empty instance
   */
  public static io.vertx.rxjava.uritemplate.Variables variables() { 
    io.vertx.rxjava.uritemplate.Variables ret = io.vertx.rxjava.uritemplate.Variables.newInstance((io.vertx.uritemplate.Variables)io.vertx.uritemplate.Variables.variables());
    return ret;
  }

  /**
   * Create an instance populated from a JSON object:
   *
   * <ul>
   *   <li><code>null</code> are conserved</li>
   *   <li><code>JsonArray</code> is converted to <code>List<String></code></li>
   *   <li><code>JsonObject</code> is converted to <code>Map<String, String></code></li>
   *   <li>any other value is converted to a string</li>
   * </ul>
   *
   * Note that nested JSON elements are converted to a string, so { "user": { "first_name": "John", "last_name": "Doe", "address" : { "city": "Paris", etc... } } }
   * flattens the JSON "address" to the string "{\"city\":\"Paris\",etc...}".
   * @param json the json that populates the returned variables
   * @return an instance populated from a JSON object
   */
  public static io.vertx.rxjava.uritemplate.Variables variables(io.vertx.core.json.JsonObject json) { 
    io.vertx.rxjava.uritemplate.Variables ret = io.vertx.rxjava.uritemplate.Variables.newInstance((io.vertx.uritemplate.Variables)io.vertx.uritemplate.Variables.variables(json));
    return ret;
  }

  /**
   * Set a single variable.
   * @param name the variable name
   * @param value the variable value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.uritemplate.Variables set(java.lang.String name, java.lang.String value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * Set a list variable.
   * @param name the variable name
   * @param value the variable value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.uritemplate.Variables set(java.lang.String name, java.util.List<java.lang.String> value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * Set a map variable.
   * @param name the variable name
   * @param value the variable value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.uritemplate.Variables set(java.lang.String name, java.util.Map<java.lang.String,java.lang.String> value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.uritemplate.Variables#addAll} but overwrites previous variables.
   * @param json 
   * @return 
   */
  public io.vertx.rxjava.uritemplate.Variables setAll(io.vertx.core.json.JsonObject json) { 
    delegate.setAll(json);
    return this;
  }

  /**
   * Populates with a JSON object:
   *
   * <ul>
   *   <li><code>null</code> are conserved</li>
   *   <li><code>JsonArray</code> is converted to <code>List<String></code></li>
   *   <li><code>JsonObject</code> is converted to <code>Map<String, String></code></li>
   *   <li>any other value is converted to a string</li>
   * </ul>
   *
   * Note that nested JSON elements are converted to a string, so { "user": { "first_name": "John", "last_name": "Doe", "address" : { "city": "Paris", etc... } } }
   * flattens the JSON "address" to the string "{\"city\":\"Paris\",etc...}".
   * @param json the json that populates the returned variables
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.uritemplate.Variables addAll(io.vertx.core.json.JsonObject json) { 
    delegate.addAll(json);
    return this;
  }

  public io.vertx.rxjava.uritemplate.Variables clear() { 
    delegate.clear();
    return this;
  }

  /**
   * @return the set of variable names
   */
  public java.util.Set<java.lang.String> names() { 
    java.util.Set<java.lang.String> ret = delegate.names();
    return ret;
  }

  /**
   * @param name 
   * @return the value of the variable <code>name</code>
   */
  public java.lang.Object get(java.lang.String name) { 
    java.lang.Object ret = (Object) delegate.get(name);
    return ret;
  }

  /**
   * @param name 
   * @return the single value of the variable <code>name</code>
   */
  public java.lang.String getSingle(java.lang.String name) { 
    java.lang.String ret = delegate.getSingle(name);
    return ret;
  }

  /**
   * @param name 
   * @return the list value of the variable <code>name</code>
   */
  public java.util.List<java.lang.String> getList(java.lang.String name) { 
    java.util.List<java.lang.String> ret = delegate.getList(name);
    return ret;
  }

  /**
   * @param name 
   * @return the map value of the variable <code>name</code>
   */
  public java.util.Map<java.lang.String,java.lang.String> getMap(java.lang.String name) { 
    java.util.Map<java.lang.String,java.lang.String> ret = delegate.getMap(name);
    return ret;
  }

  public static Variables newInstance(io.vertx.uritemplate.Variables arg) {
    return arg != null ? new Variables(arg) : null;
  }

}
