/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.sqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to the database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection extends io.vertx.rxjava.sqlclient.SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlConnection that = (SqlConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlConnection> __TYPE_ARG = new TypeArg<>(    obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection) obj),
    SqlConnection::getDelegate
  );

  private final io.vertx.sqlclient.SqlConnection delegate;
  
  public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public SqlConnection(Object delegate) {
    super((io.vertx.sqlclient.SqlConnection)delegate);
    this.delegate = (io.vertx.sqlclient.SqlConnection)delegate;
  }

  public io.vertx.sqlclient.SqlConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @param handler the handler notified with the prepared query asynchronously
   * @return 
   */
  public io.vertx.rxjava.sqlclient.SqlConnection prepare(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(sql, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    return this;
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @return 
   */
  public io.vertx.rxjava.sqlclient.SqlConnection prepare(java.lang.String sql) {
    return 
prepare(sql, ar -> { });
  }

    /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @return 
   */
  public rx.Single<io.vertx.rxjava.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      prepare(sql, fut);
    }));
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @param options 
   * @param handler the handler notified with the prepared query asynchronously
   * @return 
   */
  public io.vertx.rxjava.sqlclient.SqlConnection prepare(java.lang.String sql, io.vertx.sqlclient.PrepareOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(sql, options, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    return this;
  }

  /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @param options 
   * @return 
   */
  public io.vertx.rxjava.sqlclient.SqlConnection prepare(java.lang.String sql, io.vertx.sqlclient.PrepareOptions options) {
    return 
prepare(sql, options, ar -> { });
  }

    /**
   * Create a prepared statement using the given <code>sql</code> string.
   * @param sql the sql
   * @param options 
   * @return 
   */
  public rx.Single<io.vertx.rxjava.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql, io.vertx.sqlclient.PrepareOptions options) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      prepare(sql, options, fut);
    }));
  }

  /**
   * Set an handler called with connection errors.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.SqlConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set an handler called when the connection is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.SqlConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Begin a transaction and returns a {@link io.vertx.rxjava.sqlclient.Transaction} for controlling and tracking
   * this transaction.
   * <p/>
   * When the connection is explicitely closed, any inflight transaction is rollbacked.
   * @param handler 
   */
  public void begin(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.sqlclient.Transaction>> handler) { 
    delegate.begin(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.sqlclient.Transaction.newInstance((io.vertx.sqlclient.Transaction)event))));
  }

  /**
   * Begin a transaction and returns a {@link io.vertx.rxjava.sqlclient.Transaction} for controlling and tracking
   * this transaction.
   * <p/>
   * When the connection is explicitely closed, any inflight transaction is rollbacked.
   */
  public void begin() {
    begin(ar -> { });
  }

    /**
   * Begin a transaction and returns a {@link io.vertx.rxjava.sqlclient.Transaction} for controlling and tracking
   * this transaction.
   * <p/>
   * When the connection is explicitely closed, any inflight transaction is rollbacked.
   * @return 
   */
  public rx.Single<io.vertx.rxjava.sqlclient.Transaction> rxBegin() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      begin(fut);
    }));
  }

  /**
   * @return the current transaction if it exists, otherwise null
   */
  public io.vertx.rxjava.sqlclient.Transaction transaction() { 
    io.vertx.rxjava.sqlclient.Transaction ret = io.vertx.rxjava.sqlclient.Transaction.newInstance((io.vertx.sqlclient.Transaction)delegate.transaction());
    return ret;
  }

  /**
   * @return whether the connection uses SSL
   */
  public boolean isSSL() { 
    boolean ret = delegate.isSSL();
    return ret;
  }

  /**
   * Close the current connection after all the pending commands have been processed.
   * @param handler the completion handler
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the current connection after all the pending commands have been processed.
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Close the current connection after all the pending commands have been processed.
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * @return The static metadata about the backend database server for this connection
   */
  public io.vertx.rxjava.sqlclient.spi.DatabaseMetadata databaseMetadata() { 
    io.vertx.rxjava.sqlclient.spi.DatabaseMetadata ret = io.vertx.rxjava.sqlclient.spi.DatabaseMetadata.newInstance((io.vertx.sqlclient.spi.DatabaseMetadata)delegate.databaseMetadata());
    return ret;
  }

  public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
    return arg != null ? new SqlConnection(arg) : null;
  }

}
