/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.sqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A single row of the {@link io.vertx.rxjava.sqlclient.RowSet execution result rowset}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Row original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Row.class)
public class Row extends io.vertx.rxjava.sqlclient.Tuple {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Row that = (Row) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Row> __TYPE_ARG = new TypeArg<>(    obj -> new Row((io.vertx.sqlclient.Row) obj),
    Row::getDelegate
  );

  private final io.vertx.sqlclient.Row delegate;
  
  public Row(io.vertx.sqlclient.Row delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Row(Object delegate) {
    super((io.vertx.sqlclient.Row)delegate);
    this.delegate = (io.vertx.sqlclient.Row)delegate;
  }

  public io.vertx.sqlclient.Row getDelegate() {
    return delegate;
  }

  /**
   * Get a column name at <code>pos</code>.
   * @param pos the column position
   * @return the column name or <code>null</code>
   */
  public java.lang.String getColumnName(int pos) { 
    java.lang.String ret = delegate.getColumnName(pos);
    return ret;
  }

  /**
   * Get a column position for the given @code column}.
   * @param column the column name
   * @return the column name or <code>-1</code> if not found
   */
  public int getColumnIndex(java.lang.String column) { 
    int ret = delegate.getColumnIndex(column);
    return ret;
  }

  /**
   * Get a value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Object getValue(java.lang.String column) { 
    java.lang.Object ret = (Object) delegate.getValue(column);
    return ret;
  }

  /**
   * Get a boolean value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Boolean getBoolean(java.lang.String column) { 
    java.lang.Boolean ret = delegate.getBoolean(column);
    return ret;
  }

  /**
   * Get a short value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Short getShort(java.lang.String column) { 
    java.lang.Short ret = delegate.getShort(column);
    return ret;
  }

  /**
   * Get an integer value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Integer getInteger(java.lang.String column) { 
    java.lang.Integer ret = delegate.getInteger(column);
    return ret;
  }

  /**
   * Get a long value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Long getLong(java.lang.String column) { 
    java.lang.Long ret = delegate.getLong(column);
    return ret;
  }

  /**
   * Get a float value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Float getFloat(java.lang.String column) { 
    java.lang.Float ret = delegate.getFloat(column);
    return ret;
  }

  /**
   * Get a double value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Double getDouble(java.lang.String column) { 
    java.lang.Double ret = delegate.getDouble(column);
    return ret;
  }

  /**
   * Get a string value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.String getString(java.lang.String column) { 
    java.lang.String ret = delegate.getString(column);
    return ret;
  }

  /**
   * Get a JSON element for the given <code>column</code>, the element might be {@link io.vertx.rxjava.sqlclient.Tuple #JSON_NULL null} or one of the following types:
   * <ul>
   *   <li>String</li>
   *   <li>Number</li>
   *   <li>JsonObject</li>
   *   <li>JsonArray</li>
   *   <li>Boolean</li>
   * </ul>
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Object getJson(java.lang.String column) { 
    java.lang.Object ret = (Object) delegate.getJson(column);
    return ret;
  }

  /**
   * Get a  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.core.json.JsonObject getJsonObject(java.lang.String column) { 
    io.vertx.core.json.JsonObject ret = delegate.getJsonObject(column);
    return ret;
  }

  /**
   * Get a  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.core.json.JsonArray getJsonArray(java.lang.String column) { 
    io.vertx.core.json.JsonArray ret = delegate.getJsonArray(column);
    return ret;
  }

  /**
   * Get a buffer value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.rxjava.core.buffer.Buffer getBuffer(java.lang.String column) { 
    io.vertx.rxjava.core.buffer.Buffer ret = io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer(column));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.sqlclient.Tuple#get} but specifying the <code>column</code> instead of the position.
   * @param type 
   * @param column 
   * @return 
   */
  public <T> T get(java.lang.Class<T> type, java.lang.String column) { 
    T ret = (T)TypeArg.of(type).wrap(delegate.get(io.vertx.lang.rxjava.Helper.unwrap(type), column));
    return ret;
  }

  /**
   * Return a JSON object representation of the row.
   *
   * <p>Column names are mapped to JSON keys.
   *
   * <p>The following rules are applied for the column values:
   *
   * <ul>
   *   <li>number, boolean and string are preserved</li>
   *   <li>the <code>null</code> value is preserved</li>
   *   <li>JSON elements are preserved</li>
   *   <li><code>Buffer</code> are converted to base64 encoded strings</li>
   *   <li>array is mapped <code>JsonArray</code></li>
   *   <li>otherwise the type converted to a string</li>
   * </ul>
   * @return the json representation
   */
  public io.vertx.core.json.JsonObject toJson() { 
    io.vertx.core.json.JsonObject ret = delegate.toJson();
    return ret;
  }

  /**
   * Get  value for the given <code>column</code>.
   * @param column the column
   * @return the <code>column</code> value
   */
  public io.vertx.sqlclient.data.Numeric getNumeric(java.lang.String column) { 
    io.vertx.sqlclient.data.Numeric ret = delegate.getNumeric(column);
    return ret;
  }

  /**
   * Get a temporal value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.temporal.Temporal getTemporal(java.lang.String column) { 
    java.time.temporal.Temporal ret = delegate.getTemporal(column);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDate} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDate getLocalDate(java.lang.String column) { 
    java.time.LocalDate ret = delegate.getLocalDate(column);
    return ret;
  }

  /**
   * Get {@link java.time.LocalTime} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalTime getLocalTime(java.lang.String column) { 
    java.time.LocalTime ret = delegate.getLocalTime(column);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDateTime} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDateTime getLocalDateTime(java.lang.String column) { 
    java.time.LocalDateTime ret = delegate.getLocalDateTime(column);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetTime} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetTime getOffsetTime(java.lang.String column) { 
    java.time.OffsetTime ret = delegate.getOffsetTime(column);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetDateTime} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetDateTime getOffsetDateTime(java.lang.String column) { 
    java.time.OffsetDateTime ret = delegate.getOffsetDateTime(column);
    return ret;
  }

  /**
   * Get {@link java.util.UUID} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.util.UUID getUUID(java.lang.String column) { 
    java.util.UUID ret = delegate.getUUID(column);
    return ret;
  }

  /**
   * Get  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.math.BigDecimal getBigDecimal(java.lang.String column) { 
    java.math.BigDecimal ret = delegate.getBigDecimal(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Boolean} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Boolean[] getArrayOfBooleans(java.lang.String column) { 
    java.lang.Boolean[] ret = delegate.getArrayOfBooleans(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Short} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Short[] getArrayOfShorts(java.lang.String column) { 
    java.lang.Short[] ret = delegate.getArrayOfShorts(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Integer} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Integer[] getArrayOfIntegers(java.lang.String column) { 
    java.lang.Integer[] ret = delegate.getArrayOfIntegers(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Long} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Long[] getArrayOfLongs(java.lang.String column) { 
    java.lang.Long[] ret = delegate.getArrayOfLongs(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Float} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Float[] getArrayOfFloats(java.lang.String column) { 
    java.lang.Float[] ret = delegate.getArrayOfFloats(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Double} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Double[] getArrayOfDoubles(java.lang.String column) { 
    java.lang.Double[] ret = delegate.getArrayOfDoubles(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column
   * @return the <code>column</code> value
   */
  public io.vertx.sqlclient.data.Numeric[] getArrayOfNumerics(java.lang.String column) { 
    io.vertx.sqlclient.data.Numeric[] ret = delegate.getArrayOfNumerics(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.String} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.String[] getArrayOfStrings(java.lang.String column) { 
    java.lang.String[] ret = delegate.getArrayOfStrings(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.core.json.JsonObject[] getArrayOfJsonObjects(java.lang.String column) { 
    io.vertx.core.json.JsonObject[] ret = delegate.getArrayOfJsonObjects(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.core.json.JsonArray[] getArrayOfJsonArrays(java.lang.String column) { 
    io.vertx.core.json.JsonArray[] ret = delegate.getArrayOfJsonArrays(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.temporal.Temporal[] getArrayOfTemporals(java.lang.String column) { 
    java.time.temporal.Temporal[] ret = delegate.getArrayOfTemporals(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDate[] getArrayOfLocalDates(java.lang.String column) { 
    java.time.LocalDate[] ret = delegate.getArrayOfLocalDates(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalTime[] getArrayOfLocalTimes(java.lang.String column) { 
    java.time.LocalTime[] ret = delegate.getArrayOfLocalTimes(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDateTime[] getArrayOfLocalDateTimes(java.lang.String column) { 
    java.time.LocalDateTime[] ret = delegate.getArrayOfLocalDateTimes(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetTime[] getArrayOfOffsetTimes(java.lang.String column) { 
    java.time.OffsetTime[] ret = delegate.getArrayOfOffsetTimes(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetDateTime[] getArrayOfOffsetDateTimes(java.lang.String column) { 
    java.time.OffsetDateTime[] ret = delegate.getArrayOfOffsetDateTimes(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.util.UUID[] getArrayOfUUIDs(java.lang.String column) { 
    java.util.UUID[] ret = delegate.getArrayOfUUIDs(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.math.BigDecimal[] getArrayOfBigDecimals(java.lang.String column) { 
    java.math.BigDecimal[] ret = delegate.getArrayOfBigDecimals(column);
    return ret;
  }

  /**
   * Get an array of JSON elements for the given <code>column</code>, the element might be {@link io.vertx.rxjava.sqlclient.Tuple #JSON_NULL null} or one of the following types:
   * <ul>
   *   <li>String</li>
   *   <li>Number</li>
   *   <li>JsonObject</li>
   *   <li>JsonArray</li>
   *   <li>Boolean</li>
   * </ul>
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Object[] getArrayOfJsons(java.lang.String column) { 
    java.lang.Object[] ret = delegate.getArrayOfJsons(column);
    return ret;
  }

  /**
   * The JSON null literal value.
   * <br/>
   * It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
   * used when the database supports JSON types.
   */
  public static final java.lang.Object JSON_NULL = (Object) io.vertx.sqlclient.Row.JSON_NULL;
  public static Row newInstance(io.vertx.sqlclient.Row arg) {
    return arg != null ? new Row(arg) : null;
  }

}
