/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.sqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection pool which reuses a number of SQL connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Pool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Pool.class)
public class Pool extends io.vertx.rxjava.sqlclient.SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Pool that = (Pool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Pool> __TYPE_ARG = new TypeArg<>(    obj -> new Pool((io.vertx.sqlclient.Pool) obj),
    Pool::getDelegate
  );

  private final io.vertx.sqlclient.Pool delegate;
  
  public Pool(io.vertx.sqlclient.Pool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Pool(Object delegate) {
    super((io.vertx.sqlclient.Pool)delegate);
    this.delegate = (io.vertx.sqlclient.Pool)delegate;
  }

  public io.vertx.sqlclient.Pool getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>>(o1 -> io.vertx.rxjava.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.rxjava.sqlclient.Row>(o2 -> io.vertx.rxjava.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>>(o1 -> io.vertx.rxjava.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.rxjava.sqlclient.Row>(o2 -> io.vertx.rxjava.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

  /**
   * Like {@link io.vertx.rxjava.sqlclient.Pool#pool} with default options.
   * @param connectOptions 
   * @return 
   */
  public static io.vertx.rxjava.sqlclient.Pool pool(io.vertx.sqlclient.SqlConnectOptions connectOptions) { 
    io.vertx.rxjava.sqlclient.Pool ret = io.vertx.rxjava.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(connectOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.sqlclient.Pool#pool} with a Vert.x instance created automatically.
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.rxjava.sqlclient.Pool pool(io.vertx.sqlclient.SqlConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava.sqlclient.Pool ret = io.vertx.rxjava.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(database, options));
    return ret;
  }

  /**
   * Create a connection pool to the <code>database</code> with the given <code>options</code>.
   *
   * <p> A  will be selected among the drivers found on the classpath returning
   * <code>true</code> when  applied to the first options
   * of the list.
   * @param vertx the Vertx instance to be used with the connection pool
   * @param database the options used to create the connection pool, such as database hostname
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.rxjava.sqlclient.Pool pool(io.vertx.rxjava.core.Vertx vertx, io.vertx.sqlclient.SqlConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.rxjava.sqlclient.Pool ret = io.vertx.rxjava.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * Get a connection from the pool.
   * @param handler the handler that will get the connection result
   */
  public void getConnection(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.sqlclient.SqlConnection>> handler) { 
    delegate.getConnection(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event))));
  }

  /**
   * Get a connection from the pool.
   */
  public void getConnection() {
    getConnection(ar -> { });
  }

    /**
   * Get a connection from the pool.
   * @return 
   */
  public rx.Single<io.vertx.rxjava.sqlclient.SqlConnection> rxGetConnection() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      getConnection(fut);
    }));
  }

  /**
   * 
   *
   * A connection is borrowed from the connection pool when the query is executed and then immediately returned
   * to the pool after it completes.
   * @param sql 
   * @return 
   */
  public io.vertx.rxjava.sqlclient.Query<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> query(java.lang.String sql) { 
    io.vertx.rxjava.sqlclient.Query<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> ret = io.vertx.rxjava.sqlclient.Query.newInstance((io.vertx.sqlclient.Query)delegate.query(sql), TYPE_ARG_0);
    return ret;
  }

  /**
   * 
   *
   * A connection is borrowed from the connection pool when the query is executed and then immediately returned
   * to the pool after it completes.
   * @param sql 
   * @return 
   */
  public io.vertx.rxjava.sqlclient.PreparedQuery<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> preparedQuery(java.lang.String sql) { 
    io.vertx.rxjava.sqlclient.PreparedQuery<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> ret = io.vertx.rxjava.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.preparedQuery(sql), TYPE_ARG_1);
    return ret;
  }

  /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @param handler the result handler
   */
  public <T> void withTransaction(java.util.function.Function<io.vertx.rxjava.sqlclient.SqlConnection,io.vertx.core.Future<T>> function, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.withTransaction(new Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
        io.vertx.core.Future<T> ret = function.apply(io.vertx.rxjava.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg));
        return ret.map(val -> val);
      }
    }, handler);
  }

  /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   */
  public <T> void withTransaction(java.util.function.Function<io.vertx.rxjava.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) {
    withTransaction(function, ar -> { });
  }

    /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @return 
   */
  public <T> rx.Single<T> rxWithTransaction(java.util.function.Function<io.vertx.rxjava.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      withTransaction(function, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.sqlclient.Pool#withTransaction} but allows for setting the mode, defining how the acquired
   * connection is managed during the execution of the function.
   * @param txPropagation 
   * @param function 
   * @param handler 
   */
  public <T> void withTransaction(io.vertx.sqlclient.TransactionPropagation txPropagation, java.util.function.Function<io.vertx.rxjava.sqlclient.SqlConnection,io.vertx.core.Future<T>> function, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.withTransaction(txPropagation, new Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
        io.vertx.core.Future<T> ret = function.apply(io.vertx.rxjava.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg));
        return ret.map(val -> val);
      }
    }, handler);
  }

  /**
   * Like {@link io.vertx.rxjava.sqlclient.Pool#withTransaction} but allows for setting the mode, defining how the acquired
   * connection is managed during the execution of the function.
   * @param txPropagation 
   * @param function 
   */
  public <T> void withTransaction(io.vertx.sqlclient.TransactionPropagation txPropagation, java.util.function.Function<io.vertx.rxjava.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) {
    withTransaction(txPropagation, function, ar -> { });
  }

    /**
   * Like {@link io.vertx.rxjava.sqlclient.Pool#withTransaction} but allows for setting the mode, defining how the acquired
   * connection is managed during the execution of the function.
   * @param txPropagation 
   * @param function 
   * @return 
   */
  public <T> rx.Single<T> rxWithTransaction(io.vertx.sqlclient.TransactionPropagation txPropagation, java.util.function.Function<io.vertx.rxjava.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      withTransaction(txPropagation, function, fut);
    }));
  }

  /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @param handler the result handler
   */
  public <T> void withConnection(java.util.function.Function<io.vertx.rxjava.sqlclient.SqlConnection,io.vertx.core.Future<T>> function, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.withConnection(new Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
        io.vertx.core.Future<T> ret = function.apply(io.vertx.rxjava.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg));
        return ret.map(val -> val);
      }
    }, handler);
  }

  /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   */
  public <T> void withConnection(java.util.function.Function<io.vertx.rxjava.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) {
    withConnection(function, ar -> { });
  }

    /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @return 
   */
  public <T> rx.Single<T> rxWithConnection(java.util.function.Function<io.vertx.rxjava.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      withConnection(function, fut);
    }));
  }

  /**
   * Close the pool and release the associated resources.
   * @param handler the completion handler
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the pool and release the associated resources.
   */
  public void close() {
    close(ar -> { });
  }

    /**
   * Close the pool and release the associated resources.
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Set an handler called when the pool has established a connection to the database.
   *
   * <p> This handler allows interactions with the database before the connection is added to the pool.
   *
   * <p> When the handler has finished, it must call {@link io.vertx.rxjava.sqlclient.SqlClient#close} to release the connection
   * to the pool.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Pool connectHandler(io.vertx.core.Handler<io.vertx.rxjava.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  /**
   * Replace the default pool connection provider, the new <code>provider</code> returns a future connection for a
   * given .
   *
   * <p> A {@link io.vertx.sqlclient.spi.ConnectionFactory} can be used as connection provider.
   * @param provider the new connection provider
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.sqlclient.Pool connectionProvider(java.util.function.Function<io.vertx.rxjava.core.Context,io.vertx.core.Future<io.vertx.rxjava.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
        io.vertx.core.Future<io.vertx.rxjava.sqlclient.SqlConnection> ret = provider.apply(io.vertx.rxjava.core.Context.newInstance((io.vertx.core.Context)arg));
        return ret.map(val -> val.getDelegate());
      }
    });
    return this;
  }

  /**
   * @return the current pool size approximation
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  public static Pool newInstance(io.vertx.sqlclient.Pool arg) {
    return arg != null ? new Pool(arg) : null;
  }

}
