/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.redis.client;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A simple Redis client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisConnection.class)
public class RedisConnection implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.redis.client.Response> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisConnection that = (RedisConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisConnection> __TYPE_ARG = new TypeArg<>(    obj -> new RedisConnection((io.vertx.redis.client.RedisConnection) obj),
    RedisConnection::getDelegate
  );

  private final io.vertx.redis.client.RedisConnection delegate;
  
  public RedisConnection(io.vertx.redis.client.RedisConnection delegate) {
    this.delegate = delegate;
  }

  public RedisConnection(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisConnection)delegate;
  }

  public io.vertx.redis.client.RedisConnection getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.redis.client.Response> observable;

  public synchronized Observable<io.vertx.rxjava.redis.client.Response> toObservable() {
    if (observable == null) {
      Function<io.vertx.redis.client.Response, io.vertx.rxjava.redis.client.Response> conv = io.vertx.rxjava.redis.client.Response::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private static final TypeArg<io.vertx.rxjava.redis.client.Response> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.redis.client.Response>(o1 -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.redis.client.Response> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.redis.client.Response> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.redis.client.Response> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.redis.client.Response> dst) {
    pipeTo(dst, ar -> { });
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public rx.Single<java.lang.Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.redis.client.Response> dst) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.redis.client.RedisConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.redis.client.RedisConnection handler(io.vertx.core.Handler<io.vertx.rxjava.redis.client.Response> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event)));
    return this;
  }

  /**
   * 
   * @return 
   */
  public io.vertx.rxjava.redis.client.RedisConnection pause() { 
    delegate.pause();
    return this;
  }

  /**
   * 
   * @return 
   */
  public io.vertx.rxjava.redis.client.RedisConnection resume() { 
    delegate.resume();
    return this;
  }

  /**
   * 
   * @param amount 
   * @return 
   */
  public io.vertx.rxjava.redis.client.RedisConnection fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * 
   * @param endHandler 
   * @return 
   */
  public io.vertx.rxjava.redis.client.RedisConnection endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @param onSend the asynchronous result handler.
   * @return fluent self.
   */
  public io.vertx.rxjava.redis.client.RedisConnection send(io.vertx.rxjava.redis.client.Request command, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.rxjava.redis.client.Response>> onSend) { 
    delegate.send(command.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(onSend, ar -> ar.map(event -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)event))));
    return this;
  }

  /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @return fluent self.
   */
  public io.vertx.rxjava.redis.client.RedisConnection send(io.vertx.rxjava.redis.client.Request command) {
    return 
send(command, ar -> { });
  }

    /**
   * Send the given command to the redis server or cluster.
   * @param command the command to send
   * @return fluent self.
   */
  public rx.Single<io.vertx.rxjava.redis.client.Response> rxSend(io.vertx.rxjava.redis.client.Request command) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      send(command, fut);
    }));
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @param onSend the asynchronous result handler.
   * @return fluent self.
   */
  public io.vertx.rxjava.redis.client.RedisConnection batch(java.util.List<io.vertx.rxjava.redis.client.Request> commands, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<io.vertx.rxjava.redis.client.Response>>> onSend) { 
    delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), new io.vertx.lang.rx.DelegatingHandler<>(onSend, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.rxjava.redis.client.Response.newInstance((io.vertx.redis.client.Response)elt)).collect(Collectors.toList()))));
    return this;
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return fluent self.
   */
  public io.vertx.rxjava.redis.client.RedisConnection batch(java.util.List<io.vertx.rxjava.redis.client.Request> commands) {
    return 
batch(commands, ar -> { });
  }

    /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * @param commands list of command to send
   * @return fluent self.
   */
  public rx.Single<java.util.List<io.vertx.rxjava.redis.client.Response>> rxBatch(java.util.List<io.vertx.rxjava.redis.client.Request> commands) { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      batch(commands, fut);
    }));
  }

  /**
   * Closes the connection or returns to the pool.
   * @param onClose 
   * @return 
   */
  public io.vertx.rxjava.redis.client.RedisConnection close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> onClose) { 
    delegate.close(onClose);
    return this;
  }

  /**
   * Closes the connection or returns to the pool.
   * @return 
   */
  public io.vertx.rxjava.redis.client.RedisConnection close() {
    return 
close(ar -> { });
  }

    /**
   * Closes the connection or returns to the pool.
   * @return 
   */
  public rx.Single<java.lang.Void> rxClose() { 
    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Flag to notify if the pending message queue (commands in transit) is full.
   *
   * When the pending message queue is full and a new send command is issued it will result in a exception to be thrown.
   * Checking this flag before sending can allow the application to wait before sending the next message.
   * @return true is queue is full.
   */
  public boolean pendingQueueFull() { 
    boolean ret = delegate.pendingQueueFull();
    return ret;
  }

  public static RedisConnection newInstance(io.vertx.redis.client.RedisConnection arg) {
    return arg != null ? new RedisConnection(arg) : null;
  }

}
